/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.internal;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.http.HttpResponse;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.services.s3.model.AmazonS3Exception;
import com.amazonaws.util.IOUtils;
import com.amazonaws.util.XpathUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class S3ErrorResponseHandler
implements HttpResponseHandler<AmazonServiceException> {
    private static final Log log = LogFactory.getLog(S3ErrorResponseHandler.class);

    public AmazonServiceException handle(HttpResponse errorResponse) throws IOException {
        InputStream is = errorResponse.getContent();
        if (is == null) {
            return this.newAmazonS3Exception(errorResponse.getStatusText(), errorResponse);
        }
        String content = "";
        try {
            content = IOUtils.toString((InputStream)is);
        }
        catch (IOException ex) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Failed in reading the error response", (Throwable)ex);
            }
            return this.newAmazonS3Exception(errorResponse.getStatusText(), errorResponse);
        }
        try {
            Document document = XpathUtils.documentFrom((String)content);
            String message = XpathUtils.asString((String)"Error/Message", (Node)document);
            String errorCode = XpathUtils.asString((String)"Error/Code", (Node)document);
            String requestId = XpathUtils.asString((String)"Error/RequestId", (Node)document);
            String extendedRequestId = XpathUtils.asString((String)"Error/HostId", (Node)document);
            AmazonS3Exception ase = new AmazonS3Exception(message);
            int statusCode = errorResponse.getStatusCode();
            ase.setStatusCode(statusCode);
            ase.setErrorType(this.errorTypeOf(statusCode));
            ase.setErrorCode(errorCode);
            ase.setRequestId(requestId);
            ase.setExtendedRequestId(extendedRequestId);
            ase.setCloudFrontId((String)errorResponse.getHeaders().get("X-Amz-Cf-Id"));
            return ase;
        }
        catch (Exception ex) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Failed in parsing the response as XML: " + content), (Throwable)ex);
            }
            return this.newAmazonS3Exception(content, errorResponse);
        }
    }

    private AmazonS3Exception newAmazonS3Exception(String errmsg, HttpResponse httpResponse) {
        AmazonS3Exception ase = new AmazonS3Exception(errmsg);
        int statusCode = httpResponse.getStatusCode();
        ase.setErrorCode(statusCode + " " + httpResponse.getStatusText());
        ase.setStatusCode(statusCode);
        ase.setErrorType(this.errorTypeOf(statusCode));
        Map headers = httpResponse.getHeaders();
        ase.setRequestId((String)headers.get("x-amz-request-id"));
        ase.setExtendedRequestId((String)headers.get("x-amz-id-2"));
        ase.setCloudFrontId((String)headers.get("X-Amz-Cf-Id"));
        HashMap<String, String> additionalDetails = new HashMap<String, String>();
        additionalDetails.put("x-amz-bucket-region", (String)headers.get("x-amz-bucket-region"));
        ase.setAdditionalDetails(additionalDetails);
        return ase;
    }

    private AmazonServiceException.ErrorType errorTypeOf(int statusCode) {
        return statusCode >= 500 ? AmazonServiceException.ErrorType.Service : AmazonServiceException.ErrorType.Client;
    }

    public boolean needsConnectionLeftOpen() {
        return false;
    }
}

