/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.s3.transferutility;

import android.util.Log;
import com.amazonaws.event.ProgressEvent;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferDBUtil;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferProgress;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferProgressUpdatingListener;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferState;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.UploadPartRequest;
import com.amazonaws.services.s3.model.UploadPartResult;
import java.util.concurrent.Callable;

class UploadPartTask
implements Callable<Boolean> {
    private static final String TAG = "UploadPartTask";
    private final UploadPartRequest request;
    private final TransferProgress transferProgress;
    private final AmazonS3 s3;
    private final TransferDBUtil dbUtil;

    public UploadPartTask(UploadPartRequest request, TransferProgress transferProgress, AmazonS3 s3, TransferDBUtil dbUtil) {
        this.request = request;
        this.transferProgress = transferProgress;
        this.s3 = s3;
        this.dbUtil = dbUtil;
    }

    @Override
    public Boolean call() throws Exception {
        this.request.setGeneralProgressListener(new TransferProgressUpdatingListener(this.transferProgress){

            @Override
            public void progressChanged(ProgressEvent progressEvent) {
                super.progressChanged(progressEvent);
                UploadPartTask.this.dbUtil.updateBytesTransferred(UploadPartTask.this.request.getMainUploadId(), UploadPartTask.this.transferProgress.getBytesTransferred(), false);
            }
        });
        UploadPartResult putPartResult = null;
        try {
            putPartResult = this.s3.uploadPart(this.request);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"Encountered error uploading part", (Throwable)e);
            this.dbUtil.updateState(this.request.getId(), TransferState.FAILED);
            return false;
        }
        this.dbUtil.updateState(this.request.getId(), TransferState.PART_COMPLETED);
        String etag = putPartResult.getETag();
        this.dbUtil.updateETag(this.request.getId(), etag);
        return true;
    }
}

