/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.s3.transferutility;

import android.database.Cursor;
import com.amazonaws.mobileconnectors.s3.transferutility.DownloadTask;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferDBUtil;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferState;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferThreadPool;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferType;
import com.amazonaws.mobileconnectors.s3.transferutility.UploadTask;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.AbortMultipartUploadRequest;
import java.util.concurrent.Future;

class TransferRecord {
    public int id;
    public int mainUploadId;
    public int isRequesterPays;
    public int isMultipart;
    public int isLastPart;
    public int isEncrypted;
    public int partNumber;
    public long bytesTotal;
    public long bytesCurrent;
    public long speed;
    public long rangeStart;
    public long rangeLast;
    public long fileOffset;
    public TransferType type;
    public TransferState state;
    public String bucketName;
    public String key;
    public String versionId;
    public String file;
    public String multipartId;
    public String eTag;
    public String headerContentType;
    public String headerContentLanguage;
    public String headerContentDisposition;
    public String headerContentEncoding;
    public String headerCacheControl;
    public String headerExpire;
    private final AmazonS3 s3;
    private Future<?> submittedTask;

    public TransferRecord(int id, AmazonS3 s3) {
        this.id = id;
        this.s3 = s3;
    }

    public void updateFromDB(Cursor c) {
        this.id = c.getInt(c.getColumnIndexOrThrow("_id"));
        this.mainUploadId = c.getInt(c.getColumnIndexOrThrow("main_upload_id"));
        this.type = TransferType.getType(c.getString(c.getColumnIndexOrThrow("type")));
        this.state = TransferState.getState(c.getString(c.getColumnIndexOrThrow("state")));
        this.bucketName = c.getString(c.getColumnIndexOrThrow("bucket_name"));
        this.key = c.getString(c.getColumnIndexOrThrow("key"));
        this.versionId = c.getString(c.getColumnIndexOrThrow("version_id"));
        this.bytesTotal = c.getLong(c.getColumnIndexOrThrow("bytes_total"));
        this.bytesCurrent = c.getLong(c.getColumnIndexOrThrow("bytes_current"));
        this.speed = c.getLong(c.getColumnIndexOrThrow("speed"));
        this.isRequesterPays = c.getInt(c.getColumnIndexOrThrow("is_requester_pays"));
        this.isMultipart = c.getInt(c.getColumnIndexOrThrow("is_multipart"));
        this.isLastPart = c.getInt(c.getColumnIndexOrThrow("is_last_part"));
        this.isEncrypted = c.getInt(c.getColumnIndexOrThrow("is_encrypted"));
        this.partNumber = c.getInt(c.getColumnIndexOrThrow("part_num"));
        this.eTag = c.getString(c.getColumnIndexOrThrow("etag"));
        this.file = c.getString(c.getColumnIndexOrThrow("file"));
        this.multipartId = c.getString(c.getColumnIndexOrThrow("multipart_id"));
        this.rangeStart = c.getLong(c.getColumnIndexOrThrow("range_start"));
        this.rangeLast = c.getLong(c.getColumnIndexOrThrow("range_last"));
        this.fileOffset = c.getLong(c.getColumnIndexOrThrow("file_offset"));
        this.headerContentType = c.getString(c.getColumnIndexOrThrow("header_content_type"));
        this.headerContentLanguage = c.getString(c.getColumnIndexOrThrow("header_content_language"));
        this.headerContentDisposition = c.getString(c.getColumnIndexOrThrow("header_content_disposition"));
        this.headerContentEncoding = c.getString(c.getColumnIndexOrThrow("header_content_encoding"));
        this.headerCacheControl = c.getString(c.getColumnIndexOrThrow("header_cache_control"));
        this.headerExpire = c.getString(c.getColumnIndexOrThrow("header_expire"));
    }

    public boolean startIfReady(TransferDBUtil dbUtil) {
        boolean isActive;
        boolean isReady = this.checkIsReadyToRun();
        boolean bl = isActive = this.submittedTask != null && !this.submittedTask.isDone();
        if (isReady && !isActive) {
            this.submittedTask = this.type.equals((Object)TransferType.DOWNLOAD) ? TransferThreadPool.submitTask(new DownloadTask(this, this.s3, dbUtil)) : TransferThreadPool.submitTask(new UploadTask(this, this.s3, dbUtil));
        }
        return isReady || isActive;
    }

    public boolean pauseOrCancelIfRequested(TransferDBUtil dbUtil) {
        if (this.state.equals((Object)TransferState.PENDING_PAUSE)) {
            dbUtil.updateState(this.id, TransferState.PAUSED);
            this.cancelTask();
            return true;
        }
        if (this.state.equals((Object)TransferState.PENDING_NETWORK_DISCONNECT)) {
            dbUtil.updateState(this.id, TransferState.WAITING_FOR_NETWORK);
            this.cancelTask();
            return true;
        }
        if (this.state.equals((Object)TransferState.PENDING_CANCEL)) {
            this.cancelTask();
            if (this.isMultipart == 1) {
                try {
                    this.s3.abortMultipartUpload(new AbortMultipartUploadRequest(this.bucketName, this.key, this.multipartId));
                }
                catch (Exception e) {
                    return false;
                }
                dbUtil.updateState(this.id, TransferState.CANCELED);
            } else {
                dbUtil.updateState(this.id, TransferState.CANCELED);
            }
            return true;
        }
        return false;
    }

    private void cancelTask() {
        if (this.submittedTask != null && !this.submittedTask.isDone()) {
            this.submittedTask.cancel(true);
        }
    }

    private boolean checkIsReadyToRun() {
        if (this.partNumber > 0) {
            return false;
        }
        if (this.state.equals((Object)TransferState.WAITING)) {
            return true;
        }
        return this.state.equals((Object)TransferState.RESUMED_WAITING);
    }
}

