/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.s3.transferutility;

import com.amazonaws.AmazonClientException;
import com.amazonaws.event.ProgressEvent;
import com.amazonaws.event.ProgressListener;
import com.amazonaws.logging.Log;
import com.amazonaws.logging.LogFactory;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferNetworkLossHandler;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferRecord;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferState;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferStatusUpdater;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferUtility;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferUtilityException;
import com.amazonaws.retry.RetryUtils;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.S3Object;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketTimeoutException;
import java.util.concurrent.Callable;

class DownloadTask
implements Callable<Boolean> {
    private static final Log LOGGER = LogFactory.getLog(DownloadTask.class);
    private static final int SIXTEEN_KB = 16384;
    private final AmazonS3 s3;
    private final TransferRecord download;
    private final TransferStatusUpdater updater;

    public DownloadTask(TransferRecord download, AmazonS3 s3, TransferStatusUpdater updater) {
        this.download = download;
        this.s3 = s3;
        this.updater = updater;
    }

    @Override
    public Boolean call() {
        try {
            if (TransferNetworkLossHandler.getInstance() != null && !TransferNetworkLossHandler.getInstance().isNetworkConnected()) {
                LOGGER.info((Object)("Thread:[" + Thread.currentThread().getId() + "]: Network wasn't available."));
                this.updater.updateState(this.download.id, TransferState.WAITING_FOR_NETWORK);
                return false;
            }
        }
        catch (TransferUtilityException transferUtilityException) {
            LOGGER.error((Object)("TransferUtilityException: [" + transferUtilityException + "]"));
        }
        this.updater.updateState(this.download.id, TransferState.IN_PROGRESS);
        ProgressListener progressListener = this.updater.newProgressListener(this.download.id);
        try {
            GetObjectRequest getObjectRequest = new GetObjectRequest(this.download.bucketName, this.download.key);
            TransferUtility.appendTransferServiceUserAgentString(getObjectRequest);
            File file = new File(this.download.file);
            long bytesCurrent = file.length();
            if (bytesCurrent > 0L) {
                LOGGER.debug((Object)String.format("Resume transfer %d from %d bytes", this.download.id, bytesCurrent));
                getObjectRequest.setRange(bytesCurrent, -1L);
            }
            getObjectRequest.setGeneralProgressListener(progressListener);
            S3Object object = this.s3.getObject(getObjectRequest);
            if (object == null) {
                this.updater.throwError(this.download.id, new IllegalStateException("AmazonS3.getObject returns null"));
                this.updater.updateState(this.download.id, TransferState.FAILED);
                return false;
            }
            long bytesTotal = object.getObjectMetadata().getInstanceLength();
            this.updater.updateProgress(this.download.id, bytesCurrent, bytesTotal, true);
            this.saveToFile((InputStream)((Object)object.getObjectContent()), file);
            this.updater.updateProgress(this.download.id, bytesTotal, bytesTotal, true);
            this.updater.updateState(this.download.id, TransferState.COMPLETED);
            return true;
        }
        catch (Exception e) {
            if (TransferState.CANCELED.equals((Object)this.download.state)) {
                LOGGER.info((Object)("Transfer is " + (Object)((Object)this.download.state)));
                return false;
            }
            if (TransferState.PAUSED.equals((Object)this.download.state)) {
                LOGGER.info((Object)("Transfer is " + (Object)((Object)this.download.state)));
                ProgressEvent resetEvent = new ProgressEvent(0L);
                resetEvent.setEventCode(32);
                progressListener.progressChanged(new ProgressEvent(0L));
                return false;
            }
            try {
                if (TransferNetworkLossHandler.getInstance() != null && !TransferNetworkLossHandler.getInstance().isNetworkConnected()) {
                    LOGGER.info((Object)("Thread:[" + Thread.currentThread().getId() + "]: Network wasn't available."));
                    this.updater.updateState(this.download.id, TransferState.WAITING_FOR_NETWORK);
                    LOGGER.debug((Object)"Network Connection Interrupted: Moving the TransferState to WAITING_FOR_NETWORK");
                    ProgressEvent resetEvent = new ProgressEvent(0L);
                    resetEvent.setEventCode(32);
                    progressListener.progressChanged(new ProgressEvent(0L));
                    return false;
                }
            }
            catch (TransferUtilityException transferUtilityException) {
                LOGGER.error((Object)("TransferUtilityException: [" + transferUtilityException + "]"));
            }
            if (RetryUtils.isInterrupted((Throwable)e)) {
                LOGGER.info((Object)("Transfer is interrupted. " + e));
                this.updater.updateState(this.download.id, TransferState.FAILED);
                return false;
            }
            LOGGER.debug((Object)("Failed to download: " + this.download.id + " due to " + e.getMessage()));
            this.updater.throwError(this.download.id, e);
            this.updater.updateState(this.download.id, TransferState.FAILED);
            return false;
        }
    }

    private void saveToFile(InputStream is, File file) {
        File parentDirectory = file.getParentFile();
        if (parentDirectory != null && !parentDirectory.exists()) {
            parentDirectory.mkdirs();
        }
        boolean append = file.length() > 0L;
        OutputStream os = null;
        try {
            int bytesRead;
            os = new BufferedOutputStream(new FileOutputStream(file, append));
            byte[] buffer = new byte[16384];
            while ((bytesRead = is.read(buffer)) != -1) {
                os.write(buffer, 0, bytesRead);
            }
        }
        catch (SocketTimeoutException socketTimeoutException) {
            String errorString = "SocketTimeoutException: Unable to retrieve contents over network: " + socketTimeoutException.getMessage();
            LOGGER.error((Object)errorString);
            throw new AmazonClientException(errorString, (Throwable)socketTimeoutException);
        }
        catch (IOException e) {
            throw new AmazonClientException("Unable to store object contents to disk: " + e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (os != null) {
                    os.close();
                }
            }
            catch (IOException ioe) {
                LOGGER.warn((Object)"got exception", (Throwable)ioe);
            }
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException ioe) {
                LOGGER.warn((Object)"got exception", (Throwable)ioe);
            }
        }
    }
}

