/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.iterable;

import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.ListVersionsRequest;
import com.amazonaws.services.s3.model.S3VersionSummary;
import com.amazonaws.services.s3.model.VersionListing;
import java.util.Iterator;

public class S3Versions
implements Iterable<S3VersionSummary> {
    private AmazonS3 s3;
    private String bucketName;
    private String prefix;
    private String key;
    private Integer batchSize;

    private S3Versions(AmazonS3 amazonS3, String string) {
        this.s3 = amazonS3;
        this.bucketName = string;
    }

    public static S3Versions inBucket(AmazonS3 amazonS3, String string) {
        return new S3Versions(amazonS3, string);
    }

    public static S3Versions withPrefix(AmazonS3 amazonS3, String string, String string2) {
        S3Versions s3Versions = new S3Versions(amazonS3, string);
        s3Versions.prefix = string2;
        return s3Versions;
    }

    public static S3Versions forKey(AmazonS3 amazonS3, String string, String string2) {
        S3Versions s3Versions = new S3Versions(amazonS3, string);
        s3Versions.key = string2;
        return s3Versions;
    }

    public S3Versions withBatchSize(int n) {
        this.batchSize = n;
        return this;
    }

    public Integer getBatchSize() {
        return this.batchSize;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getKey() {
        return this.key;
    }

    public AmazonS3 getS3() {
        return this.s3;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    @Override
    public Iterator<S3VersionSummary> iterator() {
        return new VersionIterator();
    }

    private class VersionIterator
    implements Iterator<S3VersionSummary> {
        private VersionListing currentListing = null;
        private Iterator<S3VersionSummary> currentIterator = null;
        private S3VersionSummary nextSummary = null;

        private VersionIterator() {
        }

        @Override
        public boolean hasNext() {
            this.prepareCurrentListing();
            return this.nextMatchingSummary() != null;
        }

        @Override
        public S3VersionSummary next() {
            this.prepareCurrentListing();
            S3VersionSummary s3VersionSummary = this.nextMatchingSummary();
            this.nextSummary = null;
            return s3VersionSummary;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private S3VersionSummary nextMatchingSummary() {
            if (S3Versions.this.getKey() == null || this.nextSummary != null && this.nextSummary.getKey().equals(S3Versions.this.getKey())) {
                return this.nextSummary;
            }
            return null;
        }

        private void prepareCurrentListing() {
            while (this.currentListing == null || !this.currentIterator.hasNext() && this.currentListing.isTruncated()) {
                if (this.currentListing == null) {
                    ListVersionsRequest listVersionsRequest = new ListVersionsRequest();
                    listVersionsRequest.setBucketName(S3Versions.this.getBucketName());
                    if (S3Versions.this.getKey() != null) {
                        listVersionsRequest.setPrefix(S3Versions.this.getKey());
                    } else {
                        listVersionsRequest.setPrefix(S3Versions.this.getPrefix());
                    }
                    listVersionsRequest.setMaxResults(S3Versions.this.getBatchSize());
                    this.currentListing = S3Versions.this.getS3().listVersions(listVersionsRequest);
                } else {
                    this.currentListing = S3Versions.this.getS3().listNextBatchOfVersions(this.currentListing);
                }
                this.currentIterator = this.currentListing.getVersionSummaries().iterator();
            }
            if (this.nextSummary == null && this.currentIterator.hasNext()) {
                this.nextSummary = this.currentIterator.next();
            }
        }
    }
}

