/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.internal.crypto;

import com.amazonaws.services.s3.internal.crypto.CryptoRuntime;
import java.security.Key;

final class S3KeyWrapScheme {
    public static final String AESWrap = "AESWrap";
    public static final String RSA_ECB_OAEPWithSHA256AndMGF1Padding = "RSA/ECB/OAEPWithSHA-256AndMGF1Padding";

    S3KeyWrapScheme() {
    }

    String getKeyWrapAlgorithm(Key key) {
        String string = key.getAlgorithm();
        if ("AES".equals(string)) {
            return AESWrap;
        }
        if ("RSA".equals(string) && CryptoRuntime.isRsaKeyWrapAvailable()) {
            return RSA_ECB_OAEPWithSHA256AndMGF1Padding;
        }
        return null;
    }
}

