/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.internal.crypto;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.services.s3.AmazonS3EncryptionClient;
import com.amazonaws.services.s3.internal.S3Direct;
import com.amazonaws.services.s3.internal.crypto.ByteRangeCapturingInputStream;
import com.amazonaws.services.s3.internal.crypto.CipherFactory;
import com.amazonaws.services.s3.internal.crypto.ContentCryptoScheme;
import com.amazonaws.services.s3.internal.crypto.EncryptedUploadContext;
import com.amazonaws.services.s3.internal.crypto.EncryptionInstruction;
import com.amazonaws.services.s3.internal.crypto.EncryptionUtils;
import com.amazonaws.services.s3.internal.crypto.JceEncryptionConstants;
import com.amazonaws.services.s3.internal.crypto.MultipartUploadContext;
import com.amazonaws.services.s3.internal.crypto.S3CryptoModuleBase;
import com.amazonaws.services.s3.internal.crypto.S3CryptoScheme;
import com.amazonaws.services.s3.model.CompleteMultipartUploadRequest;
import com.amazonaws.services.s3.model.CompleteMultipartUploadResult;
import com.amazonaws.services.s3.model.CopyPartRequest;
import com.amazonaws.services.s3.model.CopyPartResult;
import com.amazonaws.services.s3.model.CryptoConfiguration;
import com.amazonaws.services.s3.model.CryptoStorageMode;
import com.amazonaws.services.s3.model.EncryptedInitiateMultipartUploadRequest;
import com.amazonaws.services.s3.model.EncryptionMaterials;
import com.amazonaws.services.s3.model.EncryptionMaterialsProvider;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.InitiateMultipartUploadRequest;
import com.amazonaws.services.s3.model.InitiateMultipartUploadResult;
import com.amazonaws.services.s3.model.MaterialsDescriptionProvider;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.PutObjectResult;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.UploadPartRequest;
import com.amazonaws.services.s3.model.UploadPartResult;
import java.io.File;
import java.io.InputStream;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;

class S3CryptoModuleEO
extends S3CryptoModuleBase<EncryptedUploadContext> {
    S3CryptoModuleEO(S3Direct s3Direct, AWSCredentialsProvider aWSCredentialsProvider, EncryptionMaterialsProvider encryptionMaterialsProvider, ClientConfiguration clientConfiguration, CryptoConfiguration cryptoConfiguration) {
        super(s3Direct, aWSCredentialsProvider, encryptionMaterialsProvider, clientConfiguration, cryptoConfiguration, new S3CryptoScheme(ContentCryptoScheme.AES_CBC));
    }

    S3CryptoModuleEO(S3Direct s3Direct, EncryptionMaterialsProvider encryptionMaterialsProvider, CryptoConfiguration cryptoConfiguration) {
        this(s3Direct, (AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain(), encryptionMaterialsProvider, new ClientConfiguration(), cryptoConfiguration);
    }

    @Override
    public PutObjectResult putObjectSecurely(PutObjectRequest putObjectRequest) throws AmazonClientException, AmazonServiceException {
        this.appendUserAgent(putObjectRequest, AmazonS3EncryptionClient.USER_AGENT);
        if (this.cryptoConfig.getStorageMode() == CryptoStorageMode.InstructionFile) {
            return this.putObjectUsingInstructionFile(putObjectRequest);
        }
        return this.putObjectUsingMetadata(putObjectRequest);
    }

    @Override
    public S3Object getObjectSecurely(GetObjectRequest getObjectRequest) throws AmazonClientException, AmazonServiceException {
        throw new IllegalStateException();
    }

    @Override
    public ObjectMetadata getObjectSecurely(GetObjectRequest getObjectRequest, File file) throws AmazonClientException, AmazonServiceException {
        throw new IllegalStateException();
    }

    @Override
    public CompleteMultipartUploadResult completeMultipartUploadSecurely(CompleteMultipartUploadRequest completeMultipartUploadRequest) throws AmazonClientException, AmazonServiceException {
        this.appendUserAgent(completeMultipartUploadRequest, AmazonS3EncryptionClient.USER_AGENT);
        String string = completeMultipartUploadRequest.getUploadId();
        EncryptedUploadContext encryptedUploadContext = (EncryptedUploadContext)this.multipartUploadContexts.get(string);
        if (!encryptedUploadContext.hasFinalPartBeenSeen()) {
            throw new AmazonClientException("Unable to complete an encrypted multipart upload without being told which part was the last.  Without knowing which part was the last, the encrypted data in Amazon S3 is incomplete and corrupt.");
        }
        CompleteMultipartUploadResult completeMultipartUploadResult = this.s3.completeMultipartUpload(completeMultipartUploadRequest);
        if (this.cryptoConfig.getStorageMode() == CryptoStorageMode.InstructionFile) {
            Cipher cipher = EncryptionUtils.createSymmetricCipher(encryptedUploadContext.getEnvelopeEncryptionKey(), 1, this.cryptoConfig.getCryptoProvider(), encryptedUploadContext.getFirstInitializationVector());
            EncryptionMaterials encryptionMaterials = encryptedUploadContext.getMaterialsDescription() != null ? this.kekMaterialsProvider.getEncryptionMaterials(encryptedUploadContext.getMaterialsDescription()) : this.kekMaterialsProvider.getEncryptionMaterials();
            byte[] byArray = EncryptionUtils.getEncryptedSymmetricKey(encryptedUploadContext.getEnvelopeEncryptionKey(), encryptionMaterials, this.cryptoConfig.getCryptoProvider());
            EncryptionInstruction encryptionInstruction = new EncryptionInstruction(encryptionMaterials.getMaterialsDescription(), byArray, encryptedUploadContext.getEnvelopeEncryptionKey(), cipher);
            this.s3.putObject(EncryptionUtils.createInstructionPutRequest(encryptedUploadContext.getBucketName(), encryptedUploadContext.getKey(), encryptionInstruction));
        }
        this.multipartUploadContexts.remove(string);
        return completeMultipartUploadResult;
    }

    @Override
    public InitiateMultipartUploadResult initiateMultipartUploadSecurely(InitiateMultipartUploadRequest initiateMultipartUploadRequest) throws AmazonClientException, AmazonServiceException {
        Object object;
        Object object2;
        this.appendUserAgent(initiateMultipartUploadRequest, AmazonS3EncryptionClient.USER_AGENT);
        SecretKey secretKey = EncryptionUtils.generateOneTimeUseSymmetricKey();
        Cipher cipher = EncryptionUtils.createSymmetricCipher(secretKey, 1, this.cryptoConfig.getCryptoProvider(), null);
        if (this.cryptoConfig.getStorageMode() == CryptoStorageMode.ObjectMetadata) {
            object2 = null;
            object2 = initiateMultipartUploadRequest instanceof EncryptedInitiateMultipartUploadRequest ? this.kekMaterialsProvider.getEncryptionMaterials(((EncryptedInitiateMultipartUploadRequest)initiateMultipartUploadRequest).getMaterialsDescription()) : this.kekMaterialsProvider.getEncryptionMaterials();
            object = EncryptionUtils.getEncryptedSymmetricKey(secretKey, (EncryptionMaterials)object2, this.cryptoConfig.getCryptoProvider());
            ObjectMetadata objectMetadata = EncryptionUtils.updateMetadataWithEncryptionInfo(initiateMultipartUploadRequest, (byte[])object, cipher, ((EncryptionMaterials)object2).getMaterialsDescription());
            initiateMultipartUploadRequest.setObjectMetadata(objectMetadata);
        }
        object2 = this.s3.initiateMultipartUpload(initiateMultipartUploadRequest);
        object = new EncryptedUploadContext(initiateMultipartUploadRequest.getBucketName(), initiateMultipartUploadRequest.getKey(), secretKey);
        ((EncryptedUploadContext)object).setNextInitializationVector(cipher.getIV());
        ((EncryptedUploadContext)object).setFirstInitializationVector(cipher.getIV());
        if (initiateMultipartUploadRequest instanceof EncryptedInitiateMultipartUploadRequest) {
            ((MultipartUploadContext)object).setMaterialsDescription(((EncryptedInitiateMultipartUploadRequest)initiateMultipartUploadRequest).getMaterialsDescription());
        }
        this.multipartUploadContexts.put(((InitiateMultipartUploadResult)object2).getUploadId(), object);
        return object2;
    }

    @Override
    public UploadPartResult uploadPartSecurely(UploadPartRequest uploadPartRequest) throws AmazonClientException, AmazonServiceException {
        boolean bl;
        this.appendUserAgent(uploadPartRequest, AmazonS3EncryptionClient.USER_AGENT);
        boolean bl2 = uploadPartRequest.isLastPart();
        String string = uploadPartRequest.getUploadId();
        boolean bl3 = bl = uploadPartRequest.getPartSize() % (long)JceEncryptionConstants.SYMMETRIC_CIPHER_BLOCK_SIZE == 0L;
        if (!bl2 && !bl) {
            throw new AmazonClientException("Invalid part size: part sizes for encrypted multipart uploads must be multiples of the cipher block size (" + JceEncryptionConstants.SYMMETRIC_CIPHER_BLOCK_SIZE + ") with the exception of the last part.  " + "Otherwise encryption adds extra padding that will corrupt the final object.");
        }
        EncryptedUploadContext encryptedUploadContext = (EncryptedUploadContext)this.multipartUploadContexts.get(string);
        if (encryptedUploadContext == null) {
            throw new AmazonClientException("No client-side information available on upload ID " + string);
        }
        SecretKey secretKey = encryptedUploadContext.getEnvelopeEncryptionKey();
        byte[] byArray = encryptedUploadContext.getNextInitializationVector();
        CipherFactory cipherFactory = new CipherFactory(secretKey, 1, byArray, this.cryptoConfig.getCryptoProvider());
        ByteRangeCapturingInputStream byteRangeCapturingInputStream = EncryptionUtils.getEncryptedInputStream(uploadPartRequest, cipherFactory);
        uploadPartRequest.setInputStream((InputStream)((Object)byteRangeCapturingInputStream));
        if (uploadPartRequest.isLastPart()) {
            long l = EncryptionUtils.calculateCryptoContentLength(cipherFactory.createCipher(), uploadPartRequest);
            if (l > 0L) {
                uploadPartRequest.setPartSize(l);
            }
            if (encryptedUploadContext.hasFinalPartBeenSeen()) {
                throw new AmazonClientException("This part was specified as the last part in a multipart upload, but a previous part was already marked as the last part.  Only the last part of the upload should be marked as the last part, otherwise it will cause the encrypted data to be corrupted.");
            }
            encryptedUploadContext.setHasFinalPartBeenSeen(true);
        }
        uploadPartRequest.setFile(null);
        uploadPartRequest.setFileOffset(0L);
        UploadPartResult uploadPartResult = this.s3.uploadPart(uploadPartRequest);
        encryptedUploadContext.setNextInitializationVector(byteRangeCapturingInputStream.getBlock());
        return uploadPartResult;
    }

    @Override
    public CopyPartResult copyPartSecurely(CopyPartRequest copyPartRequest) {
        String string = copyPartRequest.getUploadId();
        EncryptedUploadContext encryptedUploadContext = (EncryptedUploadContext)this.multipartUploadContexts.get(string);
        if (!encryptedUploadContext.hasFinalPartBeenSeen()) {
            encryptedUploadContext.setHasFinalPartBeenSeen(true);
        }
        return this.s3.copyPart(copyPartRequest);
    }

    private PutObjectResult putObjectUsingMetadata(PutObjectRequest putObjectRequest) throws AmazonClientException, AmazonServiceException {
        EncryptionInstruction encryptionInstruction = this.encryptionInstructionOf(putObjectRequest);
        PutObjectRequest putObjectRequest2 = EncryptionUtils.encryptRequestUsingInstruction(putObjectRequest, encryptionInstruction);
        EncryptionUtils.updateMetadataWithEncryptionInstruction(putObjectRequest, encryptionInstruction);
        return this.s3.putObject(putObjectRequest2);
    }

    private PutObjectResult putObjectUsingInstructionFile(PutObjectRequest putObjectRequest) throws AmazonClientException, AmazonServiceException {
        EncryptionInstruction encryptionInstruction = this.encryptionInstructionOf(putObjectRequest);
        PutObjectRequest putObjectRequest2 = EncryptionUtils.encryptRequestUsingInstruction(putObjectRequest, encryptionInstruction);
        PutObjectResult putObjectResult = this.s3.putObject(putObjectRequest2);
        PutObjectRequest putObjectRequest3 = EncryptionUtils.createInstructionPutRequest(putObjectRequest, encryptionInstruction);
        this.s3.putObject(putObjectRequest3);
        return putObjectResult;
    }

    private EncryptionInstruction encryptionInstructionOf(AmazonWebServiceRequest amazonWebServiceRequest) {
        EncryptionInstruction encryptionInstruction;
        if (amazonWebServiceRequest instanceof MaterialsDescriptionProvider) {
            MaterialsDescriptionProvider materialsDescriptionProvider = (MaterialsDescriptionProvider)amazonWebServiceRequest;
            encryptionInstruction = EncryptionUtils.generateInstruction(this.kekMaterialsProvider, materialsDescriptionProvider.getMaterialsDescription(), this.cryptoConfig.getCryptoProvider());
        } else {
            encryptionInstruction = EncryptionUtils.generateInstruction(this.kekMaterialsProvider, this.cryptoConfig.getCryptoProvider());
        }
        return encryptionInstruction;
    }

    @Override
    protected final long ciphertextLength(long l) {
        long l2 = this.contentCryptoScheme.getBlockSizeInBytes();
        long l3 = l2 - l % l2;
        return l + l3;
    }
}

