/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.internal.crypto;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.services.s3.AmazonS3EncryptionClient;
import com.amazonaws.services.s3.internal.InputSubstream;
import com.amazonaws.services.s3.internal.RepeatableFileInputStream;
import com.amazonaws.services.s3.internal.S3Direct;
import com.amazonaws.services.s3.internal.ServerSideEncryptionResult;
import com.amazonaws.services.s3.internal.crypto.AdjustedRangeInputStream;
import com.amazonaws.services.s3.internal.crypto.CipherLite;
import com.amazonaws.services.s3.internal.crypto.CipherLiteInputStream;
import com.amazonaws.services.s3.internal.crypto.ContentCryptoMaterial;
import com.amazonaws.services.s3.internal.crypto.ContentCryptoScheme;
import com.amazonaws.services.s3.internal.crypto.CryptoRuntime;
import com.amazonaws.services.s3.internal.crypto.EncryptionUtils;
import com.amazonaws.services.s3.internal.crypto.MultipartUploadCryptoContext;
import com.amazonaws.services.s3.internal.crypto.S3CryptoModuleBase;
import com.amazonaws.services.s3.internal.crypto.S3CryptoScheme;
import com.amazonaws.services.s3.internal.crypto.S3ObjectWrapper;
import com.amazonaws.services.s3.model.CompleteMultipartUploadRequest;
import com.amazonaws.services.s3.model.CompleteMultipartUploadResult;
import com.amazonaws.services.s3.model.CopyPartRequest;
import com.amazonaws.services.s3.model.CopyPartResult;
import com.amazonaws.services.s3.model.CryptoConfiguration;
import com.amazonaws.services.s3.model.CryptoStorageMode;
import com.amazonaws.services.s3.model.EncryptionMaterialsProvider;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.InitiateMultipartUploadRequest;
import com.amazonaws.services.s3.model.InitiateMultipartUploadResult;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.PutObjectResult;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectInputStream;
import com.amazonaws.services.s3.model.UploadPartRequest;
import com.amazonaws.services.s3.model.UploadPartResult;
import com.amazonaws.util.json.Jackson;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Map;

class S3CryptoModuleAE
extends S3CryptoModuleBase<MultipartUploadCryptoContext> {
    private static final boolean IS_MULTI_PART = true;

    S3CryptoModuleAE(S3Direct s3Direct, AWSCredentialsProvider aWSCredentialsProvider, EncryptionMaterialsProvider encryptionMaterialsProvider, ClientConfiguration clientConfiguration, CryptoConfiguration cryptoConfiguration) {
        super(s3Direct, aWSCredentialsProvider, encryptionMaterialsProvider, clientConfiguration, cryptoConfiguration, new S3CryptoScheme(ContentCryptoScheme.AES_GCM));
    }

    S3CryptoModuleAE(S3Direct s3Direct, EncryptionMaterialsProvider encryptionMaterialsProvider, CryptoConfiguration cryptoConfiguration) {
        this(s3Direct, (AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain(), encryptionMaterialsProvider, new ClientConfiguration(), cryptoConfiguration);
    }

    protected boolean isStrict() {
        return false;
    }

    protected void securityCheck(ContentCryptoMaterial contentCryptoMaterial, S3ObjectWrapper s3ObjectWrapper) {
    }

    @Override
    public PutObjectResult putObjectSecurely(PutObjectRequest putObjectRequest) throws AmazonClientException, AmazonServiceException {
        this.appendUserAgent(putObjectRequest, AmazonS3EncryptionClient.USER_AGENT);
        if (this.cryptoConfig.getStorageMode() == CryptoStorageMode.InstructionFile) {
            return this.putObjectUsingInstructionFile(putObjectRequest);
        }
        return this.putObjectUsingMetadata(putObjectRequest);
    }

    private PutObjectResult putObjectUsingMetadata(PutObjectRequest putObjectRequest) throws AmazonClientException, AmazonServiceException {
        ContentCryptoMaterial contentCryptoMaterial = this.createContentCryptoMaterial(putObjectRequest);
        PutObjectRequest putObjectRequest2 = this.wrapWithCipher(putObjectRequest, contentCryptoMaterial);
        putObjectRequest.setMetadata(this.updateMetadataWithContentCryptoMaterial(putObjectRequest.getMetadata(), putObjectRequest.getFile(), contentCryptoMaterial));
        return this.s3.putObject(putObjectRequest2);
    }

    @Override
    public S3Object getObjectSecurely(GetObjectRequest getObjectRequest) throws AmazonClientException, AmazonServiceException {
        S3Object s3Object;
        this.appendUserAgent(getObjectRequest, AmazonS3EncryptionClient.USER_AGENT);
        long[] lArray = getObjectRequest.getRange();
        if (this.isStrict() && lArray != null) {
            throw new SecurityException("Range get is not allowed in strict crypto mode");
        }
        long[] lArray2 = EncryptionUtils.getAdjustedCryptoRange(lArray);
        if (lArray2 != null) {
            getObjectRequest.setRange(lArray2[0], lArray2[1]);
        }
        if ((s3Object = this.s3.getObject(getObjectRequest)) == null) {
            return null;
        }
        try {
            return this.decipher(getObjectRequest, lArray, lArray2, s3Object);
        }
        catch (AmazonClientException amazonClientException) {
            try {
                s3Object.getObjectContent().close();
            }
            catch (Exception exception) {
                this.log.debug((Object)"Safely ignoring", (Throwable)exception);
            }
            throw amazonClientException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private S3Object decipher(GetObjectRequest getObjectRequest, long[] lArray, long[] lArray2, S3Object s3Object) {
        S3ObjectWrapper s3ObjectWrapper = new S3ObjectWrapper(s3Object);
        if (s3ObjectWrapper.hasEncryptionInfo()) {
            return this.decipherWithMetadata(lArray, lArray2, s3ObjectWrapper);
        }
        S3ObjectWrapper s3ObjectWrapper2 = this.fetchInstructionFile(getObjectRequest);
        if (s3ObjectWrapper2 != null) {
            try {
                if (s3ObjectWrapper2.isInstructionFile()) {
                    S3Object s3Object2 = this.decipherWithInstructionFile(lArray, lArray2, s3ObjectWrapper, s3ObjectWrapper2);
                    return s3Object2;
                }
            }
            finally {
                try {
                    s3ObjectWrapper2.getObjectContent().close();
                }
                catch (Exception exception) {}
            }
        }
        if (this.isStrict()) {
            try {
                s3ObjectWrapper.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw new SecurityException("S3 object with bucket name: " + s3Object.getBucketName() + ", key: " + s3Object.getKey() + " is not encrypted");
        }
        this.log.warn((Object)String.format("Unable to detect encryption information for object '%s' in bucket '%s'. Returning object without decryption.", s3Object.getKey(), s3Object.getBucketName()));
        S3ObjectWrapper s3ObjectWrapper3 = this.adjustToDesiredRange(s3ObjectWrapper, lArray, null);
        return s3ObjectWrapper3.getS3Object();
    }

    private S3Object decipherWithInstructionFile(long[] lArray, long[] lArray2, S3ObjectWrapper s3ObjectWrapper, S3ObjectWrapper s3ObjectWrapper2) {
        String string = s3ObjectWrapper2.toJsonString();
        Map<String, String> map = Collections.unmodifiableMap((Map)Jackson.fromJsonString((String)string, Map.class));
        ContentCryptoMaterial contentCryptoMaterial = ContentCryptoMaterial.fromInstructionFile(map, this.kekMaterialsProvider, this.cryptoConfig.getCryptoProvider(), lArray2);
        this.securityCheck(contentCryptoMaterial, s3ObjectWrapper);
        S3ObjectWrapper s3ObjectWrapper3 = this.decrypt(s3ObjectWrapper, contentCryptoMaterial, lArray2);
        S3ObjectWrapper s3ObjectWrapper4 = this.adjustToDesiredRange(s3ObjectWrapper3, lArray, map);
        return s3ObjectWrapper4.getS3Object();
    }

    private S3Object decipherWithMetadata(long[] lArray, long[] lArray2, S3ObjectWrapper s3ObjectWrapper) {
        ContentCryptoMaterial contentCryptoMaterial = ContentCryptoMaterial.fromObjectMetadata(s3ObjectWrapper.getObjectMetadata(), this.kekMaterialsProvider, this.cryptoConfig.getCryptoProvider(), lArray2);
        this.securityCheck(contentCryptoMaterial, s3ObjectWrapper);
        S3ObjectWrapper s3ObjectWrapper2 = this.decrypt(s3ObjectWrapper, contentCryptoMaterial, lArray2);
        S3ObjectWrapper s3ObjectWrapper3 = this.adjustToDesiredRange(s3ObjectWrapper2, lArray, null);
        return s3ObjectWrapper3.getS3Object();
    }

    protected final S3ObjectWrapper adjustToDesiredRange(S3ObjectWrapper s3ObjectWrapper, long[] lArray, Map<String, String> map) {
        if (lArray == null) {
            return s3ObjectWrapper;
        }
        ContentCryptoScheme contentCryptoScheme = s3ObjectWrapper.encryptionSchemeOf(map);
        long l = s3ObjectWrapper.getObjectMetadata().getInstanceLength();
        long l2 = l - (long)(contentCryptoScheme.getTagLengthInBits() / 8) - 1L;
        if (lArray[1] > l2) {
            lArray[1] = l2;
            if (lArray[0] > lArray[1]) {
                try {
                    s3ObjectWrapper.getObjectContent().close();
                }
                catch (IOException iOException) {
                    this.log.trace((Object)"", (Throwable)iOException);
                }
                s3ObjectWrapper.setObjectContent(new ByteArrayInputStream(new byte[0]));
                return s3ObjectWrapper;
            }
        }
        if (lArray[0] > lArray[1]) {
            return s3ObjectWrapper;
        }
        try {
            S3ObjectInputStream s3ObjectInputStream = s3ObjectWrapper.getObjectContent();
            AdjustedRangeInputStream adjustedRangeInputStream = new AdjustedRangeInputStream((InputStream)((Object)s3ObjectInputStream), lArray[0], lArray[1]);
            s3ObjectWrapper.setObjectContent(new S3ObjectInputStream((InputStream)((Object)adjustedRangeInputStream), s3ObjectInputStream.getHttpRequest()));
            return s3ObjectWrapper;
        }
        catch (IOException iOException) {
            throw new AmazonClientException("Error adjusting output to desired byte range: " + iOException.getMessage());
        }
    }

    @Override
    public ObjectMetadata getObjectSecurely(GetObjectRequest getObjectRequest, File file) throws AmazonClientException, AmazonServiceException {
        this.assertParameterNotNull(file, "The destination file parameter must be specified when downloading an object directly to a file");
        S3Object s3Object = this.getObjectSecurely(getObjectRequest);
        if (s3Object == null) {
            return null;
        }
        OutputStream outputStream = null;
        try {
            int n;
            outputStream = new BufferedOutputStream(new FileOutputStream(file));
            byte[] byArray = new byte[10240];
            while ((n = s3Object.getObjectContent().read(byArray)) > -1) {
                outputStream.write(byArray, 0, n);
            }
        }
        catch (IOException iOException) {
            throw new AmazonClientException("Unable to store object contents to disk: " + iOException.getMessage(), (Throwable)iOException);
        }
        finally {
            try {
                outputStream.close();
            }
            catch (Exception exception) {
                this.log.debug((Object)exception.getMessage());
            }
            try {
                s3Object.getObjectContent().close();
            }
            catch (Exception exception) {
                this.log.debug((Object)exception.getMessage());
            }
        }
        return s3Object.getObjectMetadata();
    }

    @Override
    public CompleteMultipartUploadResult completeMultipartUploadSecurely(CompleteMultipartUploadRequest completeMultipartUploadRequest) throws AmazonClientException, AmazonServiceException {
        this.appendUserAgent(completeMultipartUploadRequest, AmazonS3EncryptionClient.USER_AGENT);
        String string = completeMultipartUploadRequest.getUploadId();
        MultipartUploadCryptoContext multipartUploadCryptoContext = (MultipartUploadCryptoContext)this.multipartUploadContexts.get(string);
        if (!multipartUploadCryptoContext.hasFinalPartBeenSeen()) {
            throw new AmazonClientException("Unable to complete an encrypted multipart upload without being told which part was the last.  Without knowing which part was the last, the encrypted data in Amazon S3 is incomplete and corrupt.");
        }
        CompleteMultipartUploadResult completeMultipartUploadResult = this.s3.completeMultipartUpload(completeMultipartUploadRequest);
        if (this.cryptoConfig.getStorageMode() == CryptoStorageMode.InstructionFile) {
            this.s3.putObject(this.createInstructionPutRequest(multipartUploadCryptoContext.getBucketName(), multipartUploadCryptoContext.getKey(), multipartUploadCryptoContext.getContentCryptoMaterial()));
        }
        this.multipartUploadContexts.remove(string);
        return completeMultipartUploadResult;
    }

    @Override
    public InitiateMultipartUploadResult initiateMultipartUploadSecurely(InitiateMultipartUploadRequest initiateMultipartUploadRequest) throws AmazonClientException, AmazonServiceException {
        ServerSideEncryptionResult serverSideEncryptionResult;
        this.appendUserAgent(initiateMultipartUploadRequest, AmazonS3EncryptionClient.USER_AGENT);
        ContentCryptoMaterial contentCryptoMaterial = this.createContentCryptoMaterial(initiateMultipartUploadRequest);
        if (this.cryptoConfig.getStorageMode() == CryptoStorageMode.ObjectMetadata) {
            serverSideEncryptionResult = initiateMultipartUploadRequest.getObjectMetadata();
            if (serverSideEncryptionResult == null) {
                serverSideEncryptionResult = new ObjectMetadata();
            }
            initiateMultipartUploadRequest.setObjectMetadata(this.updateMetadataWithContentCryptoMaterial((ObjectMetadata)serverSideEncryptionResult, null, contentCryptoMaterial));
        }
        serverSideEncryptionResult = this.s3.initiateMultipartUpload(initiateMultipartUploadRequest);
        MultipartUploadCryptoContext multipartUploadCryptoContext = new MultipartUploadCryptoContext(initiateMultipartUploadRequest.getBucketName(), initiateMultipartUploadRequest.getKey(), contentCryptoMaterial);
        this.multipartUploadContexts.put(((InitiateMultipartUploadResult)serverSideEncryptionResult).getUploadId(), multipartUploadCryptoContext);
        return serverSideEncryptionResult;
    }

    @Override
    public UploadPartResult uploadPartSecurely(UploadPartRequest uploadPartRequest) throws AmazonClientException, AmazonServiceException {
        boolean bl;
        this.appendUserAgent(uploadPartRequest, AmazonS3EncryptionClient.USER_AGENT);
        int n = this.contentCryptoScheme.getBlockSizeInBytes();
        boolean bl2 = uploadPartRequest.isLastPart();
        String string = uploadPartRequest.getUploadId();
        long l = uploadPartRequest.getPartSize();
        boolean bl3 = bl = 0L == l % (long)n;
        if (!bl2 && !bl) {
            throw new AmazonClientException("Invalid part size: part sizes for encrypted multipart uploads must be multiples of the cipher block size (" + n + ") with the exception of the last part.");
        }
        MultipartUploadCryptoContext multipartUploadCryptoContext = (MultipartUploadCryptoContext)this.multipartUploadContexts.get(string);
        if (multipartUploadCryptoContext == null) {
            throw new AmazonClientException("No client-side information available on upload ID " + string);
        }
        CipherLite cipherLite = multipartUploadCryptoContext.getCipherLite();
        uploadPartRequest.setInputStream((InputStream)((Object)this.newMultipartS3CipherInputStream(uploadPartRequest, cipherLite)));
        uploadPartRequest.setFile(null);
        uploadPartRequest.setFileOffset(0L);
        if (uploadPartRequest.isLastPart()) {
            uploadPartRequest.setPartSize(l + (long)(this.contentCryptoScheme.getTagLengthInBits() / 8));
            if (multipartUploadCryptoContext.hasFinalPartBeenSeen()) {
                throw new AmazonClientException("This part was specified as the last part in a multipart upload, but a previous part was already marked as the last part.  Only the last part of the upload should be marked as the last part.");
            }
            multipartUploadCryptoContext.setHasFinalPartBeenSeen(true);
        }
        UploadPartResult uploadPartResult = this.s3.uploadPart(uploadPartRequest);
        return uploadPartResult;
    }

    protected final CipherLiteInputStream newMultipartS3CipherInputStream(UploadPartRequest uploadPartRequest, CipherLite cipherLite) {
        try {
            Object object = uploadPartRequest.getInputStream();
            if (uploadPartRequest.getFile() != null) {
                object = new InputSubstream((InputStream)((Object)new RepeatableFileInputStream(uploadPartRequest.getFile())), uploadPartRequest.getFileOffset(), uploadPartRequest.getPartSize(), uploadPartRequest.isLastPart());
            }
            return new CipherLiteInputStream((InputStream)object, cipherLite, 2048, true);
        }
        catch (Exception exception) {
            throw new AmazonClientException("Unable to create cipher input stream: " + exception.getMessage(), (Throwable)exception);
        }
    }

    @Override
    public CopyPartResult copyPartSecurely(CopyPartRequest copyPartRequest) {
        String string = copyPartRequest.getUploadId();
        MultipartUploadCryptoContext multipartUploadCryptoContext = (MultipartUploadCryptoContext)this.multipartUploadContexts.get(string);
        if (!multipartUploadCryptoContext.hasFinalPartBeenSeen()) {
            multipartUploadCryptoContext.setHasFinalPartBeenSeen(true);
        }
        return this.s3.copyPart(copyPartRequest);
    }

    private PutObjectResult putObjectUsingInstructionFile(PutObjectRequest putObjectRequest) throws AmazonClientException, AmazonServiceException {
        PutObjectRequest putObjectRequest2 = putObjectRequest.clone();
        ContentCryptoMaterial contentCryptoMaterial = this.createContentCryptoMaterial(putObjectRequest);
        PutObjectRequest putObjectRequest3 = this.wrapWithCipher(putObjectRequest, contentCryptoMaterial);
        PutObjectResult putObjectResult = this.s3.putObject(putObjectRequest3);
        this.s3.putObject(this.upateInstructionPutRequest(putObjectRequest2, contentCryptoMaterial));
        return putObjectResult;
    }

    private S3ObjectWrapper decrypt(S3ObjectWrapper s3ObjectWrapper, ContentCryptoMaterial contentCryptoMaterial, long[] lArray) {
        S3ObjectInputStream s3ObjectInputStream = s3ObjectWrapper.getObjectContent();
        s3ObjectWrapper.setObjectContent(new S3ObjectInputStream((InputStream)((Object)new CipherLiteInputStream((InputStream)((Object)s3ObjectInputStream), contentCryptoMaterial.getCipherLite(), 2048)), s3ObjectInputStream.getHttpRequest()));
        return s3ObjectWrapper;
    }

    private S3ObjectWrapper fetchInstructionFile(GetObjectRequest getObjectRequest) {
        try {
            S3Object s3Object = this.s3.getObject(EncryptionUtils.createInstructionGetRequest(getObjectRequest));
            return s3Object == null ? null : new S3ObjectWrapper(s3Object);
        }
        catch (AmazonServiceException amazonServiceException) {
            this.log.debug((Object)("Unable to retrieve instruction file : " + amazonServiceException.getMessage()));
            return null;
        }
    }

    private void assertParameterNotNull(Object object, String string) {
        if (object == null) {
            throw new IllegalArgumentException(string);
        }
    }

    @Override
    protected final long ciphertextLength(long l) {
        return l + (long)(this.contentCryptoScheme.getTagLengthInBits() / 8);
    }

    static {
        CryptoRuntime.enableBouncyCastle();
    }
}

