/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.transfer;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.event.ProgressEvent;
import com.amazonaws.event.ProgressListener;
import com.amazonaws.event.ProgressListenerChain;
import com.amazonaws.org.apache.commons.logging.Log;
import com.amazonaws.org.apache.commons.logging.LogFactory;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.AmazonS3EncryptionClient;
import com.amazonaws.services.s3.internal.Mimetypes;
import com.amazonaws.services.s3.internal.ServiceUtils;
import com.amazonaws.services.s3.model.AbortMultipartUploadRequest;
import com.amazonaws.services.s3.model.CopyObjectRequest;
import com.amazonaws.services.s3.model.GetObjectMetadataRequest;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.ListMultipartUploadsRequest;
import com.amazonaws.services.s3.model.ListObjectsRequest;
import com.amazonaws.services.s3.model.MultipartUpload;
import com.amazonaws.services.s3.model.MultipartUploadListing;
import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import com.amazonaws.services.s3.transfer.Copy;
import com.amazonaws.services.s3.transfer.Download;
import com.amazonaws.services.s3.transfer.MultipleFileDownload;
import com.amazonaws.services.s3.transfer.MultipleFileTransferProgressUpdatingListener;
import com.amazonaws.services.s3.transfer.MultipleFileTransferStateChangeListener;
import com.amazonaws.services.s3.transfer.MultipleFileUpload;
import com.amazonaws.services.s3.transfer.ObjectMetadataProvider;
import com.amazonaws.services.s3.transfer.PersistableDownload;
import com.amazonaws.services.s3.transfer.PersistableUpload;
import com.amazonaws.services.s3.transfer.Transfer;
import com.amazonaws.services.s3.transfer.TransferManagerConfiguration;
import com.amazonaws.services.s3.transfer.TransferProgress;
import com.amazonaws.services.s3.transfer.Upload;
import com.amazonaws.services.s3.transfer.internal.CopyCallable;
import com.amazonaws.services.s3.transfer.internal.CopyImpl;
import com.amazonaws.services.s3.transfer.internal.CopyMonitor;
import com.amazonaws.services.s3.transfer.internal.DownloadImpl;
import com.amazonaws.services.s3.transfer.internal.DownloadMonitor;
import com.amazonaws.services.s3.transfer.internal.MultipleFileDownloadImpl;
import com.amazonaws.services.s3.transfer.internal.MultipleFileTransferMonitor;
import com.amazonaws.services.s3.transfer.internal.MultipleFileUploadImpl;
import com.amazonaws.services.s3.transfer.internal.S3ProgressListener;
import com.amazonaws.services.s3.transfer.internal.S3ProgressListenerChain;
import com.amazonaws.services.s3.transfer.internal.TransferManagerUtils;
import com.amazonaws.services.s3.transfer.internal.TransferProgressUpdatingListener;
import com.amazonaws.services.s3.transfer.internal.TransferStateChangeListener;
import com.amazonaws.services.s3.transfer.internal.UploadCallable;
import com.amazonaws.services.s3.transfer.internal.UploadImpl;
import com.amazonaws.services.s3.transfer.internal.UploadMonitor;
import com.amazonaws.util.VersionInfoUtils;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class TransferManager {
    private final AmazonS3 s3;
    private TransferManagerConfiguration configuration;
    private final ExecutorService threadPool;
    private final ScheduledExecutorService timedThreadPool = new ScheduledThreadPoolExecutor(1, daemonThreadFactory);
    private static final Log log = LogFactory.getLog(TransferManager.class);
    private static final String USER_AGENT = TransferManager.class.getName() + "/" + VersionInfoUtils.getVersion();
    private static final String USER_AGENT_MULTIPART = TransferManager.class.getName() + "_multipart/" + VersionInfoUtils.getVersion();
    private static final String DEFAULT_DELIMITER = "/";
    private static final ThreadFactory daemonThreadFactory = new ThreadFactory(){
        final AtomicInteger threadCount = new AtomicInteger(0);

        @Override
        public Thread newThread(Runnable runnable) {
            int n = this.threadCount.incrementAndGet();
            Thread thread = new Thread(runnable);
            thread.setDaemon(true);
            thread.setName("S3TransferManagerTimedThread-" + n);
            return thread;
        }
    };

    public TransferManager() {
        this(new AmazonS3Client((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain()));
    }

    public TransferManager(AWSCredentialsProvider aWSCredentialsProvider) {
        this(new AmazonS3Client(aWSCredentialsProvider));
    }

    public TransferManager(AWSCredentials aWSCredentials) {
        this(new AmazonS3Client(aWSCredentials));
    }

    public TransferManager(AmazonS3 amazonS3) {
        this(amazonS3, TransferManagerUtils.createDefaultExecutorService());
    }

    public TransferManager(AmazonS3 amazonS3, ExecutorService executorService) {
        this.s3 = amazonS3;
        this.threadPool = executorService;
        this.configuration = new TransferManagerConfiguration();
    }

    public void setConfiguration(TransferManagerConfiguration transferManagerConfiguration) {
        this.configuration = transferManagerConfiguration;
    }

    public TransferManagerConfiguration getConfiguration() {
        return this.configuration;
    }

    public AmazonS3 getAmazonS3Client() {
        return this.s3;
    }

    public Upload upload(String string, String string2, InputStream inputStream, ObjectMetadata objectMetadata) throws AmazonServiceException, AmazonClientException {
        return this.upload(new PutObjectRequest(string, string2, inputStream, objectMetadata));
    }

    public Upload upload(String string, String string2, File file) throws AmazonServiceException, AmazonClientException {
        return this.upload(new PutObjectRequest(string, string2, file));
    }

    public Upload upload(PutObjectRequest putObjectRequest) throws AmazonServiceException, AmazonClientException {
        return this.doUpload(putObjectRequest, null, null, null);
    }

    public Upload upload(PutObjectRequest putObjectRequest, S3ProgressListener s3ProgressListener) throws AmazonServiceException, AmazonClientException {
        return this.doUpload(putObjectRequest, null, s3ProgressListener, null);
    }

    private Upload doUpload(PutObjectRequest putObjectRequest, TransferStateChangeListener transferStateChangeListener, S3ProgressListener s3ProgressListener, PersistableUpload persistableUpload) throws AmazonServiceException, AmazonClientException {
        String string;
        TransferManager.appendSingleObjectUserAgent(putObjectRequest);
        String string2 = string = persistableUpload != null ? persistableUpload.getMultipartUploadId() : null;
        if (putObjectRequest.getMetadata() == null) {
            putObjectRequest.setMetadata(new ObjectMetadata());
        }
        ObjectMetadata objectMetadata = putObjectRequest.getMetadata();
        File file = TransferManagerUtils.getRequestFile(putObjectRequest);
        if (file != null) {
            objectMetadata.setContentLength(file.length());
            if (objectMetadata.getContentType() == null) {
                objectMetadata.setContentType(Mimetypes.getInstance().getMimetype(file));
            }
        } else if (string != null) {
            throw new IllegalArgumentException("Unable to resume the upload. No file specified.");
        }
        String string3 = "Uploading to " + putObjectRequest.getBucketName() + DEFAULT_DELIMITER + putObjectRequest.getKey();
        TransferProgress transferProgress = new TransferProgress();
        transferProgress.setTotalBytesToTransfer(TransferManagerUtils.getContentLength(putObjectRequest));
        S3ProgressListenerChain s3ProgressListenerChain = new S3ProgressListenerChain(new TransferProgressUpdatingListener(transferProgress), putObjectRequest.getGeneralProgressListener(), s3ProgressListener);
        putObjectRequest.setGeneralProgressListener(s3ProgressListenerChain);
        UploadImpl uploadImpl = new UploadImpl(string3, transferProgress, s3ProgressListenerChain, transferStateChangeListener);
        UploadCallable uploadCallable = new UploadCallable(this, this.threadPool, uploadImpl, putObjectRequest, s3ProgressListenerChain, string, transferProgress);
        UploadMonitor uploadMonitor = new UploadMonitor(this, uploadImpl, this.threadPool, uploadCallable, putObjectRequest, s3ProgressListenerChain);
        uploadMonitor.setTimedThreadPool(this.timedThreadPool);
        uploadImpl.setMonitor(uploadMonitor);
        return uploadImpl;
    }

    public Download download(String string, String string2, File file) {
        return this.download(new GetObjectRequest(string, string2), file);
    }

    public Download download(GetObjectRequest getObjectRequest, File file) {
        return this.doDownload(getObjectRequest, file, null, null, false);
    }

    public Download download(GetObjectRequest getObjectRequest, File file, S3ProgressListener s3ProgressListener) {
        return this.doDownload(getObjectRequest, file, null, s3ProgressListener, false);
    }

    private Download doDownload(GetObjectRequest getObjectRequest, File file, TransferStateChangeListener transferStateChangeListener, S3ProgressListener s3ProgressListener, boolean bl) {
        TransferManager.appendSingleObjectUserAgent(getObjectRequest);
        String string = "Downloading from " + getObjectRequest.getBucketName() + DEFAULT_DELIMITER + getObjectRequest.getKey();
        TransferProgress transferProgress = new TransferProgress();
        S3ProgressListenerChain s3ProgressListenerChain = new S3ProgressListenerChain(new TransferProgressUpdatingListener(transferProgress), getObjectRequest.getGeneralProgressListener(), s3ProgressListener);
        ProgressListenerChain progressListenerChain = new ProgressListenerChain(new ProgressListenerChain.ProgressEventFilter(){

            public ProgressEvent filter(ProgressEvent progressEvent) {
                if (progressEvent.getEventCode() == 4) {
                    progressEvent.setEventCode(0);
                }
                return progressEvent;
            }
        }, new ProgressListener[]{s3ProgressListenerChain});
        getObjectRequest.setGeneralProgressListener((ProgressListener)progressListenerChain);
        GetObjectMetadataRequest getObjectMetadataRequest = new GetObjectMetadataRequest(getObjectRequest.getBucketName(), getObjectRequest.getKey());
        if (getObjectRequest.getSSECustomerKey() != null) {
            getObjectMetadataRequest.setSSECustomerKey(getObjectRequest.getSSECustomerKey());
        }
        ObjectMetadata objectMetadata = this.s3.getObjectMetadata(getObjectMetadataRequest);
        DownloadImpl downloadImpl = new DownloadImpl(string, transferProgress, s3ProgressListenerChain, null, transferStateChangeListener, getObjectRequest, file);
        long l = 0L;
        long l2 = objectMetadata.getContentLength();
        if (getObjectRequest.getRange() != null && getObjectRequest.getRange().length == 2) {
            l = getObjectRequest.getRange()[0];
            l2 = getObjectRequest.getRange()[1];
        }
        long l3 = l2 - l;
        transferProgress.setTotalBytesToTransfer(l3);
        if (bl && file.exists()) {
            long l4 = file.length();
            getObjectRequest.setRange(l += l4, l2);
            transferProgress.updateProgress(Math.min(l4, l3));
            l3 = l2 - l;
        }
        if (l3 < 0L) {
            throw new IllegalArgumentException("Unable to determine the range for download operation.");
        }
        CountDownLatch countDownLatch = new CountDownLatch(1);
        Future<?> future = this.submitDownloadTask(getObjectRequest, file, bl, countDownLatch, downloadImpl);
        downloadImpl.setMonitor(new DownloadMonitor(downloadImpl, future));
        countDownLatch.countDown();
        return downloadImpl;
    }

    private Future<?> submitDownloadTask(final GetObjectRequest getObjectRequest, final File file, final boolean bl, final CountDownLatch countDownLatch, final DownloadImpl downloadImpl) {
        Future<Object> future = this.threadPool.submit(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                try {
                    countDownLatch.await();
                    downloadImpl.setState(Transfer.TransferState.InProgress);
                    S3Object s3Object = ServiceUtils.retryableDownloadS3ObjectToFile(file, new ServiceUtils.RetryableS3DownloadTask(){

                        @Override
                        public S3Object getS3ObjectStream() {
                            S3Object s3Object = TransferManager.this.s3.getObject(getObjectRequest);
                            downloadImpl.setS3Object(s3Object);
                            return s3Object;
                        }

                        @Override
                        public boolean needIntegrityCheck() {
                            boolean bl = true;
                            if (getObjectRequest.getRange() != null) {
                                bl = false;
                            }
                            if (TransferManager.this.s3 instanceof AmazonS3EncryptionClient) {
                                bl = false;
                            }
                            return bl;
                        }
                    }, bl);
                    if (s3Object == null) {
                        downloadImpl.setState(Transfer.TransferState.Canceled);
                        downloadImpl.setMonitor(new DownloadMonitor(downloadImpl, null));
                        return downloadImpl;
                    }
                    downloadImpl.setState(Transfer.TransferState.Completed);
                    return true;
                }
                catch (Throwable throwable) {
                    if (downloadImpl.getState() != Transfer.TransferState.Canceled) {
                        downloadImpl.setState(Transfer.TransferState.Failed);
                    }
                    if (throwable instanceof Exception) {
                        throw (Exception)throwable;
                    }
                    throw (Error)throwable;
                }
            }
        });
        return future;
    }

    public MultipleFileDownload downloadDirectory(String string, String string2, File file) {
        Object object2;
        Object object3;
        String string3;
        if (string2 == null) {
            string2 = "";
        }
        LinkedList<S3ObjectSummary> linkedList = new LinkedList<S3ObjectSummary>();
        Stack<String> stack = new Stack<String>();
        stack.add(string2);
        long l = 0L;
        do {
            string3 = (String)stack.pop();
            object3 = null;
            do {
                if (object3 == null) {
                    object2 = new ListObjectsRequest().withBucketName(string).withDelimiter(DEFAULT_DELIMITER).withPrefix(string3);
                    object3 = this.s3.listObjects((ListObjectsRequest)((Object)object2));
                } else {
                    object3 = this.s3.listNextBatchOfObjects((ObjectListing)object3);
                }
                for (S3ObjectSummary object4 : ((ObjectListing)object3).getObjectSummaries()) {
                    if (!object4.getKey().equals(string3) && !((ObjectListing)object3).getCommonPrefixes().contains(object4.getKey() + DEFAULT_DELIMITER)) {
                        linkedList.add(object4);
                        l += object4.getSize();
                        continue;
                    }
                    log.debug((Object)("Skipping download for object " + object4.getKey() + " since it is also a virtual directory"));
                }
                stack.addAll(((ObjectListing)object3).getCommonPrefixes());
            } while (((ObjectListing)object3).isTruncated());
        } while (!stack.isEmpty());
        string3 = new ProgressListenerChain(new ProgressListener[0]);
        object3 = new TransferProgress();
        ((TransferProgress)object3).setTotalBytesToTransfer(l);
        object2 = new MultipleFileTransferProgressUpdatingListener((TransferProgress)object3, (ProgressListenerChain)string3);
        ArrayList<DownloadImpl> arrayList = new ArrayList<DownloadImpl>();
        String string4 = "Downloading from " + string + DEFAULT_DELIMITER + string2;
        MultipleFileDownloadImpl multipleFileDownloadImpl = new MultipleFileDownloadImpl(string4, (TransferProgress)object3, (ProgressListenerChain)string3, string2, string, arrayList);
        multipleFileDownloadImpl.setMonitor(new MultipleFileTransferMonitor(multipleFileDownloadImpl, arrayList));
        CountDownLatch countDownLatch = new CountDownLatch(1);
        MultipleFileTransferStateChangeListener multipleFileTransferStateChangeListener = new MultipleFileTransferStateChangeListener(countDownLatch, multipleFileDownloadImpl);
        for (S3ObjectSummary s3ObjectSummary : linkedList) {
            File file2 = new File(file, s3ObjectSummary.getKey());
            File file3 = file2.getParentFile();
            if (!file3.exists() && !file3.mkdirs()) {
                throw new RuntimeException("Couldn't create parent directories for " + file2.getAbsolutePath());
            }
            arrayList.add((DownloadImpl)this.doDownload(new GetObjectRequest(s3ObjectSummary.getBucketName(), s3ObjectSummary.getKey()).withGeneralProgressListener((ProgressListener)object2), file2, multipleFileTransferStateChangeListener, null, false));
        }
        if (arrayList.isEmpty()) {
            multipleFileDownloadImpl.setState(Transfer.TransferState.Completed);
            return multipleFileDownloadImpl;
        }
        countDownLatch.countDown();
        return multipleFileDownloadImpl;
    }

    public MultipleFileUpload uploadDirectory(String string, String string2, File file, boolean bl) {
        return this.uploadDirectory(string, string2, file, bl, null);
    }

    public MultipleFileUpload uploadDirectory(String string, String string2, File file, boolean bl, ObjectMetadataProvider objectMetadataProvider) {
        if (file == null || !file.exists() || !file.isDirectory()) {
            throw new IllegalArgumentException("Must provide a directory to upload");
        }
        LinkedList<File> linkedList = new LinkedList<File>();
        this.listFiles(file, linkedList, bl);
        return this.uploadFileList(string, string2, file, linkedList, objectMetadataProvider);
    }

    public MultipleFileUpload uploadFileList(String string, String string2, File file, List<File> list) {
        return this.uploadFileList(string, string2, file, list, null);
    }

    public MultipleFileUpload uploadFileList(String string, String string2, File file, List<File> list, ObjectMetadataProvider objectMetadataProvider) {
        if (file == null || !file.exists() || !file.isDirectory()) {
            throw new IllegalArgumentException("Must provide a common base directory for uploaded files");
        }
        if (string2 == null || string2.length() == 0) {
            string2 = "";
        } else if (!string2.endsWith(DEFAULT_DELIMITER)) {
            string2 = string2 + DEFAULT_DELIMITER;
        }
        ProgressListenerChain progressListenerChain = new ProgressListenerChain(new ProgressListener[0]);
        TransferProgress transferProgress = new TransferProgress();
        MultipleFileTransferProgressUpdatingListener multipleFileTransferProgressUpdatingListener = new MultipleFileTransferProgressUpdatingListener(transferProgress, progressListenerChain);
        LinkedList<UploadImpl> linkedList = new LinkedList<UploadImpl>();
        MultipleFileUploadImpl multipleFileUploadImpl = new MultipleFileUploadImpl("Uploading etc", transferProgress, progressListenerChain, string2, string, linkedList);
        multipleFileUploadImpl.setMonitor(new MultipleFileTransferMonitor(multipleFileUploadImpl, linkedList));
        CountDownLatch countDownLatch = new CountDownLatch(1);
        MultipleFileTransferStateChangeListener multipleFileTransferStateChangeListener = new MultipleFileTransferStateChangeListener(countDownLatch, multipleFileUploadImpl);
        if (list == null || list.isEmpty()) {
            multipleFileUploadImpl.setState(Transfer.TransferState.Completed);
        } else {
            int n = file.getAbsolutePath().length();
            if (!file.getAbsolutePath().endsWith(File.separator)) {
                ++n;
            }
            long l = 0L;
            for (File file2 : list) {
                if (!file2.isFile()) continue;
                l += file2.length();
                String string3 = file2.getAbsolutePath().substring(n).replaceAll("\\\\", DEFAULT_DELIMITER);
                ObjectMetadata objectMetadata = new ObjectMetadata();
                if (objectMetadataProvider != null) {
                    objectMetadataProvider.provideObjectMetadata(file2, objectMetadata);
                }
                linkedList.add((UploadImpl)this.doUpload(new PutObjectRequest(string, string2 + string3, file2).withMetadata(objectMetadata).withGeneralProgressListener(multipleFileTransferProgressUpdatingListener), multipleFileTransferStateChangeListener, null, null));
            }
            transferProgress.setTotalBytesToTransfer(l);
        }
        countDownLatch.countDown();
        return multipleFileUploadImpl;
    }

    private void listFiles(File file, List<File> list, boolean bl) {
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            for (File file2 : fileArray) {
                if (file2.isDirectory()) {
                    if (!bl) continue;
                    this.listFiles(file2, list, bl);
                    continue;
                }
                list.add(file2);
            }
        }
    }

    public void abortMultipartUploads(String string, Date date) throws AmazonServiceException, AmazonClientException {
        Object object;
        MultipartUploadListing multipartUploadListing = this.s3.listMultipartUploads(TransferManager.appendSingleObjectUserAgent(new ListMultipartUploadsRequest(string)));
        do {
            object = multipartUploadListing.getMultipartUploads().iterator();
            while (object.hasNext()) {
                MultipartUpload multipartUpload = object.next();
                if (multipartUpload.getInitiated().compareTo(date) >= 0) continue;
                this.s3.abortMultipartUpload(TransferManager.appendSingleObjectUserAgent(new AbortMultipartUploadRequest(string, multipartUpload.getKey(), multipartUpload.getUploadId())));
            }
        } while ((multipartUploadListing = this.s3.listMultipartUploads((ListMultipartUploadsRequest)((Object)TransferManager.appendSingleObjectUserAgent(object = new ListMultipartUploadsRequest(string).withUploadIdMarker(multipartUploadListing.getNextUploadIdMarker()).withKeyMarker(multipartUploadListing.getNextKeyMarker()))))).isTruncated());
    }

    public void shutdownNow() {
        this.shutdownNow(true);
    }

    public void shutdownNow(boolean bl) {
        this.threadPool.shutdownNow();
        this.timedThreadPool.shutdownNow();
        if (bl && this.s3 instanceof AmazonS3Client) {
            ((AmazonS3Client)this.s3).shutdown();
        }
    }

    private void shutdown() {
        this.threadPool.shutdown();
        this.timedThreadPool.shutdown();
    }

    public static <X extends AmazonWebServiceRequest> X appendSingleObjectUserAgent(X x) {
        x.getRequestClientOptions().appendUserAgent(USER_AGENT);
        return x;
    }

    public static <X extends AmazonWebServiceRequest> X appendMultipartUserAgent(X x) {
        x.getRequestClientOptions().appendUserAgent(USER_AGENT_MULTIPART);
        return x;
    }

    public Copy copy(String string, String string2, String string3, String string4) throws AmazonServiceException, AmazonClientException {
        return this.copy(new CopyObjectRequest(string, string2, string3, string4));
    }

    public Copy copy(CopyObjectRequest copyObjectRequest) {
        return this.copy(copyObjectRequest, null);
    }

    public Copy copy(CopyObjectRequest copyObjectRequest, TransferStateChangeListener transferStateChangeListener) throws AmazonServiceException, AmazonClientException {
        TransferManager.appendSingleObjectUserAgent(copyObjectRequest);
        this.assertParameterNotNull(copyObjectRequest.getSourceBucketName(), "The source bucket name must be specified when a copy request is initiated.");
        this.assertParameterNotNull(copyObjectRequest.getSourceKey(), "The source object key must be specified when a copy request is initiated.");
        this.assertParameterNotNull(copyObjectRequest.getDestinationBucketName(), "The destination bucket name must be specified when a copy request is initiated.");
        this.assertParameterNotNull(copyObjectRequest.getDestinationKey(), "The destination object key must be specified when a copy request is initiated.");
        String string = "Copying object from " + copyObjectRequest.getSourceBucketName() + DEFAULT_DELIMITER + copyObjectRequest.getSourceKey() + " to " + copyObjectRequest.getDestinationBucketName() + DEFAULT_DELIMITER + copyObjectRequest.getDestinationKey();
        GetObjectMetadataRequest getObjectMetadataRequest = new GetObjectMetadataRequest(copyObjectRequest.getSourceBucketName(), copyObjectRequest.getSourceKey()).withSSECustomerKey(copyObjectRequest.getSourceSSECustomerKey());
        ObjectMetadata objectMetadata = this.s3.getObjectMetadata(getObjectMetadataRequest);
        TransferProgress transferProgress = new TransferProgress();
        transferProgress.setTotalBytesToTransfer(objectMetadata.getContentLength());
        ProgressListenerChain progressListenerChain = new ProgressListenerChain(new ProgressListener[]{new TransferProgressUpdatingListener(transferProgress)});
        CopyImpl copyImpl = new CopyImpl(string, transferProgress, progressListenerChain, transferStateChangeListener);
        CopyCallable copyCallable = new CopyCallable(this, this.threadPool, copyImpl, copyObjectRequest, objectMetadata, progressListenerChain);
        CopyMonitor copyMonitor = new CopyMonitor(this, copyImpl, this.threadPool, copyCallable, copyObjectRequest, progressListenerChain);
        copyMonitor.setTimedThreadPool(this.timedThreadPool);
        copyImpl.setMonitor(copyMonitor);
        return copyImpl;
    }

    public Upload resumeUpload(PersistableUpload persistableUpload) {
        this.assertParameterNotNull(persistableUpload, "PauseUpload is mandatory to resume a upload.");
        this.configuration.setMinimumUploadPartSize(persistableUpload.getPartSize());
        this.configuration.setMultipartUploadThreshold(persistableUpload.getMutlipartUploadThreshold());
        return this.doUpload(new PutObjectRequest(persistableUpload.getBucketName(), persistableUpload.getKey(), new File(persistableUpload.getFile())), null, null, persistableUpload);
    }

    public Download resumeDownload(PersistableDownload persistableDownload) {
        this.assertParameterNotNull(persistableDownload, "PausedDownload is mandatory to resume a download.");
        GetObjectRequest getObjectRequest = new GetObjectRequest(persistableDownload.getBucketName(), persistableDownload.getKey(), persistableDownload.getVersionId());
        if (persistableDownload.getRange() != null && persistableDownload.getRange().length == 2) {
            long[] lArray = persistableDownload.getRange();
            getObjectRequest.setRange(lArray[0], lArray[1]);
        }
        getObjectRequest.setRequesterPays(persistableDownload.isRequesterPays());
        getObjectRequest.setResponseHeaders(persistableDownload.getResponseHeaders());
        return this.doDownload(getObjectRequest, new File(persistableDownload.getFile()), null, null, true);
    }

    private void assertParameterNotNull(Object object, String string) {
        if (object == null) {
            throw new IllegalArgumentException(string);
        }
    }

    protected void finalize() throws Throwable {
        this.shutdown();
    }
}

