/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.internal.crypto;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.s3.internal.crypto.ContentCryptoScheme;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectInputStream;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Map;

class S3ObjectWrapper
implements Closeable {
    private final S3Object s3obj;

    S3ObjectWrapper(S3Object s3Object) {
        if (s3Object == null) {
            throw new IllegalArgumentException();
        }
        this.s3obj = s3Object;
    }

    ObjectMetadata getObjectMetadata() {
        return this.s3obj.getObjectMetadata();
    }

    void setObjectMetadata(ObjectMetadata objectMetadata) {
        this.s3obj.setObjectMetadata(objectMetadata);
    }

    S3ObjectInputStream getObjectContent() {
        return this.s3obj.getObjectContent();
    }

    void setObjectContent(S3ObjectInputStream s3ObjectInputStream) {
        this.s3obj.setObjectContent(s3ObjectInputStream);
    }

    void setObjectContent(InputStream inputStream) {
        this.s3obj.setObjectContent(inputStream);
    }

    String getBucketName() {
        return this.s3obj.getBucketName();
    }

    void setBucketName(String string) {
        this.s3obj.setBucketName(string);
    }

    String getKey() {
        return this.s3obj.getKey();
    }

    void setKey(String string) {
        this.s3obj.setKey(string);
    }

    String getRedirectLocation() {
        return this.s3obj.getRedirectLocation();
    }

    void setRedirectLocation(String string) {
        this.s3obj.setRedirectLocation(string);
    }

    public String toString() {
        return this.s3obj.toString();
    }

    final boolean isInstructionFile() {
        ObjectMetadata objectMetadata = this.s3obj.getObjectMetadata();
        Map<String, String> map = objectMetadata.getUserMetadata();
        return map != null && map.containsKey("x-amz-crypto-instr-file");
    }

    final boolean hasEncryptionInfo() {
        ObjectMetadata objectMetadata = this.s3obj.getObjectMetadata();
        Map<String, String> map = objectMetadata.getUserMetadata();
        return map != null && map.containsKey("x-amz-iv") && (map.containsKey("x-amz-key-v2") || map.containsKey("x-amz-key"));
    }

    String toJsonString() {
        try {
            return S3ObjectWrapper.from((InputStream)((Object)this.s3obj.getObjectContent()));
        }
        catch (Exception exception) {
            throw new AmazonClientException("Error parsing JSON: " + exception.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String from(InputStream inputStream) throws IOException {
        if (inputStream == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        try {
            String string;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            while ((string = bufferedReader.readLine()) != null) {
                stringBuilder.append(string);
            }
        }
        finally {
            inputStream.close();
        }
        return stringBuilder.toString();
    }

    @Override
    public void close() throws IOException {
        this.s3obj.close();
    }

    S3Object getS3Object() {
        return this.s3obj;
    }

    ContentCryptoScheme encryptionSchemeOf(Map<String, String> map) {
        if (map != null) {
            String string = map.get("x-amz-cek-alg");
            return ContentCryptoScheme.fromCEKAlgo(string);
        }
        ObjectMetadata objectMetadata = this.s3obj.getObjectMetadata();
        Map<String, String> map2 = objectMetadata.getUserMetadata();
        String string = map2.get("x-amz-cek-alg");
        return ContentCryptoScheme.fromCEKAlgo(string);
    }
}

