/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.internal.crypto;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.s3.internal.crypto.CipherLite;
import com.amazonaws.services.s3.internal.crypto.ContentCryptoScheme;
import com.amazonaws.services.s3.internal.crypto.JceEncryptionConstants;
import com.amazonaws.services.s3.model.EncryptionMaterials;
import com.amazonaws.services.s3.model.EncryptionMaterialsAccessor;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.util.Base64;
import com.amazonaws.util.json.Jackson;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.Key;
import java.security.Provider;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

final class ContentCryptoMaterial {
    private final String keyWrappingAlgorithm;
    private final CipherLite cipherLite;
    private final Map<String, String> kekMaterialsDescription;
    private final byte[] encryptedCEK;

    ContentCryptoMaterial(Map<String, String> map, byte[] byArray, String string, CipherLite cipherLite) {
        this.cipherLite = cipherLite;
        this.keyWrappingAlgorithm = string;
        this.encryptedCEK = (byte[])byArray.clone();
        this.kekMaterialsDescription = map;
    }

    String getKeyWrappingAlgorithm() {
        return this.keyWrappingAlgorithm;
    }

    ContentCryptoScheme getContentCryptoScheme() {
        return this.cipherLite.getContentCryptoScheme();
    }

    ObjectMetadata toObjectMetadata(ObjectMetadata objectMetadata) {
        String string;
        byte[] byArray = this.getEncryptedCEK();
        objectMetadata.addUserMetadata("x-amz-key-v2", Base64.encodeAsString((byte[])byArray));
        byte[] byArray2 = this.cipherLite.getIV();
        objectMetadata.addUserMetadata("x-amz-iv", Base64.encodeAsString((byte[])byArray2));
        objectMetadata.addUserMetadata("x-amz-matdesc", this.kekMaterialDescAsJson());
        ContentCryptoScheme contentCryptoScheme = this.getContentCryptoScheme();
        objectMetadata.addUserMetadata("x-amz-cek-alg", contentCryptoScheme.getCipherAlgorithm());
        int n = contentCryptoScheme.getTagLengthInBits();
        if (n > 0) {
            objectMetadata.addUserMetadata("x-amz-tag-len", String.valueOf(n));
        }
        if ((string = this.getKeyWrappingAlgorithm()) != null) {
            objectMetadata.addUserMetadata("x-amz-wrap-alg", string);
        }
        return objectMetadata;
    }

    String toJsonString() {
        String string;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        byte[] byArray = this.getEncryptedCEK();
        hashMap.put("x-amz-key-v2", Base64.encodeAsString((byte[])byArray));
        byte[] byArray2 = this.cipherLite.getIV();
        hashMap.put("x-amz-iv", Base64.encodeAsString((byte[])byArray2));
        hashMap.put("x-amz-matdesc", this.kekMaterialDescAsJson());
        ContentCryptoScheme contentCryptoScheme = this.getContentCryptoScheme();
        hashMap.put("x-amz-cek-alg", contentCryptoScheme.getCipherAlgorithm());
        int n = contentCryptoScheme.getTagLengthInBits();
        if (n > 0) {
            hashMap.put("x-amz-tag-len", String.valueOf(n));
        }
        if ((string = this.getKeyWrappingAlgorithm()) != null) {
            hashMap.put("x-amz-wrap-alg", string);
        }
        return Jackson.toJsonString(hashMap);
    }

    private String kekMaterialDescAsJson() {
        Map<String, String> map = this.getKEKMaterialsDescription();
        if (map == null) {
            map = Collections.emptyMap();
        }
        return Jackson.toJsonString(map);
    }

    private static Map<String, String> matdescFromJson(String string) {
        Map map = (Map)Jackson.fromJsonString((String)string, Map.class);
        return map == null ? null : Collections.unmodifiableMap(map);
    }

    private static SecretKey cek(byte[] byArray, String string, EncryptionMaterials encryptionMaterials, Provider provider) {
        Key key = encryptionMaterials.getKeyPair() != null ? encryptionMaterials.getKeyPair().getPrivate() : encryptionMaterials.getSymmetricKey();
        try {
            if (string != null) {
                Cipher cipher = provider == null ? Cipher.getInstance(string) : Cipher.getInstance(string, provider);
                cipher.init(4, key);
                return (SecretKey)cipher.unwrap(byArray, string, 3);
            }
            Cipher cipher = provider != null ? Cipher.getInstance(key.getAlgorithm(), provider) : Cipher.getInstance(key.getAlgorithm());
            cipher.init(2, key);
            byte[] byArray2 = cipher.doFinal(byArray);
            return new SecretKeySpec(byArray2, JceEncryptionConstants.SYMMETRIC_KEY_ALGORITHM);
        }
        catch (Exception exception) {
            throw new AmazonClientException("Unable to decrypt symmetric key from object metadata : " + exception.getMessage(), (Throwable)exception);
        }
    }

    static ContentCryptoMaterial fromObjectMetadata(ObjectMetadata objectMetadata, EncryptionMaterialsAccessor encryptionMaterialsAccessor, Provider provider, long[] lArray) {
        Object object;
        EncryptionMaterials encryptionMaterials;
        Map<String, String> map = objectMetadata.getUserMetadata();
        String string = map.get("x-amz-key-v2");
        if (string == null && (string = map.get("x-amz-key")) == null) {
            throw new AmazonClientException("Content encrypting key not found.");
        }
        byte[] byArray = Base64.decode((String)string);
        byte[] byArray2 = Base64.decode((String)map.get("x-amz-iv"));
        if (byArray == null || byArray2 == null) {
            throw new AmazonClientException("Content encrypting key or IV not found.");
        }
        String string2 = map.get("x-amz-matdesc");
        Map<String, String> map2 = ContentCryptoMaterial.matdescFromJson(string2);
        EncryptionMaterials encryptionMaterials2 = encryptionMaterials = encryptionMaterialsAccessor == null ? null : encryptionMaterialsAccessor.getEncryptionMaterials(map2);
        if (encryptionMaterials == null) {
            throw new AmazonClientException("Unable to retrieve the client encryption materials");
        }
        String string3 = map.get("x-amz-cek-alg");
        boolean bl = lArray != null;
        ContentCryptoScheme contentCryptoScheme = ContentCryptoScheme.fromCEKAlgo(string3, bl);
        if (bl) {
            byArray2 = contentCryptoScheme.adjustIV(byArray2, lArray[0]);
        } else {
            int n;
            int n2 = contentCryptoScheme.getTagLengthInBits();
            if (n2 > 0 && n2 != (n = Integer.parseInt((String)(object = map.get("x-amz-tag-len"))))) {
                throw new AmazonClientException("Unsupported tag length: " + n + ", expected: " + n2);
            }
        }
        String string4 = map.get("x-amz-wrap-alg");
        object = ContentCryptoMaterial.cek(byArray, string4, encryptionMaterials, provider);
        return new ContentCryptoMaterial(map2, byArray, string4, contentCryptoScheme.createCipherLite((SecretKey)object, byArray2, 2, provider));
    }

    static ContentCryptoMaterial fromInstructionFile(Map<String, String> map, EncryptionMaterialsAccessor encryptionMaterialsAccessor, Provider provider, long[] lArray) {
        return ContentCryptoMaterial.fromInstructionFile0(map, encryptionMaterialsAccessor, provider, lArray);
    }

    private static ContentCryptoMaterial fromInstructionFile0(Map<String, String> map, EncryptionMaterialsAccessor encryptionMaterialsAccessor, Provider provider, long[] lArray) {
        Object object;
        EncryptionMaterials encryptionMaterials;
        String string = map.get("x-amz-key-v2");
        if (string == null && (string = map.get("x-amz-key")) == null) {
            throw new AmazonClientException("Content encrypting key not found.");
        }
        byte[] byArray = Base64.decode((String)string);
        byte[] byArray2 = Base64.decode((String)map.get("x-amz-iv"));
        if (byArray == null || byArray2 == null) {
            throw new AmazonClientException("Necessary encryption info not found in the instruction file " + map);
        }
        String string2 = map.get("x-amz-matdesc");
        Map<String, String> map2 = ContentCryptoMaterial.matdescFromJson(string2);
        EncryptionMaterials encryptionMaterials2 = encryptionMaterials = encryptionMaterialsAccessor == null ? null : encryptionMaterialsAccessor.getEncryptionMaterials(map2);
        if (encryptionMaterials == null) {
            throw new AmazonClientException("Unable to retrieve the encryption materials that originally encrypted object corresponding to instruction file " + map);
        }
        String string3 = map.get("x-amz-cek-alg");
        boolean bl = lArray != null;
        ContentCryptoScheme contentCryptoScheme = ContentCryptoScheme.fromCEKAlgo(string3, bl);
        if (bl) {
            byArray2 = contentCryptoScheme.adjustIV(byArray2, lArray[0]);
        } else {
            int n;
            int n2 = contentCryptoScheme.getTagLengthInBits();
            if (n2 > 0 && n2 != (n = Integer.parseInt((String)(object = map.get("x-amz-tag-len"))))) {
                throw new AmazonClientException("Unsupported tag length: " + n + ", expected: " + n2);
            }
        }
        String string4 = map.get("x-amz-wrap-alg");
        object = ContentCryptoMaterial.cek(byArray, string4, encryptionMaterials, provider);
        return new ContentCryptoMaterial(map2, byArray, string4, contentCryptoScheme.createCipherLite((SecretKey)object, byArray2, 2, provider));
    }

    static String parseInstructionFile(S3Object s3Object) {
        try {
            return ContentCryptoMaterial.convertStreamToString((InputStream)((Object)s3Object.getObjectContent()));
        }
        catch (Exception exception) {
            throw new AmazonClientException("Error parsing JSON instruction file: " + exception.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String convertStreamToString(InputStream inputStream) throws IOException {
        if (inputStream == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        try {
            String string;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            while ((string = bufferedReader.readLine()) != null) {
                stringBuilder.append(string);
            }
        }
        finally {
            inputStream.close();
        }
        return stringBuilder.toString();
    }

    CipherLite getCipherLite() {
        return this.cipherLite;
    }

    Map<String, String> getKEKMaterialsDescription() {
        return this.kekMaterialsDescription;
    }

    byte[] getEncryptedCEK() {
        return (byte[])this.encryptedCEK.clone();
    }
}

