/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.internal;

import com.amazonaws.AmazonClientException;
import com.amazonaws.Request;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSSessionCredentials;
import com.amazonaws.auth.AbstractAWSSigner;
import com.amazonaws.auth.SigningAlgorithm;
import com.amazonaws.services.s3.internal.RestUtils;
import java.util.Date;

public class S3QueryStringSigner<T>
extends AbstractAWSSigner {
    private final String httpVerb;
    private final String resourcePath;
    private final Date expiration;

    public S3QueryStringSigner(String string, String string2, Date date) {
        this.httpVerb = string;
        this.resourcePath = string2;
        this.expiration = date;
        if (string2 == null) {
            throw new IllegalArgumentException("Parameter resourcePath is empty");
        }
    }

    public void sign(Request<?> request, AWSCredentials aWSCredentials) throws AmazonClientException {
        AWSCredentials aWSCredentials2 = this.sanitizeCredentials(aWSCredentials);
        if (aWSCredentials2 instanceof AWSSessionCredentials) {
            this.addSessionCredentials(request, (AWSSessionCredentials)aWSCredentials2);
        }
        String string = Long.toString(this.expiration.getTime() / 1000L);
        String string2 = RestUtils.makeS3CanonicalString(this.httpVerb, this.resourcePath, request, string);
        String string3 = super.signAndBase64Encode(string2, aWSCredentials2.getAWSSecretKey(), SigningAlgorithm.HmacSHA1);
        request.addParameter("AWSAccessKeyId", aWSCredentials2.getAWSAccessKeyId());
        request.addParameter("Expires", string);
        request.addParameter("Signature", string3);
    }

    protected void addSessionCredentials(Request<?> request, AWSSessionCredentials aWSSessionCredentials) {
        request.addParameter("x-amz-security-token", aWSSessionCredentials.getSessionToken());
    }
}

