/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.model;

import com.amazonaws.services.s3.model.StorageClass;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

public class BucketLifecycleConfiguration {
    public static final String ENABLED = "Enabled";
    public static final String DISABLED = "Disabled";
    private List<Rule> rules;

    public List<Rule> getRules() {
        return this.rules;
    }

    public void setRules(List<Rule> list) {
        this.rules = list;
    }

    public BucketLifecycleConfiguration withRules(List<Rule> list) {
        this.setRules(list);
        return this;
    }

    public BucketLifecycleConfiguration withRules(Rule ... ruleArray) {
        this.setRules(Arrays.asList(ruleArray));
        return this;
    }

    public BucketLifecycleConfiguration(List<Rule> list) {
        this.rules = list;
    }

    public BucketLifecycleConfiguration() {
    }

    public static class NoncurrentVersionTransition {
        private int days = -1;
        private StorageClass storageClass;

        public void setDays(int n) {
            this.days = n;
        }

        public int getDays() {
            return this.days;
        }

        public NoncurrentVersionTransition withDays(int n) {
            this.days = n;
            return this;
        }

        public void setStorageClass(StorageClass storageClass) {
            this.storageClass = storageClass;
        }

        public StorageClass getStorageClass() {
            return this.storageClass;
        }

        public NoncurrentVersionTransition withStorageClass(StorageClass storageClass) {
            this.storageClass = storageClass;
            return this;
        }
    }

    public static class Transition {
        private int days = -1;
        private Date date;
        private StorageClass storageClass;

        public void setDays(int n) {
            this.days = n;
        }

        public int getDays() {
            return this.days;
        }

        public Transition withDays(int n) {
            this.days = n;
            return this;
        }

        public void setStorageClass(StorageClass storageClass) {
            this.storageClass = storageClass;
        }

        public StorageClass getStorageClass() {
            return this.storageClass;
        }

        public Transition withStorageClass(StorageClass storageClass) {
            this.storageClass = storageClass;
            return this;
        }

        public void setDate(Date date) {
            this.date = date;
        }

        public Date getDate() {
            return this.date;
        }

        public Transition withDate(Date date) {
            this.date = date;
            return this;
        }
    }

    public static class Rule {
        private String id;
        private String prefix;
        private String status;
        private int expirationInDays = -1;
        private int noncurrentVersionExpirationInDays = -1;
        private Date expirationDate;
        private Transition transition;
        private NoncurrentVersionTransition noncurrentVersionTransition;

        public void setId(String string) {
            this.id = string;
        }

        public void setPrefix(String string) {
            this.prefix = string;
        }

        public void setExpirationInDays(int n) {
            this.expirationInDays = n;
        }

        public void setNoncurrentVersionExpirationInDays(int n) {
            this.noncurrentVersionExpirationInDays = n;
        }

        public String getId() {
            return this.id;
        }

        public Rule withId(String string) {
            this.id = string;
            return this;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public Rule withPrefix(String string) {
            this.prefix = string;
            return this;
        }

        public int getExpirationInDays() {
            return this.expirationInDays;
        }

        public Rule withExpirationInDays(int n) {
            this.expirationInDays = n;
            return this;
        }

        public int getNoncurrentVersionExpirationInDays() {
            return this.noncurrentVersionExpirationInDays;
        }

        public Rule withNoncurrentVersionExpirationInDays(int n) {
            this.setNoncurrentVersionExpirationInDays(n);
            return this;
        }

        public String getStatus() {
            return this.status;
        }

        public void setStatus(String string) {
            this.status = string;
        }

        public Rule withStatus(String string) {
            this.setStatus(string);
            return this;
        }

        public void setExpirationDate(Date date) {
            this.expirationDate = date;
        }

        public Date getExpirationDate() {
            return this.expirationDate;
        }

        public Rule withExpirationDate(Date date) {
            this.expirationDate = date;
            return this;
        }

        public void setTransition(Transition transition) {
            this.transition = transition;
        }

        public Transition getTransition() {
            return this.transition;
        }

        public Rule withTransition(Transition transition) {
            this.transition = transition;
            return this;
        }

        public void setNoncurrentVersionTransition(NoncurrentVersionTransition noncurrentVersionTransition) {
            this.noncurrentVersionTransition = noncurrentVersionTransition;
        }

        public NoncurrentVersionTransition getNoncurrentVersionTransition() {
            return this.noncurrentVersionTransition;
        }

        public Rule withNoncurrentVersionTransition(NoncurrentVersionTransition noncurrentVersionTransition) {
            this.setNoncurrentVersionTransition(noncurrentVersionTransition);
            return this;
        }
    }
}

