/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.internal.crypto;

import com.amazonaws.services.s3.internal.crypto.ContentCryptoScheme;
import com.amazonaws.services.s3.internal.crypto.S3KeyWrapScheme;
import java.security.SecureRandom;

final class S3CryptoScheme {
    static final String AES = "AES";
    static final String RSA = "RSA";
    private static final SecureRandom srand = new SecureRandom();
    private static final S3KeyWrapScheme kwScheme = new S3KeyWrapScheme();
    private final ContentCryptoScheme contentCryptoScheme;

    S3CryptoScheme(ContentCryptoScheme contentCryptoScheme) {
        this.contentCryptoScheme = contentCryptoScheme;
    }

    SecureRandom getSecureRandom() {
        return srand;
    }

    ContentCryptoScheme getContentCryptoScheme() {
        return this.contentCryptoScheme;
    }

    S3KeyWrapScheme getKeyWrapScheme() {
        return kwScheme;
    }

    static boolean isAesGcm(String string) {
        return ContentCryptoScheme.AES_GCM.getCipherAlgorithm().equals(string);
    }
}

