/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.internal;

import com.amazonaws.AmazonClientException;
import com.amazonaws.internal.SdkDigestInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.util.Arrays;

public class DigestValidationInputStream
extends SdkDigestInputStream {
    private byte[] expectedHash;
    private boolean digestValidated = false;

    public DigestValidationInputStream(InputStream inputStream, MessageDigest messageDigest, byte[] byArray) {
        super(inputStream, messageDigest);
        this.expectedHash = byArray;
    }

    public int read() throws IOException {
        int n = super.read();
        if (n == -1) {
            this.validateMD5Digest();
        }
        return n;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = super.read(byArray, n, n2);
        if (n3 == -1) {
            this.validateMD5Digest();
        }
        return n3;
    }

    public byte[] getMD5Checksum() {
        return this.digest.digest();
    }

    private void validateMD5Digest() {
        if (this.expectedHash != null && !this.digestValidated) {
            this.digestValidated = true;
            if (!Arrays.equals(this.digest.digest(), this.expectedHash)) {
                throw new AmazonClientException("Unable to verify integrity of data download.  Client calculated content hash didn't match hash calculated by Amazon S3.  The data may be corrupt.");
            }
        }
    }
}

