/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobile.client.results;

import com.amazonaws.mobileconnectors.cognitoidentityprovider.util.CognitoJWTParser;
import java.util.Date;

public class Token {
    public static final int MILLIS_PER_SEC = 1000;
    private final String token;

    public Token(String token) {
        this.token = token;
    }

    public String getTokenString() {
        return this.token;
    }

    public Date getExpiration() {
        return this.getClaimDate("exp");
    }

    public Date getNotBefore() {
        return this.getClaimDate("nbf");
    }

    public Date getIssuedAt() {
        return this.getClaimDate("iat");
    }

    Date getClaimDate(String claimStr) {
        try {
            String claim = CognitoJWTParser.getClaim((String)this.token, (String)claimStr);
            if (claim == null) {
                return null;
            }
            long epocTimeSec = Long.parseLong(claim);
            long epocTimeMilliSec = epocTimeSec * 1000L;
            return new Date(epocTimeMilliSec);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to get claim from token", e);
        }
    }

    public String getClaim(String claim) {
        return CognitoJWTParser.getClaim((String)this.token, (String)claim);
    }
}

