/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kms.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.kms.model.KeyAgreementAlgorithmSpec;
import com.amazonaws.services.kms.model.RecipientInfo;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DeriveSharedSecretRequest
extends AmazonWebServiceRequest
implements Serializable {
    private String keyId;
    private String keyAgreementAlgorithm;
    private ByteBuffer publicKey;
    private List<String> grantTokens = new ArrayList<String>();
    private Boolean dryRun;
    private RecipientInfo recipient;

    public String getKeyId() {
        return this.keyId;
    }

    public void setKeyId(String keyId) {
        this.keyId = keyId;
    }

    public DeriveSharedSecretRequest withKeyId(String keyId) {
        this.keyId = keyId;
        return this;
    }

    public String getKeyAgreementAlgorithm() {
        return this.keyAgreementAlgorithm;
    }

    public void setKeyAgreementAlgorithm(String keyAgreementAlgorithm) {
        this.keyAgreementAlgorithm = keyAgreementAlgorithm;
    }

    public DeriveSharedSecretRequest withKeyAgreementAlgorithm(String keyAgreementAlgorithm) {
        this.keyAgreementAlgorithm = keyAgreementAlgorithm;
        return this;
    }

    public void setKeyAgreementAlgorithm(KeyAgreementAlgorithmSpec keyAgreementAlgorithm) {
        this.keyAgreementAlgorithm = keyAgreementAlgorithm.toString();
    }

    public DeriveSharedSecretRequest withKeyAgreementAlgorithm(KeyAgreementAlgorithmSpec keyAgreementAlgorithm) {
        this.keyAgreementAlgorithm = keyAgreementAlgorithm.toString();
        return this;
    }

    public ByteBuffer getPublicKey() {
        return this.publicKey;
    }

    public void setPublicKey(ByteBuffer publicKey) {
        this.publicKey = publicKey;
    }

    public DeriveSharedSecretRequest withPublicKey(ByteBuffer publicKey) {
        this.publicKey = publicKey;
        return this;
    }

    public List<String> getGrantTokens() {
        return this.grantTokens;
    }

    public void setGrantTokens(Collection<String> grantTokens) {
        if (grantTokens == null) {
            this.grantTokens = null;
            return;
        }
        this.grantTokens = new ArrayList<String>(grantTokens);
    }

    public DeriveSharedSecretRequest withGrantTokens(String ... grantTokens) {
        if (this.getGrantTokens() == null) {
            this.grantTokens = new ArrayList<String>(grantTokens.length);
        }
        for (String value : grantTokens) {
            this.grantTokens.add(value);
        }
        return this;
    }

    public DeriveSharedSecretRequest withGrantTokens(Collection<String> grantTokens) {
        this.setGrantTokens(grantTokens);
        return this;
    }

    public Boolean isDryRun() {
        return this.dryRun;
    }

    public Boolean getDryRun() {
        return this.dryRun;
    }

    public void setDryRun(Boolean dryRun) {
        this.dryRun = dryRun;
    }

    public DeriveSharedSecretRequest withDryRun(Boolean dryRun) {
        this.dryRun = dryRun;
        return this;
    }

    public RecipientInfo getRecipient() {
        return this.recipient;
    }

    public void setRecipient(RecipientInfo recipient) {
        this.recipient = recipient;
    }

    public DeriveSharedSecretRequest withRecipient(RecipientInfo recipient) {
        this.recipient = recipient;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getKeyId() != null) {
            sb.append("KeyId: " + this.getKeyId() + ",");
        }
        if (this.getKeyAgreementAlgorithm() != null) {
            sb.append("KeyAgreementAlgorithm: " + this.getKeyAgreementAlgorithm() + ",");
        }
        if (this.getPublicKey() != null) {
            sb.append("PublicKey: " + this.getPublicKey() + ",");
        }
        if (this.getGrantTokens() != null) {
            sb.append("GrantTokens: " + this.getGrantTokens() + ",");
        }
        if (this.getDryRun() != null) {
            sb.append("DryRun: " + this.getDryRun() + ",");
        }
        if (this.getRecipient() != null) {
            sb.append("Recipient: " + this.getRecipient());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getKeyId() == null ? 0 : this.getKeyId().hashCode());
        hashCode = 31 * hashCode + (this.getKeyAgreementAlgorithm() == null ? 0 : this.getKeyAgreementAlgorithm().hashCode());
        hashCode = 31 * hashCode + (this.getPublicKey() == null ? 0 : this.getPublicKey().hashCode());
        hashCode = 31 * hashCode + (this.getGrantTokens() == null ? 0 : this.getGrantTokens().hashCode());
        hashCode = 31 * hashCode + (this.getDryRun() == null ? 0 : this.getDryRun().hashCode());
        hashCode = 31 * hashCode + (this.getRecipient() == null ? 0 : this.getRecipient().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeriveSharedSecretRequest)) {
            return false;
        }
        DeriveSharedSecretRequest other = (DeriveSharedSecretRequest)obj;
        if (other.getKeyId() == null ^ this.getKeyId() == null) {
            return false;
        }
        if (other.getKeyId() != null && !other.getKeyId().equals(this.getKeyId())) {
            return false;
        }
        if (other.getKeyAgreementAlgorithm() == null ^ this.getKeyAgreementAlgorithm() == null) {
            return false;
        }
        if (other.getKeyAgreementAlgorithm() != null && !other.getKeyAgreementAlgorithm().equals(this.getKeyAgreementAlgorithm())) {
            return false;
        }
        if (other.getPublicKey() == null ^ this.getPublicKey() == null) {
            return false;
        }
        if (other.getPublicKey() != null && !other.getPublicKey().equals(this.getPublicKey())) {
            return false;
        }
        if (other.getGrantTokens() == null ^ this.getGrantTokens() == null) {
            return false;
        }
        if (other.getGrantTokens() != null && !other.getGrantTokens().equals(this.getGrantTokens())) {
            return false;
        }
        if (other.getDryRun() == null ^ this.getDryRun() == null) {
            return false;
        }
        if (other.getDryRun() != null && !other.getDryRun().equals(this.getDryRun())) {
            return false;
        }
        if (other.getRecipient() == null ^ this.getRecipient() == null) {
            return false;
        }
        return other.getRecipient() == null || other.getRecipient().equals(this.getRecipient());
    }
}

