/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kms.model.transform;

import com.amazonaws.services.kms.model.MultiRegionConfiguration;
import com.amazonaws.services.kms.model.transform.MultiRegionKeyJsonUnmarshaller;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.ListUnmarshaller;
import com.amazonaws.transform.SimpleTypeJsonUnmarshallers;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.json.AwsJsonReader;

class MultiRegionConfigurationJsonUnmarshaller
implements Unmarshaller<MultiRegionConfiguration, JsonUnmarshallerContext> {
    private static MultiRegionConfigurationJsonUnmarshaller instance;

    MultiRegionConfigurationJsonUnmarshaller() {
    }

    public MultiRegionConfiguration unmarshall(JsonUnmarshallerContext context) throws Exception {
        AwsJsonReader reader = context.getReader();
        if (!reader.isContainer()) {
            reader.skipValue();
            return null;
        }
        MultiRegionConfiguration multiRegionConfiguration = new MultiRegionConfiguration();
        reader.beginObject();
        while (reader.hasNext()) {
            String name = reader.nextName();
            if (name.equals("MultiRegionKeyType")) {
                multiRegionConfiguration.setMultiRegionKeyType(SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("PrimaryKey")) {
                multiRegionConfiguration.setPrimaryKey(MultiRegionKeyJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("ReplicaKeys")) {
                multiRegionConfiguration.setReplicaKeys(new ListUnmarshaller((Unmarshaller)MultiRegionKeyJsonUnmarshaller.getInstance()).unmarshall(context));
                continue;
            }
            reader.skipValue();
        }
        reader.endObject();
        return multiRegionConfiguration;
    }

    public static MultiRegionConfigurationJsonUnmarshaller getInstance() {
        if (instance == null) {
            instance = new MultiRegionConfigurationJsonUnmarshaller();
        }
        return instance;
    }
}

