/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kms.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.kms.model.VerifyMacRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.AwsJsonWriter;
import com.amazonaws.util.json.JsonUtils;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.util.List;

public class VerifyMacRequestMarshaller
implements Marshaller<Request<VerifyMacRequest>, VerifyMacRequest> {
    public Request<VerifyMacRequest> marshall(VerifyMacRequest verifyMacRequest) {
        if (verifyMacRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(VerifyMacRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)verifyMacRequest, "AWSKMS");
        String target = "TrentService.VerifyMac";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/";
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = new StringWriter();
            AwsJsonWriter jsonWriter = JsonUtils.getJsonWriter((Writer)stringWriter);
            jsonWriter.beginObject();
            if (verifyMacRequest.getMessage() != null) {
                ByteBuffer message = verifyMacRequest.getMessage();
                jsonWriter.name("Message");
                jsonWriter.value(message);
            }
            if (verifyMacRequest.getKeyId() != null) {
                String keyId = verifyMacRequest.getKeyId();
                jsonWriter.name("KeyId");
                jsonWriter.value(keyId);
            }
            if (verifyMacRequest.getMacAlgorithm() != null) {
                String macAlgorithm = verifyMacRequest.getMacAlgorithm();
                jsonWriter.name("MacAlgorithm");
                jsonWriter.value(macAlgorithm);
            }
            if (verifyMacRequest.getMac() != null) {
                ByteBuffer mac = verifyMacRequest.getMac();
                jsonWriter.name("Mac");
                jsonWriter.value(mac);
            }
            if (verifyMacRequest.getGrantTokens() != null) {
                List<String> grantTokens = verifyMacRequest.getGrantTokens();
                jsonWriter.name("GrantTokens");
                jsonWriter.beginArray();
                for (String grantTokensItem : grantTokens) {
                    if (grantTokensItem == null) continue;
                    jsonWriter.value(grantTokensItem);
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
            jsonWriter.close();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        return request;
    }
}

