/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kms.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.kms.model.ReEncryptRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.AwsJsonWriter;
import com.amazonaws.util.json.JsonUtils;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;

public class ReEncryptRequestMarshaller
implements Marshaller<Request<ReEncryptRequest>, ReEncryptRequest> {
    public Request<ReEncryptRequest> marshall(ReEncryptRequest reEncryptRequest) {
        if (reEncryptRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)reEncryptRequest, "AWSKMS");
        String target = "TrentService.ReEncrypt";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            ListWithAutoConstructFlag grantTokensList;
            StringWriter stringWriter = new StringWriter();
            AwsJsonWriter jsonWriter = JsonUtils.getJsonWriter((Writer)stringWriter);
            jsonWriter.beginObject();
            if (reEncryptRequest.getCiphertextBlob() != null) {
                jsonWriter.name("CiphertextBlob").value(reEncryptRequest.getCiphertextBlob());
            }
            if (reEncryptRequest.getSourceEncryptionContext() != null) {
                jsonWriter.name("SourceEncryptionContext");
                jsonWriter.beginObject();
                for (Map.Entry<String, String> sourceEncryptionContextListValue : reEncryptRequest.getSourceEncryptionContext().entrySet()) {
                    if (sourceEncryptionContextListValue.getValue() == null) continue;
                    jsonWriter.name(sourceEncryptionContextListValue.getKey());
                    jsonWriter.value(sourceEncryptionContextListValue.getValue());
                }
                jsonWriter.endObject();
            }
            if (reEncryptRequest.getDestinationKeyId() != null) {
                jsonWriter.name("DestinationKeyId").value(reEncryptRequest.getDestinationKeyId());
            }
            if (reEncryptRequest.getDestinationEncryptionContext() != null) {
                jsonWriter.name("DestinationEncryptionContext");
                jsonWriter.beginObject();
                for (Map.Entry<String, String> destinationEncryptionContextListValue : reEncryptRequest.getDestinationEncryptionContext().entrySet()) {
                    if (destinationEncryptionContextListValue.getValue() == null) continue;
                    jsonWriter.name((String)destinationEncryptionContextListValue.getKey());
                    jsonWriter.value((String)destinationEncryptionContextListValue.getValue());
                }
                jsonWriter.endObject();
            }
            if (!((grantTokensList = (ListWithAutoConstructFlag)reEncryptRequest.getGrantTokens()) == null || grantTokensList.isAutoConstruct() && grantTokensList.isEmpty())) {
                jsonWriter.name("GrantTokens");
                jsonWriter.beginArray();
                for (String grantTokensListValue : grantTokensList) {
                    if (grantTokensListValue == null) continue;
                    jsonWriter.value(grantTokensListValue);
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
            jsonWriter.close();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

