/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesisvideo.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.kinesisvideo.model.ListStreamsRequest;
import com.amazonaws.services.kinesisvideo.model.StreamNameCondition;
import com.amazonaws.services.kinesisvideo.model.transform.StreamNameConditionJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.AwsJsonWriter;
import com.amazonaws.util.json.JsonUtils;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;

public class ListStreamsRequestMarshaller
implements Marshaller<Request<ListStreamsRequest>, ListStreamsRequest> {
    public Request<ListStreamsRequest> marshall(ListStreamsRequest listStreamsRequest) {
        if (listStreamsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(ListStreamsRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)listStreamsRequest, "AWSKinesisVideo");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/listStreams";
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = new StringWriter();
            AwsJsonWriter jsonWriter = JsonUtils.getJsonWriter((Writer)stringWriter);
            jsonWriter.beginObject();
            if (listStreamsRequest.getMaxResults() != null) {
                Integer maxResults = listStreamsRequest.getMaxResults();
                jsonWriter.name("MaxResults");
                jsonWriter.value((Number)maxResults);
            }
            if (listStreamsRequest.getNextToken() != null) {
                String nextToken = listStreamsRequest.getNextToken();
                jsonWriter.name("NextToken");
                jsonWriter.value(nextToken);
            }
            if (listStreamsRequest.getStreamNameCondition() != null) {
                StreamNameCondition streamNameCondition = listStreamsRequest.getStreamNameCondition();
                jsonWriter.name("StreamNameCondition");
                StreamNameConditionJsonMarshaller.getInstance().marshall(streamNameCondition, jsonWriter);
            }
            jsonWriter.endObject();
            jsonWriter.close();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "application/x-amz-json-1.0");
        }
        return request;
    }
}

