/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesisvideo.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.kinesisvideo.model.CreateSignalingChannelRequest;
import com.amazonaws.services.kinesisvideo.model.SingleMasterConfiguration;
import com.amazonaws.services.kinesisvideo.model.Tag;
import com.amazonaws.services.kinesisvideo.model.transform.SingleMasterConfigurationJsonMarshaller;
import com.amazonaws.services.kinesisvideo.model.transform.TagJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.AwsJsonWriter;
import com.amazonaws.util.json.JsonUtils;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;

public class CreateSignalingChannelRequestMarshaller
implements Marshaller<Request<CreateSignalingChannelRequest>, CreateSignalingChannelRequest> {
    public Request<CreateSignalingChannelRequest> marshall(CreateSignalingChannelRequest createSignalingChannelRequest) {
        if (createSignalingChannelRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(CreateSignalingChannelRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createSignalingChannelRequest, "AWSKinesisVideo");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/createSignalingChannel";
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = new StringWriter();
            AwsJsonWriter jsonWriter = JsonUtils.getJsonWriter((Writer)stringWriter);
            jsonWriter.beginObject();
            if (createSignalingChannelRequest.getChannelName() != null) {
                String channelName = createSignalingChannelRequest.getChannelName();
                jsonWriter.name("ChannelName");
                jsonWriter.value(channelName);
            }
            if (createSignalingChannelRequest.getChannelType() != null) {
                String channelType = createSignalingChannelRequest.getChannelType();
                jsonWriter.name("ChannelType");
                jsonWriter.value(channelType);
            }
            if (createSignalingChannelRequest.getSingleMasterConfiguration() != null) {
                SingleMasterConfiguration singleMasterConfiguration = createSignalingChannelRequest.getSingleMasterConfiguration();
                jsonWriter.name("SingleMasterConfiguration");
                SingleMasterConfigurationJsonMarshaller.getInstance().marshall(singleMasterConfiguration, jsonWriter);
            }
            if (createSignalingChannelRequest.getTags() != null) {
                List<Tag> tags = createSignalingChannelRequest.getTags();
                jsonWriter.name("Tags");
                jsonWriter.beginArray();
                for (Tag tagsItem : tags) {
                    if (tagsItem == null) continue;
                    TagJsonMarshaller.getInstance().marshall(tagsItem, jsonWriter);
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
            jsonWriter.close();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "application/x-amz-json-1.0");
        }
        return request;
    }
}

