/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesisvideo.model;

import com.amazonaws.AmazonWebServiceRequest;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class UntagResourceRequest
extends AmazonWebServiceRequest
implements Serializable {
    private String resourceARN;
    private List<String> tagKeyList = new ArrayList<String>();

    public String getResourceARN() {
        return this.resourceARN;
    }

    public void setResourceARN(String resourceARN) {
        this.resourceARN = resourceARN;
    }

    public UntagResourceRequest withResourceARN(String resourceARN) {
        this.resourceARN = resourceARN;
        return this;
    }

    public List<String> getTagKeyList() {
        return this.tagKeyList;
    }

    public void setTagKeyList(Collection<String> tagKeyList) {
        if (tagKeyList == null) {
            this.tagKeyList = null;
            return;
        }
        this.tagKeyList = new ArrayList<String>(tagKeyList);
    }

    public UntagResourceRequest withTagKeyList(String ... tagKeyList) {
        if (this.getTagKeyList() == null) {
            this.tagKeyList = new ArrayList<String>(tagKeyList.length);
        }
        for (String value : tagKeyList) {
            this.tagKeyList.add(value);
        }
        return this;
    }

    public UntagResourceRequest withTagKeyList(Collection<String> tagKeyList) {
        this.setTagKeyList(tagKeyList);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getResourceARN() != null) {
            sb.append("ResourceARN: " + this.getResourceARN() + ",");
        }
        if (this.getTagKeyList() != null) {
            sb.append("TagKeyList: " + this.getTagKeyList());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getResourceARN() == null ? 0 : this.getResourceARN().hashCode());
        hashCode = 31 * hashCode + (this.getTagKeyList() == null ? 0 : this.getTagKeyList().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UntagResourceRequest)) {
            return false;
        }
        UntagResourceRequest other = (UntagResourceRequest)obj;
        if (other.getResourceARN() == null ^ this.getResourceARN() == null) {
            return false;
        }
        if (other.getResourceARN() != null && !other.getResourceARN().equals(this.getResourceARN())) {
            return false;
        }
        if (other.getTagKeyList() == null ^ this.getTagKeyList() == null) {
            return false;
        }
        return other.getTagKeyList() == null || other.getTagKeyList().equals(this.getTagKeyList());
    }
}

