/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.kinesisvideo.util;

import android.media.MediaCodec;
import android.util.Log;
import com.amazonaws.kinesisvideo.producer.KinesisVideoFrame;
import java.nio.ByteBuffer;

public class FrameUtility {
    private static final String TAG = FrameUtility.class.getSimpleName();
    private static final int FRAME_FLAG_KEY_FRAME = 1;
    private static final int FRAME_FLAG_NONE = 0;
    private static final long FRAME_DURATION_2_MS = 2L;
    private static final long HUNDREDS_OF_NANOS_IN_MS = 10000L;

    public static KinesisVideoFrame createFrame(MediaCodec.BufferInfo bufferInfo, long timeCodeMs, int frameIndex, ByteBuffer encodedFrameData) {
        long currentTimeMs = System.currentTimeMillis();
        int flags = FrameUtility.isKeyFrame(bufferInfo) ? 1 : 0;
        Log.d((String)TAG, (String)("frame timestamp: " + currentTimeMs + ", index: " + frameIndex + ", duration: " + 2L + ", keyFrame: " + FrameUtility.isKeyFrame(bufferInfo) + ", flags: " + flags));
        return new KinesisVideoFrame(frameIndex, flags, currentTimeMs * 10000L, currentTimeMs * 10000L, 20000L, encodedFrameData);
    }

    private static boolean isKeyFrame(MediaCodec.BufferInfo bufferInfo) {
        return (bufferInfo.flags & 1) != 0;
    }
}

