/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.kinesisvideo.mediasource.android;

import android.content.Context;
import android.media.ImageReader;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import android.view.Surface;
import com.amazonaws.kinesisvideo.client.mediasource.CameraMediaSourceConfiguration;
import com.amazonaws.kinesisvideo.client.mediasource.MediaSourceState;
import com.amazonaws.kinesisvideo.common.exception.KinesisVideoException;
import com.amazonaws.kinesisvideo.internal.client.mediasource.MediaSource;
import com.amazonaws.kinesisvideo.internal.client.mediasource.MediaSourceConfiguration;
import com.amazonaws.kinesisvideo.internal.client.mediasource.MediaSourceSink;
import com.amazonaws.kinesisvideo.producer.KinesisVideoFrame;
import com.amazonaws.kinesisvideo.producer.StreamCallbacks;
import com.amazonaws.kinesisvideo.producer.StreamInfo;
import com.amazonaws.kinesisvideo.producer.Tag;
import com.amazonaws.kinesisvideo.util.StreamInfoConstants;
import com.amazonaws.mobileconnectors.kinesisvideo.camera.CameraFramesSource;
import com.amazonaws.mobileconnectors.kinesisvideo.camera.EncodingCancellationToken;
import com.amazonaws.mobileconnectors.kinesisvideo.encoding.EncoderWrapper;
import java.util.Arrays;
import java.util.List;

public class AndroidCameraMediaSource
implements MediaSource {
    private static final String TAG = AndroidCameraMediaSource.class.getSimpleName();
    private static final int TWO_FRAMES_BUFFER = 2;
    private final Context mContext;
    private final String mStreamName;
    private CameraFramesSource mCameraFramesSource;
    private EncodingCancellationToken mEncodingCancellationToken;
    private List<Surface> mPreivewSurfaces;
    private MediaSourceState mMediaSourceState;
    private CameraMediaSourceConfiguration mMediaSourceConfiguration;
    private MediaSourceSink mMediaSourceSink;

    public AndroidCameraMediaSource(String streamName, Context context) {
        this.mContext = context;
        this.mStreamName = streamName;
        this.mEncodingCancellationToken = new EncodingCancellationToken();
    }

    public void setPreviewSurfaces(Surface ... surfaces) {
        this.mPreivewSurfaces = Arrays.asList(surfaces);
    }

    private CameraFramesSource createFramesSource(ImageReader imageReader) {
        this.mEncodingCancellationToken = new EncodingCancellationToken();
        CameraFramesSource cameraFramesSource = new CameraFramesSource(imageReader, this.mMediaSourceConfiguration, this.mEncodingCancellationToken);
        cameraFramesSource.setCodecPrivateDataListener(this.waitForCodecPrivateData());
        cameraFramesSource.setFramesListener(this.pushFrameToSink());
        return cameraFramesSource;
    }

    @Override
    public MediaSourceState getMediaSourceState() {
        return this.mMediaSourceState;
    }

    @Override
    public MediaSourceConfiguration getConfiguration() {
        return this.mMediaSourceConfiguration;
    }

    @Override
    public StreamInfo getStreamInfo() throws KinesisVideoException {
        String contentType = this.mMediaSourceConfiguration.getEncoderMimeType();
        if (contentType.equals("video/avc")) {
            contentType = "video/h264";
        }
        return new StreamInfo(0, this.mStreamName, StreamInfo.StreamingType.STREAMING_TYPE_REALTIME, contentType, StreamInfoConstants.NO_KMS_KEY_ID, (long)this.mMediaSourceConfiguration.getRetentionPeriodInHours() * 36000000000L, false, 1200000000L, 20000000L, true, false, this.mMediaSourceConfiguration.getIsAbsoluteTimecode(), true, true, StreamInfo.codecIdFromContentType(this.mMediaSourceConfiguration.getEncoderMimeType()), StreamInfo.createTrackName(this.mMediaSourceConfiguration.getEncoderMimeType()), this.mMediaSourceConfiguration.getBitRate(), this.mMediaSourceConfiguration.getFrameRate(), 400000000L, 200000000L, 200000000L, this.mMediaSourceConfiguration.getTimeScale() / 100L, true, this.mMediaSourceConfiguration.getCodecPrivateData(), new Tag[]{new Tag("device", "Test Device"), new Tag("stream", "Test Stream")}, this.mMediaSourceConfiguration.getNalAdaptationFlags());
    }

    @Override
    public void initialize(@NonNull MediaSourceSink mediaSourceSink) throws KinesisVideoException {
        this.mMediaSourceSink = mediaSourceSink;
        this.mMediaSourceState = MediaSourceState.INITIALIZED;
    }

    @Override
    public void configure(MediaSourceConfiguration configuration) {
        if (!(configuration instanceof CameraMediaSourceConfiguration)) {
            throw new IllegalArgumentException("expected instance of CameraMediaSourceConfiguration, received " + configuration);
        }
        this.mMediaSourceConfiguration = (CameraMediaSourceConfiguration)configuration;
        this.mCameraFramesSource = this.createFramesSource(this.createImageReader());
    }

    private ImageReader createImageReader() {
        return ImageReader.newInstance((int)this.mMediaSourceConfiguration.getHorizontalResolution(), (int)this.mMediaSourceConfiguration.getVerticalResolution(), (int)35, (int)2);
    }

    @Override
    public void start() throws KinesisVideoException {
        this.mMediaSourceState = MediaSourceState.RUNNING;
        this.startEncoding();
    }

    @Override
    public void stop() throws KinesisVideoException {
        this.stopEncoding();
        this.mMediaSourceState = MediaSourceState.STOPPED;
    }

    @Override
    public boolean isStopped() {
        return this.mMediaSourceState == MediaSourceState.STOPPED;
    }

    @Override
    public void free() throws KinesisVideoException {
    }

    @Override
    @Nullable
    public StreamCallbacks getStreamCallbacks() {
        return null;
    }

    private void startEncoding() {
        Log.i((String)TAG, (String)"encoding starting");
        this.mCameraFramesSource.startEncoding(this.mContext, this.mPreivewSurfaces, this.mMediaSourceConfiguration.getCameraId());
    }

    private void stopEncoding() {
        Log.i((String)TAG, (String)"encoding stopping");
        if (this.mEncodingCancellationToken == null) {
            return;
        }
        this.mEncodingCancellationToken.cancelEncoding();
        this.mEncodingCancellationToken = null;
    }

    private EncoderWrapper.CodecPrivateDataAvailableListener waitForCodecPrivateData() {
        return new EncoderWrapper.CodecPrivateDataAvailableListener(){

            @Override
            public void onCodecPrivateDataAvailable(byte[] privateData) {
                AndroidCameraMediaSource.this.updateSinkWithPrivateData(privateData);
            }
        };
    }

    private void updateSinkWithPrivateData(byte[] privateData) {
        try {
            Log.i((String)TAG, (String)"updating sink with codec private data");
            this.mMediaSourceSink.onCodecPrivateData(privateData);
        }
        catch (KinesisVideoException e) {
            Log.e((String)TAG, (String)"error updating sink with codec private data", (Throwable)e);
            throw new RuntimeException("error updating sink with codec private data", e);
        }
    }

    private EncoderWrapper.FrameAvailableListener pushFrameToSink() {
        return new EncoderWrapper.FrameAvailableListener(){

            @Override
            public void onFrameAvailable(KinesisVideoFrame frame) {
                try {
                    Log.i((String)TAG, (String)"updating sink with frame");
                    AndroidCameraMediaSource.this.mMediaSourceSink.onFrame(frame);
                }
                catch (KinesisVideoException e) {
                    Log.e((String)TAG, (String)"error updating sink with frame", (Throwable)e);
                }
            }
        };
    }

    @Override
    public MediaSourceSink getMediaSourceSink() {
        return this.mMediaSourceSink;
    }

    public static interface CaptureCallback {
        public void onStarted();

        public void onFailed();
    }

    public static interface OpenCameraCallback {
        public void onOpened();

        public void onError(KinesisVideoException var1);
    }
}

