/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.kinesisvideo.client;

import android.app.ActivityManager;
import android.content.Context;
import android.os.Environment;
import android.support.annotation.NonNull;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.kinesisvideo.client.KinesisVideoClient;
import com.amazonaws.kinesisvideo.client.KinesisVideoClientConfiguration;
import com.amazonaws.kinesisvideo.common.exception.KinesisVideoException;
import com.amazonaws.kinesisvideo.common.logging.Log;
import com.amazonaws.kinesisvideo.common.logging.LogLevel;
import com.amazonaws.kinesisvideo.producer.DeviceInfo;
import com.amazonaws.kinesisvideo.producer.StorageInfo;
import com.amazonaws.kinesisvideo.producer.Tag;
import com.amazonaws.kinesisvideo.storage.DefaultStorageCallbacks;
import com.amazonaws.mobileconnectors.kinesisvideo.auth.KinesisVideoCredentialsProviderImpl;
import com.amazonaws.mobileconnectors.kinesisvideo.client.AndroidKinesisVideoClient;
import com.amazonaws.mobileconnectors.kinesisvideo.service.KinesisVideoAndroidServiceClient;
import com.amazonaws.mobileconnectors.kinesisvideo.util.AndroidLogOutputChannel;
import com.amazonaws.regions.Regions;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;

public final class KinesisVideoAndroidClientFactory {
    private static final int DEVICE_VERSION = 0;
    private static final int TEN_STREAMS = 10;
    private static final int SPILL_RATIO_90_PERCENT = 90;
    private static final long MIN_STORAGE_SIZE_64_MEGS = 0x4000000L;
    private static final long MAX_STORAGE_SIZE_384_MEGS = 0x18000000L;
    private static final double TOTAL_MEMORY_RATIO = 0.9;
    private static final String DEVICE_NAME = "android-client-library";
    private static final String STORAGE_PATH = Environment.getExternalStorageDirectory().getPath();
    private static final int NUMBER_OF_THREADS_IN_POOL = 2;
    private static final String LOG_TAG = "KinesisVideoAndroidClient";
    private static KinesisVideoClient KINESIS_VIDEO_CLIENT_INSTANCE = null;

    private KinesisVideoAndroidClientFactory() {
        throw new UnsupportedOperationException();
    }

    public static KinesisVideoClient createKinesisVideoClient(@NonNull Context context, @NonNull AWSCredentialsProvider credentialsProvider) throws KinesisVideoException {
        return KinesisVideoAndroidClientFactory.createKinesisVideoClient(context, Regions.DEFAULT_REGION, credentialsProvider);
    }

    public static KinesisVideoClient createKinesisVideoClient(@NonNull Context context, @NonNull Regions regions, @NonNull AWSCredentialsProvider awsCredentialsProvider) throws KinesisVideoException {
        AndroidLogOutputChannel outputChannel = new AndroidLogOutputChannel();
        Log log = new Log(outputChannel, LogLevel.VERBOSE, LOG_TAG);
        KinesisVideoCredentialsProviderImpl kinesisVideoCredentialsProvider = new KinesisVideoCredentialsProviderImpl(awsCredentialsProvider, log);
        KinesisVideoClientConfiguration configuration = KinesisVideoClientConfiguration.builder().withRegion(regions.getName()).withCredentialsProvider(kinesisVideoCredentialsProvider).withLogChannel(outputChannel).withStorageCallbacks(new DefaultStorageCallbacks()).build();
        ScheduledExecutorService executor = Executors.newScheduledThreadPool(2);
        return KinesisVideoAndroidClientFactory.createKinesisVideoClient(context, configuration, KinesisVideoAndroidClientFactory.defaultDeviceInfo(context), log, executor);
    }

    public static KinesisVideoClient createKinesisVideoClient(@NonNull Context context, @NonNull KinesisVideoClientConfiguration configuration, @NonNull DeviceInfo deviceInfo, @NonNull Log log, @NonNull ScheduledExecutorService executor) throws KinesisVideoException {
        if (KINESIS_VIDEO_CLIENT_INSTANCE == null) {
            KinesisVideoAndroidServiceClient serviceClient = new KinesisVideoAndroidServiceClient(log);
            AndroidKinesisVideoClient kinesisVideoClient = new AndroidKinesisVideoClient(log, context, configuration, serviceClient, executor);
            kinesisVideoClient.initialize(deviceInfo);
            KINESIS_VIDEO_CLIENT_INSTANCE = kinesisVideoClient;
        }
        return KINESIS_VIDEO_CLIENT_INSTANCE;
    }

    public static void freeKinesisVideoClient() throws KinesisVideoException {
        KINESIS_VIDEO_CLIENT_INSTANCE.free();
        KINESIS_VIDEO_CLIENT_INSTANCE = null;
    }

    private static DeviceInfo defaultDeviceInfo(@NonNull Context context) {
        return new DeviceInfo(0, DEVICE_NAME, KinesisVideoAndroidClientFactory.defaultStorageInfo(context), 10, KinesisVideoAndroidClientFactory.defaultDeviceTags());
    }

    private static StorageInfo defaultStorageInfo(@NonNull Context context) {
        return new StorageInfo(0, StorageInfo.DeviceStorageType.DEVICE_STORAGE_TYPE_IN_MEM, KinesisVideoAndroidClientFactory.defaultMemorySize(context), 90, STORAGE_PATH);
    }

    private static long defaultMemorySize(@NonNull Context context) {
        ActivityManager.MemoryInfo memoryInfo = new ActivityManager.MemoryInfo();
        ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
        if (activityManager == null) {
            return 0x4000000L;
        }
        activityManager.getMemoryInfo(memoryInfo);
        long available = (long)((double)memoryInfo.availMem * 0.9);
        return Math.min(0x18000000L, available);
    }

    private static Tag[] defaultDeviceTags() {
        return null;
    }
}

