/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.kinesisvideo.stream.throttling;

import com.amazonaws.kinesisvideo.stream.throttling.BandwidthThrottler;
import java.io.IOException;
import java.io.OutputStream;

public class BandwidthThrottledOutputStream
extends OutputStream {
    private final OutputStream outputStream;
    private final BandwidthThrottler throttler;
    private final byte[] oneByteBuffer = new byte[1];

    public BandwidthThrottledOutputStream(OutputStream outputStream, BandwidthThrottler throttler) {
        this.outputStream = outputStream;
        this.throttler = throttler;
    }

    @Override
    public void write(int b) throws IOException {
        this.oneByteBuffer[0] = (byte)b;
        this.write(this.oneByteBuffer, 0, 1);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        int allowedBytesToWrite;
        for (int bytesWritten = 0; bytesWritten < len; bytesWritten += allowedBytesToWrite) {
            allowedBytesToWrite = this.throttler.getAllowedBytes(len - bytesWritten);
            this.outputStream.write(b, off + bytesWritten, allowedBytesToWrite);
        }
    }

    @Override
    public void flush() throws IOException {
        this.outputStream.flush();
    }

    @Override
    public void close() throws IOException {
        this.outputStream.close();
    }
}

