/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.kinesisvideo.model;

import com.amazonaws.kinesisvideo.model.ResponseStatus;
import java.io.InputStream;
import java.util.Map;

public class Response {
    private final ResponseStatus responseStatus;
    private final Map<String, String> responseHeaders;
    private final String responseBody;
    private final InputStream responsePayload;

    Response(ResponseBuilder builder) {
        this.responseStatus = builder.responseStatus;
        this.responseHeaders = builder.responseHeaders;
        this.responseBody = builder.responseBody;
        this.responsePayload = builder.responsePayload;
    }

    public static ResponseBuilder builder() {
        return new ResponseBuilder();
    }

    public String toString() {
        return "Response [responseStatus=" + this.responseStatus + ", responseHeaders=" + this.responseHeaders + ", super=" + super.toString() + "]";
    }

    public ResponseStatus getResponseStatus() {
        return this.responseStatus;
    }

    public Map<String, String> getResponseHeaders() {
        return this.responseHeaders;
    }

    public String getResponseBody() {
        return this.responseBody;
    }

    public InputStream getResponsePayload() {
        return this.responsePayload;
    }

    public static class ResponseBuilder {
        private ResponseStatus responseStatus;
        private Map<String, String> responseHeaders;
        private String responseBody;
        private InputStream responsePayload;

        ResponseBuilder() {
        }

        public ResponseBuilder responseStatus(ResponseStatus responseStatus) {
            this.responseStatus = responseStatus;
            return this;
        }

        public ResponseBuilder responseHeaders(Map<String, String> responseHeaders) {
            this.responseHeaders = responseHeaders;
            return this;
        }

        public ResponseBuilder responseBody(String responseBody) {
            this.responseBody = responseBody;
            return this;
        }

        public ResponseBuilder responsePayload(InputStream responsePayload) {
            this.responsePayload = responsePayload;
            return this;
        }

        public Response build() {
            return new Response(this);
        }
    }
}

