/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.kinesisvideo.internal.service;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.amazonaws.kinesisvideo.auth.KinesisVideoCredentials;
import com.amazonaws.kinesisvideo.auth.KinesisVideoCredentialsProvider;
import com.amazonaws.kinesisvideo.auth.StaticCredentialsProvider;
import com.amazonaws.kinesisvideo.client.KinesisVideoClientConfiguration;
import com.amazonaws.kinesisvideo.common.exception.KinesisVideoException;
import com.amazonaws.kinesisvideo.common.function.Consumer;
import com.amazonaws.kinesisvideo.common.logging.Log;
import com.amazonaws.kinesisvideo.common.preconditions.Preconditions;
import com.amazonaws.kinesisvideo.internal.producer.KinesisVideoProducer;
import com.amazonaws.kinesisvideo.internal.producer.KinesisVideoProducerStream;
import com.amazonaws.kinesisvideo.internal.producer.ServiceCallbacks;
import com.amazonaws.kinesisvideo.internal.producer.client.KinesisVideoServiceClient;
import com.amazonaws.kinesisvideo.internal.service.AckConsumer;
import com.amazonaws.kinesisvideo.internal.service.BlockingAckConsumer;
import com.amazonaws.kinesisvideo.producer.ProducerException;
import com.amazonaws.kinesisvideo.producer.StreamDescription;
import com.amazonaws.kinesisvideo.producer.Tag;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class DefaultServiceCallbacksImpl
implements ServiceCallbacks {
    private static final int HTTP_OK = 200;
    private static final int HTTP_BAD_REQUEST = 400;
    private static final int HTTP_NOT_FOUND = 404;
    private static final int HTTP_RESOURCE_IN_USE = 10003;
    private static final int HTTP_ACCESS_DENIED = 403;
    private static final String RESOURCE_NOT_FOUND = "ResourceNotFoundException";
    private static final String RESOURCE_IN_USE = "ResourceInUseException";
    private static final String ACCESS_DENIED = "AccessDeniedException";
    private final ScheduledExecutorService executor;
    private final KinesisVideoServiceClient kinesisVideoServiceClient;
    private final Log log;
    private final KinesisVideoClientConfiguration configuration;
    private KinesisVideoProducer kinesisVideoProducer = null;
    private final List<StreamingInfo> mStreams = new ArrayList<StreamingInfo>();
    private long uploadHandle;

    public DefaultServiceCallbacksImpl(@NonNull Log log, @NonNull ScheduledExecutorService executor, @NonNull KinesisVideoClientConfiguration configuration, @NonNull KinesisVideoServiceClient kinesisVideoServiceClient) {
        this.executor = Preconditions.checkNotNull(executor);
        this.kinesisVideoServiceClient = Preconditions.checkNotNull(kinesisVideoServiceClient);
        this.log = Preconditions.checkNotNull(log);
        this.configuration = Preconditions.checkNotNull(configuration);
        this.uploadHandle = 0L;
        try {
            this.kinesisVideoServiceClient.initialize(configuration);
        }
        catch (KinesisVideoException e) {
            log.exception(e);
        }
    }

    @Override
    public void initialize(@NonNull KinesisVideoProducer kinesisVideoProducer) {
        Preconditions.checkState(!this.isInitialized(), "Service callback object has already been initialized");
        this.kinesisVideoProducer = Preconditions.checkNotNull(kinesisVideoProducer);
    }

    @Override
    public boolean isInitialized() {
        return this.kinesisVideoProducer != null;
    }

    @Override
    public void createStream(final @NonNull String deviceName, final @NonNull String streamName, final @NonNull String contentType, final @Nullable String kmsKeyId, final long retentionPeriod, long callAfter, final long timeout, final @Nullable byte[] authData, int authType, final long customData) throws ProducerException {
        Preconditions.checkState(this.isInitialized(), "Service callbacks object should be initialized first");
        long delay = this.calculateRelativeServiceCallAfter(callAfter);
        Runnable task = new Runnable(){

            @Override
            public void run() {
                int statusCode;
                String streamArn = null;
                KinesisVideoCredentialsProvider credentialsProvider = DefaultServiceCallbacksImpl.getCredentialsProvider(authData, DefaultServiceCallbacksImpl.this.log);
                long retentionInHours = retentionPeriod / 36000000000L;
                long timeoutInMillis = timeout / 10000L;
                try {
                    streamArn = DefaultServiceCallbacksImpl.this.kinesisVideoServiceClient.createStream(streamName, deviceName, contentType, kmsKeyId, retentionInHours, timeoutInMillis, credentialsProvider);
                    statusCode = 200;
                }
                catch (KinesisVideoException e) {
                    statusCode = DefaultServiceCallbacksImpl.getStatusCodeFromException(e);
                    DefaultServiceCallbacksImpl.this.log.error("Kinesis Video service client returned an error " + e.getMessage() + ". Reporting to Kinesis Video PIC.");
                }
                try {
                    DefaultServiceCallbacksImpl.this.kinesisVideoProducer.createStreamResult(customData, streamArn, statusCode);
                }
                catch (ProducerException e) {
                    throw new RuntimeException(e);
                }
            }
        };
        this.executor.schedule(task, delay, TimeUnit.NANOSECONDS);
    }

    @Override
    public void describeStream(final @NonNull String streamName, long callAfter, final long timeout, final @Nullable byte[] authData, int authType, final long customData) throws ProducerException {
        Preconditions.checkState(this.isInitialized(), "Service callbacks object should be initialized first");
        long delay = this.calculateRelativeServiceCallAfter(callAfter);
        Runnable task = new Runnable(){

            @Override
            public void run() {
                int statusCode;
                StreamDescription streamDescription = null;
                KinesisVideoCredentialsProvider credentialsProvider = DefaultServiceCallbacksImpl.getCredentialsProvider(authData, DefaultServiceCallbacksImpl.this.log);
                long timeoutInMillis = timeout / 10000L;
                try {
                    streamDescription = DefaultServiceCallbacksImpl.this.kinesisVideoServiceClient.describeStream(streamName, timeoutInMillis, credentialsProvider);
                    statusCode = 200;
                }
                catch (KinesisVideoException e) {
                    statusCode = DefaultServiceCallbacksImpl.getStatusCodeFromException(e);
                    DefaultServiceCallbacksImpl.this.log.error("Kinesis Video service client returned an error " + e.getMessage() + ". Reporting to Kinesis Video PIC.");
                }
                try {
                    DefaultServiceCallbacksImpl.this.kinesisVideoProducer.describeStreamResult(customData, streamDescription, statusCode);
                }
                catch (ProducerException e) {
                    throw new RuntimeException(e);
                }
            }
        };
        this.executor.schedule(task, delay, TimeUnit.NANOSECONDS);
    }

    @Override
    public void getStreamingEndpoint(final @NonNull String streamName, final @NonNull String apiName, long callAfter, final long timeout, final @Nullable byte[] authData, int authType, final long customData) throws ProducerException {
        Preconditions.checkState(this.isInitialized(), "Service callbacks object should be initialized first");
        long delay = this.calculateRelativeServiceCallAfter(callAfter);
        Runnable task = new Runnable(){

            @Override
            public void run() {
                KinesisVideoCredentialsProvider credentialsProvider = DefaultServiceCallbacksImpl.getCredentialsProvider(authData, DefaultServiceCallbacksImpl.this.log);
                long timeoutInMillis = timeout / 10000L;
                int statusCode = 200;
                String endpoint = "";
                try {
                    endpoint = DefaultServiceCallbacksImpl.this.kinesisVideoServiceClient.getDataEndpoint(streamName, apiName, timeoutInMillis, credentialsProvider);
                }
                catch (KinesisVideoException e) {
                    DefaultServiceCallbacksImpl.this.log.error("Kinesis Video service client returned an error " + e.getMessage() + ". Reporting to Kinesis Video PIC.");
                    statusCode = DefaultServiceCallbacksImpl.getStatusCodeFromException(e);
                }
                if (statusCode != 200 && DefaultServiceCallbacksImpl.isBlank(endpoint)) {
                    statusCode = 404;
                }
                try {
                    DefaultServiceCallbacksImpl.this.kinesisVideoProducer.getStreamingEndpointResult(customData, endpoint, statusCode);
                }
                catch (ProducerException e) {
                    throw new RuntimeException(e);
                }
            }
        };
        this.executor.schedule(task, delay, TimeUnit.NANOSECONDS);
    }

    @Override
    public void getStreamingToken(@NonNull String streamName, long callAfter, long timeout, @Nullable byte[] authData, int authType, final long customData) throws ProducerException {
        Preconditions.checkState(this.isInitialized(), "Service callbacks object should be initialized first");
        long delay = this.calculateRelativeServiceCallAfter(callAfter);
        Runnable task = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                KinesisVideoCredentialsProvider credentialsProvider = DefaultServiceCallbacksImpl.this.configuration.getCredentialsProvider();
                byte[] serializedCredentials = null;
                long expiration = 0L;
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                try {
                    KinesisVideoCredentials credentials = credentialsProvider.getUpdatedCredentials();
                    expiration = credentials.getExpiration().getTime() * 10000L;
                    ObjectOutputStream outputStream = new ObjectOutputStream(byteArrayOutputStream);
                    outputStream.writeObject(credentials);
                    outputStream.flush();
                    serializedCredentials = byteArrayOutputStream.toByteArray();
                    outputStream.close();
                }
                catch (IOException e) {
                    DefaultServiceCallbacksImpl.this.log.exception(e);
                }
                catch (KinesisVideoException e) {
                    DefaultServiceCallbacksImpl.this.log.exception(e);
                }
                finally {
                    try {
                        byteArrayOutputStream.close();
                    }
                    catch (IOException e) {}
                }
                int statusCode = 200;
                try {
                    DefaultServiceCallbacksImpl.this.kinesisVideoProducer.getStreamingTokenResult(customData, serializedCredentials, expiration, 200);
                }
                catch (ProducerException e) {
                    throw new RuntimeException(e);
                }
            }
        };
        this.executor.schedule(task, delay, TimeUnit.NANOSECONDS);
    }

    @Override
    public void putStream(final @NonNull String streamName, final @NonNull String containerType, final long streamStartTime, final boolean absoluteFragmentTimes, final boolean ackRequired, final @NonNull String dataEndpoint, long callAfter, final long timeout, final @Nullable byte[] authData, int authType, final long customData) throws ProducerException {
        Preconditions.checkState(this.isInitialized(), "Service callbacks object should be initialized first");
        long delay = this.calculateRelativeServiceCallAfter(callAfter);
        Runnable task = new Runnable(){

            @Override
            public void run() {
                KinesisVideoProducerStream kinesisVideoProducerStream = null;
                for (StreamingInfo streamingInfo : DefaultServiceCallbacksImpl.this.mStreams) {
                    if (streamingInfo.getStream().getStreamHandle() != customData) continue;
                    kinesisVideoProducerStream = streamingInfo.getStream();
                    break;
                }
                if (kinesisVideoProducerStream == null) {
                    throw new IllegalStateException("Couldn't find the correct stream");
                }
                long timeoutInMillis = timeout / 10000L;
                long streamStartTimeInMillis = streamStartTime / 10000L;
                int statusCode = 200;
                KinesisVideoCredentialsProvider credentialsProvider = DefaultServiceCallbacksImpl.getCredentialsProvider(authData, DefaultServiceCallbacksImpl.this.log);
                long clientUploadHandle = DefaultServiceCallbacksImpl.this.getUploadHandle();
                try {
                    InputStream dataStream = kinesisVideoProducerStream.getDataStream(clientUploadHandle);
                    AckConsumer ackConsumer = new AckConsumer(clientUploadHandle, kinesisVideoProducerStream, DefaultServiceCallbacksImpl.this.log);
                    BlockingAckConsumer blockingAckConsumer = new BlockingAckConsumer(ackConsumer, DefaultServiceCallbacksImpl.this.log, kinesisVideoProducerStream);
                    CompletionCallback completionCallback = new CompletionCallback(kinesisVideoProducerStream, clientUploadHandle);
                    DefaultServiceCallbacksImpl.this.kinesisVideoServiceClient.putMedia(streamName, containerType, streamStartTimeInMillis, absoluteFragmentTimes, ackRequired, dataEndpoint, timeoutInMillis, credentialsProvider, dataStream, blockingAckConsumer, completionCallback);
                    blockingAckConsumer.awaitResponse();
                }
                catch (KinesisVideoException e) {
                    statusCode = DefaultServiceCallbacksImpl.getStatusCodeFromException(e);
                    DefaultServiceCallbacksImpl.this.log.error("Kinesis Video service client returned an error " + e.getMessage() + ". Reporting to Kinesis Video PIC.");
                }
                try {
                    DefaultServiceCallbacksImpl.this.log.info("putStreamResult uploadHandle " + clientUploadHandle + " status " + statusCode);
                    DefaultServiceCallbacksImpl.this.kinesisVideoProducer.putStreamResult(customData, clientUploadHandle, statusCode);
                }
                catch (ProducerException e) {
                    throw new RuntimeException(e);
                }
            }
        };
        this.executor.schedule(task, delay, TimeUnit.NANOSECONDS);
    }

    @Override
    public void tagResource(final @NonNull String resourceArn, final @Nullable Tag[] tags, long callAfter, final long timeout, final @Nullable byte[] authData, int authType, final long customData) throws ProducerException {
        Preconditions.checkState(this.isInitialized(), "Service callbacks object should be initialized first");
        long delay = this.calculateRelativeServiceCallAfter(callAfter);
        Runnable task = new Runnable(){

            @Override
            public void run() {
                KinesisVideoCredentialsProvider credentialsProvider = DefaultServiceCallbacksImpl.getCredentialsProvider(authData, DefaultServiceCallbacksImpl.this.log);
                long timeoutInMillis = timeout / 10000L;
                int statusCode = 200;
                HashMap<String, String> tagsMap = null;
                if (null != tags) {
                    tagsMap = new HashMap<String, String>(tags.length);
                    for (Tag tag : tags) {
                        tagsMap.put(tag.getName(), tag.getValue());
                    }
                }
                try {
                    DefaultServiceCallbacksImpl.this.kinesisVideoServiceClient.tagStream(resourceArn, tagsMap, timeoutInMillis, credentialsProvider);
                }
                catch (KinesisVideoException e) {
                    DefaultServiceCallbacksImpl.this.log.error("Kinesis Video service client returned an error " + e.getMessage() + ". Reporting to Kinesis Video PIC.");
                    statusCode = DefaultServiceCallbacksImpl.getStatusCodeFromException(e);
                }
                if (statusCode != 200) {
                    statusCode = 400;
                }
                try {
                    DefaultServiceCallbacksImpl.this.kinesisVideoProducer.tagResourceResult(customData, statusCode);
                }
                catch (ProducerException e) {
                    throw new RuntimeException(e);
                }
            }
        };
        this.executor.schedule(task, delay, TimeUnit.NANOSECONDS);
    }

    @Override
    public void createDevice(final @NonNull String deviceName, long callAfter, long timeout, @Nullable byte[] authData, int authType, final long customData) throws ProducerException {
        Preconditions.checkState(this.isInitialized(), "Service callbacks object should be initialized first");
        long delay = this.calculateRelativeServiceCallAfter(callAfter);
        Runnable task = new Runnable(){

            @Override
            public void run() {
                int statusCode = 200;
                try {
                    String deviceArn = deviceName + "_ARN";
                    DefaultServiceCallbacksImpl.this.kinesisVideoProducer.createDeviceResult(customData, deviceArn, 200);
                }
                catch (ProducerException e) {
                    throw new RuntimeException(e);
                }
            }
        };
        this.executor.schedule(task, delay, TimeUnit.NANOSECONDS);
    }

    @Override
    public void deviceCertToToken(@NonNull String deviceName, long callAfter, long timeout, @Nullable byte[] authData, int authType, long customData) throws ProducerException {
        Preconditions.checkState(this.isInitialized(), "Service callbacks object should be initialized first");
        this.kinesisVideoProducer.deviceCertToTokenResult(customData, null, 0L, 400);
    }

    @Override
    public synchronized void free() {
        for (StreamingInfo streamingInfo : this.mStreams) {
            streamingInfo.stop();
        }
        this.mStreams.clear();
        this.executor.shutdownNow();
    }

    @Override
    public synchronized void addStream(@NonNull KinesisVideoProducerStream kinesisVideoProducerStream) {
        this.mStreams.add(new StreamingInfo(kinesisVideoProducerStream));
    }

    @Override
    public synchronized void removeStream(@NonNull KinesisVideoProducerStream kinesisVideoProducerStream) {
        StreamingInfo streamingInfoToBeRemoved = null;
        for (StreamingInfo streamingInfo : this.mStreams) {
            if (streamingInfo.getStream() != kinesisVideoProducerStream) continue;
            streamingInfoToBeRemoved = streamingInfo;
            break;
        }
        if (streamingInfoToBeRemoved != null) {
            this.mStreams.remove(streamingInfoToBeRemoved);
        }
    }

    private long calculateRelativeServiceCallAfter(long absoluteCallAfter) {
        return Math.max(0L, absoluteCallAfter * 100L - System.currentTimeMillis() * 1000000L);
    }

    private long getUploadHandle() {
        return this.uploadHandle++;
    }

    private static boolean isBlank(CharSequence cs) {
        int strLen;
        if (cs == null || (strLen = cs.length()) == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(cs.charAt(i))) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static KinesisVideoCredentialsProvider getCredentialsProvider(@Nullable byte[] authData, @NonNull Log log) {
        if (null == authData) {
            log.warn("NULL credentials have been returned by the credentials provider.");
            return null;
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(authData);
        KinesisVideoCredentials credentials = null;
        try {
            ObjectInputStream objectInput = new ObjectInputStream(byteArrayInputStream);
            credentials = (KinesisVideoCredentials)objectInput.readObject();
            objectInput.close();
        }
        catch (IOException e) {
            log.exception(e);
            KinesisVideoCredentialsProvider kinesisVideoCredentialsProvider = null;
            return kinesisVideoCredentialsProvider;
        }
        catch (ClassNotFoundException e) {
            log.exception(e);
            KinesisVideoCredentialsProvider kinesisVideoCredentialsProvider = null;
            return kinesisVideoCredentialsProvider;
        }
        finally {
            try {
                byteArrayInputStream.close();
            }
            catch (IOException e) {
                log.exception(e);
            }
        }
        return new StaticCredentialsProvider(credentials);
    }

    private static int getStatusCodeFromException(@Nullable Throwable e) {
        if (e == null) {
            return 200;
        }
        if (e.getClass().getName().endsWith(RESOURCE_NOT_FOUND)) {
            return 404;
        }
        if (e.getClass().getName().endsWith(RESOURCE_IN_USE)) {
            return 10003;
        }
        if (e.getClass().getName().endsWith(ACCESS_DENIED)) {
            return 403;
        }
        Throwable cause = e.getCause();
        if (cause != null) {
            return DefaultServiceCallbacksImpl.getStatusCodeFromException(cause);
        }
        return 400;
    }

    private class StreamingInfo {
        private final KinesisVideoProducerStream stream;

        public StreamingInfo(KinesisVideoProducerStream stream) {
            this.stream = Preconditions.checkNotNull(stream);
        }

        public void stop() {
            try {
                DefaultServiceCallbacksImpl.this.log.debug("Stopping the kinesis video producer stream");
                this.stream.stopStreamSync();
            }
            catch (ProducerException e) {
                DefaultServiceCallbacksImpl.this.log.exception(e, "Stopping stream threw an exception.", new Object[0]);
            }
        }

        public KinesisVideoProducerStream getStream() {
            return this.stream;
        }
    }

    private class CompletionCallback
    implements Consumer<Exception> {
        private final KinesisVideoProducerStream stream;
        private final long uploadHandle;

        public CompletionCallback(KinesisVideoProducerStream stream, long uploadHandle) {
            this.stream = Preconditions.checkNotNull(stream);
            this.uploadHandle = uploadHandle;
        }

        @Override
        public void accept(@Nullable Exception object) {
            int statusCode;
            long streamHandle = this.stream.getStreamHandle();
            if (streamHandle != 0L && (statusCode = DefaultServiceCallbacksImpl.getStatusCodeFromException(object)) != 200) {
                try {
                    this.stream.streamTerminated(this.uploadHandle, statusCode);
                }
                catch (ProducerException e) {
                    DefaultServiceCallbacksImpl.this.log.exception(e, "Reporting stream termination threw an exception", new Object[0]);
                }
            }
        }
    }
}

