/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.kinesisvideo.internal.service;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.amazonaws.kinesisvideo.common.function.Consumer;
import com.amazonaws.kinesisvideo.common.logging.Log;
import com.amazonaws.kinesisvideo.common.preconditions.Preconditions;
import com.amazonaws.kinesisvideo.internal.producer.KinesisVideoProducerStream;
import com.amazonaws.kinesisvideo.producer.ProducerException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

class AckConsumer
implements Consumer<InputStream> {
    private static final long STOPPED_TIMEOUT_IN_MILLISECONDS = 15000L;
    private static final int FOUR_KB = 4096;
    private static final String END_OF_STREAM_MSG = "0";
    private final KinesisVideoProducerStream stream;
    private InputStream ackStream = null;
    private final CountDownLatch stoppedLatch;
    private final Log log;
    private final long uploadHandle;
    private volatile boolean closed = false;

    public AckConsumer(long uploadHandle, @NonNull KinesisVideoProducerStream stream, @NonNull Log log) {
        this.stream = Preconditions.checkNotNull(stream);
        this.uploadHandle = uploadHandle;
        this.log = Preconditions.checkNotNull(log);
        this.stoppedLatch = new CountDownLatch(1);
    }

    @Override
    public void accept(@NonNull InputStream inputStream) {
        this.ackStream = Preconditions.checkNotNull(inputStream);
        this.processAckInputStream();
    }

    @Nullable
    public InputStream getAckStream() {
        return this.ackStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processAckInputStream() {
        Preconditions.checkNotNull(this.stream);
        byte[] buffer = new byte[4096];
        this.log.info("Starting ACK processing");
        try {
            while (!this.closed) {
                int bytesRead = this.ackStream.read(buffer);
                String bytesString = null;
                if (bytesRead > 0) {
                    bytesString = new String(buffer, 0, bytesRead, StandardCharsets.UTF_8);
                }
                if (bytesRead == -1 || END_OF_STREAM_MSG.equals(bytesString)) {
                    this.log.debug("Received end-of-stream for ACKs.");
                    this.closed = true;
                    continue;
                }
                if (bytesRead == 0) continue;
                this.log.debug("Received ACK bits: " + bytesString);
                try {
                    this.stream.parseFragmentAck(this.uploadHandle, bytesString);
                }
                catch (ProducerException e) {
                    this.log.exception(e, "Processing ACK threw an exception. Logging and continuing. ", new Object[0]);
                }
            }
            this.log.debug("Finished reading ACKs stream");
            return;
        }
        catch (IOException e) {
            this.log.exception(e);
            return;
        }
        finally {
            this.stoppedLatch.countDown();
        }
    }

    public void close() throws ProducerException {
        this.closed = true;
        try {
            if (this.ackStream != null) {
                this.ackStream.close();
            }
        }
        catch (IOException e) {
            throw new ProducerException(e);
        }
        try {
            if (!this.stoppedLatch.await(15000L, TimeUnit.MILLISECONDS)) {
                throw new ProducerException("ACK stream stopping time out", 0);
            }
        }
        catch (InterruptedException e) {
            throw new ProducerException(e);
        }
    }
}

