/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.kinesisvideo.internal.producer.jni;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.amazonaws.kinesisvideo.common.logging.Log;
import com.amazonaws.kinesisvideo.common.logging.LogLevel;
import com.amazonaws.kinesisvideo.common.preconditions.Preconditions;
import com.amazonaws.kinesisvideo.internal.producer.KinesisVideoMetrics;
import com.amazonaws.kinesisvideo.internal.producer.KinesisVideoProducer;
import com.amazonaws.kinesisvideo.internal.producer.KinesisVideoProducerStream;
import com.amazonaws.kinesisvideo.internal.producer.KinesisVideoStreamMetrics;
import com.amazonaws.kinesisvideo.internal.producer.ReadResult;
import com.amazonaws.kinesisvideo.internal.producer.ServiceCallbacks;
import com.amazonaws.kinesisvideo.internal.producer.jni.NativeKinesisVideoProducerStream;
import com.amazonaws.kinesisvideo.internal.producer.jni.NativeLibraryLoader;
import com.amazonaws.kinesisvideo.producer.AuthCallbacks;
import com.amazonaws.kinesisvideo.producer.AuthInfo;
import com.amazonaws.kinesisvideo.producer.DeviceInfo;
import com.amazonaws.kinesisvideo.producer.KinesisVideoFragmentAck;
import com.amazonaws.kinesisvideo.producer.KinesisVideoFrame;
import com.amazonaws.kinesisvideo.producer.ProducerException;
import com.amazonaws.kinesisvideo.producer.StorageCallbacks;
import com.amazonaws.kinesisvideo.producer.StreamCallbacks;
import com.amazonaws.kinesisvideo.producer.StreamDescription;
import com.amazonaws.kinesisvideo.producer.StreamInfo;
import com.amazonaws.kinesisvideo.producer.Tag;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class NativeKinesisVideoProducerJni
implements KinesisVideoProducer {
    public static final long INVALID_CLIENT_HANDLE_VALUE = 0L;
    public static final long INVALID_STREAM_HANDLE_VALUE = 0L;
    private static final String PRODUCER_NATIVE_LIBRARY_NAME = "KinesisVideoProducerJNI";
    private static final String EXPECTED_LIBRARY_VERSION = "1.8";
    private long mClientHandle = 0L;
    private boolean mLibraryInitialized = false;
    private volatile boolean mIsReady = false;
    private final Object mSyncObject = new Object();
    private final Object mCallbackSyncObject = new Object();
    private final Map<Long, KinesisVideoProducerStream> mKinesisVideoHandleMap = new HashMap<Long, KinesisVideoProducerStream>();
    private final AuthCallbacks mAuthCallbacks;
    private final StorageCallbacks mStorageCallbacks;
    private final ServiceCallbacks mServiceCallbacks;
    private final Log mLog;
    private final NativeLibraryLoader mLibraryLoader;
    private final CountDownLatch mReadyLatch;
    private final KinesisVideoMetrics mKinesisVideoMetrics;

    public NativeKinesisVideoProducerJni(@NonNull AuthCallbacks authCallbacks, @NonNull StorageCallbacks storageCallbacks, @NonNull ServiceCallbacks serviceCallbacks) throws ProducerException {
        this(authCallbacks, storageCallbacks, serviceCallbacks, new Log(Log.SYSTEM_OUT, LogLevel.VERBOSE, "Producer JNI"));
    }

    public NativeKinesisVideoProducerJni(@NonNull AuthCallbacks authCallbacks, @NonNull StorageCallbacks storageCallbacks, @NonNull ServiceCallbacks serviceCallbacks, @NonNull Log log) throws ProducerException {
        this(authCallbacks, storageCallbacks, serviceCallbacks, log, new CountDownLatch(1));
    }

    public NativeKinesisVideoProducerJni(@NonNull AuthCallbacks authCallbacks, @NonNull StorageCallbacks storageCallbacks, @NonNull ServiceCallbacks serviceCallbacks, @NonNull Log log, @NonNull CountDownLatch readyLatch) throws ProducerException {
        this.mLog = Preconditions.checkNotNull(log);
        this.mAuthCallbacks = Preconditions.checkNotNull(authCallbacks);
        this.mStorageCallbacks = Preconditions.checkNotNull(storageCallbacks);
        this.mServiceCallbacks = Preconditions.checkNotNull(serviceCallbacks);
        this.mReadyLatch = Preconditions.checkNotNull(readyLatch);
        this.mLibraryLoader = new NativeLibraryLoader(this.mLog);
        this.mServiceCallbacks.initialize(this);
        this.mKinesisVideoMetrics = new KinesisVideoMetrics();
    }

    protected void finalize() throws Throwable {
        if (this.isInitialized()) {
            this.free();
        }
    }

    @Override
    public void create(@NonNull DeviceInfo deviceInfo) throws ProducerException {
        this.create(deviceInfo, "");
    }

    @Override
    public void createSync(@NonNull DeviceInfo deviceInfo) throws ProducerException {
        this.createSync(deviceInfo, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void create(@NonNull DeviceInfo deviceInfo, @NonNull String nativeLibraryPath) throws ProducerException {
        Preconditions.checkNotNull(deviceInfo);
        Preconditions.checkState(!this.isInitialized());
        Object object = this.mSyncObject;
        synchronized (object) {
            if (!this.mLibraryInitialized) {
                this.initializeLibrary(nativeLibraryPath);
                this.mLibraryInitialized = true;
            }
            this.mClientHandle = this.createKinesisVideoClient(deviceInfo);
        }
    }

    public void createSync(@NonNull DeviceInfo deviceInfo, @NonNull String nativeLibraryPath) throws ProducerException {
        this.create(deviceInfo, nativeLibraryPath);
        try {
            if (!this.mReadyLatch.await(5000L, TimeUnit.MILLISECONDS)) {
                throw new ProducerException("Kinesis Video producer creation time out", 0);
            }
        }
        catch (InterruptedException ex) {
            throw new ProducerException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isInitialized() {
        Object object = this.mSyncObject;
        synchronized (object) {
            return this.mClientHandle != 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isReady() {
        Object object = this.mSyncObject;
        synchronized (object) {
            return this.mIsReady;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NonNull
    public KinesisVideoMetrics getMetrics() throws ProducerException {
        Preconditions.checkState(this.isInitialized());
        Object object = this.mSyncObject;
        synchronized (object) {
            this.getKinesisVideoMetrics(this.mClientHandle, this.mKinesisVideoMetrics);
            return this.mKinesisVideoMetrics;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void free() throws ProducerException {
        Preconditions.checkState(this.isInitialized());
        Object object = this.mSyncObject;
        synchronized (object) {
            this.freeKinesisVideoClient(this.mClientHandle);
            this.mClientHandle = 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public KinesisVideoProducerStream createStream(@NonNull StreamInfo streamInfo, @Nullable StreamCallbacks streamCallbacks) throws ProducerException {
        Preconditions.checkNotNull(streamInfo);
        Preconditions.checkState(this.isInitialized());
        Object object = this.mSyncObject;
        synchronized (object) {
            long streamHandle = this.createKinesisVideoStream(this.mClientHandle, streamInfo);
            NativeKinesisVideoProducerStream kinesisVideoProducerStream = new NativeKinesisVideoProducerStream(this, streamInfo, streamHandle, this.mLog, streamCallbacks);
            this.mKinesisVideoHandleMap.put(streamHandle, kinesisVideoProducerStream);
            return kinesisVideoProducerStream;
        }
    }

    @Override
    public KinesisVideoProducerStream createStreamSync(@NonNull StreamInfo streamInfo, @Nullable StreamCallbacks streamCallbacks) throws ProducerException {
        NativeKinesisVideoProducerStream stream = (NativeKinesisVideoProducerStream)this.createStream(streamInfo, streamCallbacks);
        stream.awaitReady();
        return stream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopStreams() throws ProducerException {
        if (!this.isInitialized()) {
            return;
        }
        Object object = this.mSyncObject;
        synchronized (object) {
            this.stopKinesisVideoStreams(this.mClientHandle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopStream(long streamHandle) throws ProducerException {
        if (!this.isInitialized()) {
            return;
        }
        Object object = this.mSyncObject;
        synchronized (object) {
            this.stopKinesisVideoStream(this.mClientHandle, streamHandle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void freeStreams() throws ProducerException {
        Preconditions.checkState(this.isInitialized());
        Object object = this.mSyncObject;
        synchronized (object) {
            Collection<KinesisVideoProducerStream> streamCollection = this.mKinesisVideoHandleMap.values();
            for (KinesisVideoProducerStream stream : streamCollection) {
                this.mKinesisVideoHandleMap.remove(stream.getStreamHandle());
                this.freeStream(stream);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void freeStream(@NonNull KinesisVideoProducerStream stream) throws ProducerException {
        Preconditions.checkNotNull(stream);
        if (!this.isInitialized()) {
            return;
        }
        Object object = this.mSyncObject;
        synchronized (object) {
            this.freeKinesisVideoStream(this.mClientHandle, stream.getStreamHandle());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void streamTerminated(long streamHandle, long uploadHandle, int statusCode) throws ProducerException {
        if (!this.isInitialized()) {
            return;
        }
        Object object = this.mSyncObject;
        synchronized (object) {
            this.kinesisVideoStreamTerminated(this.mClientHandle, streamHandle, uploadHandle, statusCode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getStreamMetrics(long streamHandle, @NonNull KinesisVideoStreamMetrics streamMetrics) throws ProducerException {
        Preconditions.checkState(this.isInitialized());
        Object object = this.mSyncObject;
        synchronized (object) {
            this.getKinesisVideoStreamMetrics(this.mClientHandle, streamHandle, streamMetrics);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putFrame(long streamHandle, @NonNull KinesisVideoFrame kinesisVideoFrameFrame) throws ProducerException {
        Preconditions.checkState(this.isInitialized());
        Preconditions.checkNotNull(kinesisVideoFrameFrame);
        Object object = this.mSyncObject;
        synchronized (object) {
            this.putKinesisVideoFrame(this.mClientHandle, streamHandle, kinesisVideoFrameFrame);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putFragmentMetadata(long streamHandle, @NonNull String metadataName, @NonNull String metadataValue, boolean persistent) throws ProducerException {
        Preconditions.checkState(this.isInitialized());
        Preconditions.checkNotNull(metadataName);
        Preconditions.checkNotNull(metadataValue);
        Object object = this.mSyncObject;
        synchronized (object) {
            this.putKinesisVideoFragmentMetadata(this.mClientHandle, streamHandle, metadataName, metadataValue, persistent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fragmentAck(long streamHandle, long uploadHandle, @NonNull KinesisVideoFragmentAck kinesisVideoFragmentAck) throws ProducerException {
        Preconditions.checkState(this.isInitialized());
        Preconditions.checkNotNull(kinesisVideoFragmentAck);
        Object object = this.mSyncObject;
        synchronized (object) {
            this.kinesisVideoStreamFragmentAck(this.mClientHandle, streamHandle, uploadHandle, kinesisVideoFragmentAck);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parseFragmentAck(long streamHandle, long uploadHandle, @NonNull String kinesisVideoFragmentAck) throws ProducerException {
        Preconditions.checkState(this.isInitialized());
        Preconditions.checkNotNull(kinesisVideoFragmentAck);
        Object object = this.mSyncObject;
        synchronized (object) {
            this.kinesisVideoStreamParseFragmentAck(this.mClientHandle, streamHandle, uploadHandle, kinesisVideoFragmentAck);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getStreamData(long streamHandle, @NonNull byte[] fillBuffer, int offset, int length, @NonNull ReadResult readResult) throws ProducerException {
        Preconditions.checkState(this.isInitialized());
        Preconditions.checkNotNull(fillBuffer);
        Preconditions.checkNotNull(readResult);
        Object object = this.mSyncObject;
        synchronized (object) {
            this.getKinesisVideoStreamData(this.mClientHandle, streamHandle, fillBuffer, offset, length, readResult);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void streamFormatChanged(long streamHandle, @Nullable byte[] codecPrivateData) throws ProducerException {
        Preconditions.checkState(this.isInitialized());
        Object object = this.mSyncObject;
        synchronized (object) {
            this.kinesisVideoStreamFormatChanged(this.mClientHandle, streamHandle, codecPrivateData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private AuthInfo getDeviceCertificate() {
        Object object = this.mCallbackSyncObject;
        synchronized (object) {
            return this.mAuthCallbacks.getDeviceCertificate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private AuthInfo getSecurityToken() {
        Object object = this.mCallbackSyncObject;
        synchronized (object) {
            return this.mAuthCallbacks.getSecurityToken();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private String getDeviceFingerprint() {
        Object object = this.mCallbackSyncObject;
        synchronized (object) {
            return this.mAuthCallbacks.getDeviceFingerprint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void streamUnderflowReport(long streamHandle) throws ProducerException {
        Object object = this.mCallbackSyncObject;
        synchronized (object) {
            if (!this.mKinesisVideoHandleMap.containsKey(streamHandle)) {
                throw new ProducerException("Invalid stream handle.", 13);
            }
            KinesisVideoProducerStream kinesisVideoProducerStream = this.mKinesisVideoHandleMap.get(streamHandle);
            kinesisVideoProducerStream.streamUnderflowReport();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storageOverflowPressure(long remainingSize) {
        Object object = this.mCallbackSyncObject;
        synchronized (object) {
            this.mStorageCallbacks.storageOverflowPressure(remainingSize);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void streamLatencyPressure(long streamHandle, long duration) throws ProducerException {
        Object object = this.mCallbackSyncObject;
        synchronized (object) {
            if (!this.mKinesisVideoHandleMap.containsKey(streamHandle)) {
                throw new ProducerException("Invalid stream handle.", 13);
            }
            KinesisVideoProducerStream kinesisVideoProducerStream = this.mKinesisVideoHandleMap.get(streamHandle);
            kinesisVideoProducerStream.streamLatencyPressure(duration);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void streamConnectionStale(long streamHandle, long lastAckDuration) throws ProducerException {
        Object object = this.mCallbackSyncObject;
        synchronized (object) {
            if (!this.mKinesisVideoHandleMap.containsKey(streamHandle)) {
                throw new ProducerException("Invalid stream handle.", 13);
            }
            KinesisVideoProducerStream kinesisVideoProducerStream = this.mKinesisVideoHandleMap.get(streamHandle);
            kinesisVideoProducerStream.streamConnectionStale(lastAckDuration);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fragmentAckReceived(long streamHandle, @NonNull KinesisVideoFragmentAck fragmentAck) throws ProducerException {
        Object object = this.mCallbackSyncObject;
        synchronized (object) {
            if (!this.mKinesisVideoHandleMap.containsKey(streamHandle)) {
                throw new ProducerException("Invalid stream handle.", 13);
            }
            KinesisVideoProducerStream kinesisVideoProducerStream = this.mKinesisVideoHandleMap.get(streamHandle);
            kinesisVideoProducerStream.fragmentAckReceived(fragmentAck);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void droppedFrameReport(long streamHandle, long frameTimecode) throws ProducerException {
        Object object = this.mCallbackSyncObject;
        synchronized (object) {
            if (!this.mKinesisVideoHandleMap.containsKey(streamHandle)) {
                throw new ProducerException("Invalid stream handle.", 13);
            }
            KinesisVideoProducerStream kinesisVideoProducerStream = this.mKinesisVideoHandleMap.get(streamHandle);
            kinesisVideoProducerStream.droppedFrameReport(frameTimecode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void droppedFragmentReport(long streamHandle, long fragmentTimecode) throws ProducerException {
        Object object = this.mCallbackSyncObject;
        synchronized (object) {
            if (!this.mKinesisVideoHandleMap.containsKey(streamHandle)) {
                throw new ProducerException("Invalid stream handle.", 13);
            }
            KinesisVideoProducerStream kinesisVideoProducerStream = this.mKinesisVideoHandleMap.get(streamHandle);
            kinesisVideoProducerStream.droppedFragmentReport(fragmentTimecode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void streamErrorReport(long streamHandle, long fragmentTimecode, long statusCode) throws ProducerException {
        Object object = this.mCallbackSyncObject;
        synchronized (object) {
            if (!this.mKinesisVideoHandleMap.containsKey(streamHandle)) {
                throw new ProducerException("Invalid stream handle.", 13);
            }
            KinesisVideoProducerStream kinesisVideoProducerStream = this.mKinesisVideoHandleMap.get(streamHandle);
            kinesisVideoProducerStream.streamErrorReport(fragmentTimecode, statusCode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void streamDataAvailable(long streamHandle, String streamName, long uploadHandle, long duration, long availableSize) throws ProducerException {
        Object object = this.mCallbackSyncObject;
        synchronized (object) {
            if (!this.mKinesisVideoHandleMap.containsKey(streamHandle)) {
                throw new ProducerException("Invalid stream handle.", 13);
            }
            KinesisVideoProducerStream kinesisVideoProducerStream = this.mKinesisVideoHandleMap.get(streamHandle);
            kinesisVideoProducerStream.streamDataAvailable(uploadHandle, duration, availableSize);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void streamReady(long streamHandle) throws ProducerException {
        Object object = this.mCallbackSyncObject;
        synchronized (object) {
            Object object2 = this.mSyncObject;
            synchronized (object2) {
                if (!this.mKinesisVideoHandleMap.containsKey(streamHandle)) {
                    throw new ProducerException("Invalid stream handle.", 13);
                }
                KinesisVideoProducerStream kinesisVideoProducerStream = this.mKinesisVideoHandleMap.get(streamHandle);
                kinesisVideoProducerStream.streamReady();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void streamClosed(long streamHandle, long uploadHandle) throws ProducerException {
        Object object = this.mCallbackSyncObject;
        synchronized (object) {
            if (!this.mKinesisVideoHandleMap.containsKey(streamHandle)) {
                throw new ProducerException("Invalid stream handle.", 13);
            }
            KinesisVideoProducerStream kinesisVideoProducerStream = this.mKinesisVideoHandleMap.get(streamHandle);
            kinesisVideoProducerStream.streamClosed(uploadHandle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clientReady(long clientHandle) throws ProducerException {
        Object object = this.mCallbackSyncObject;
        synchronized (object) {
            if (this.mClientHandle != clientHandle) {
                throw new ProducerException("Invalid client handle.", 13);
            }
            this.mIsReady = true;
            this.mReadyLatch.countDown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int createStream(@NonNull String deviceName, @NonNull String streamName, @NonNull String contentType, @Nullable String kmsKeyId, long retentionPeriod, long callAfter, long timeout, @Nullable byte[] authData, int authType, long customData) throws ProducerException {
        Object object = this.mCallbackSyncObject;
        synchronized (object) {
            try {
                this.mServiceCallbacks.createStream(deviceName, streamName, contentType, kmsKeyId, retentionPeriod, callAfter, timeout, authData, authType, customData);
                return 0;
            }
            catch (ProducerException e) {
                return e.getStatusCode();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createStreamResult(long customData, @Nullable String streamArn, int httpStatusCode) throws ProducerException {
        Object object = this.mSyncObject;
        synchronized (object) {
            this.createStreamResultEvent(this.mClientHandle, customData, httpStatusCode, streamArn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int describeStream(@NonNull String streamName, long callAfter, long timeout, byte[] authData, int authType, long customData) throws ProducerException {
        Object object = this.mCallbackSyncObject;
        synchronized (object) {
            try {
                this.mServiceCallbacks.describeStream(streamName, callAfter, timeout, authData, authType, customData);
                return 0;
            }
            catch (ProducerException e) {
                return e.getStatusCode();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void describeStreamResult(long customData, @Nullable StreamDescription streamDescription, int httpStatusCode) throws ProducerException {
        Object object = this.mSyncObject;
        synchronized (object) {
            this.describeStreamResultEvent(this.mClientHandle, customData, httpStatusCode, streamDescription);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getStreamingEndpoint(@NonNull String streamName, @NonNull String apiName, long callAfter, long timeout, @Nullable byte[] authData, int authType, long customData) throws ProducerException {
        Object object = this.mCallbackSyncObject;
        synchronized (object) {
            try {
                this.mServiceCallbacks.getStreamingEndpoint(streamName, apiName, callAfter, timeout, authData, authType, customData);
                return 0;
            }
            catch (ProducerException e) {
                return e.getStatusCode();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getStreamingEndpointResult(long customData, @Nullable String endpoint, int httpStatusCode) throws ProducerException {
        Object object = this.mSyncObject;
        synchronized (object) {
            this.getStreamingEndpointResultEvent(this.mClientHandle, customData, httpStatusCode, endpoint);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getStreamingToken(@NonNull String streamName, long callAfter, long timeout, @Nullable byte[] authData, int authType, long customData) throws ProducerException {
        Object object = this.mCallbackSyncObject;
        synchronized (object) {
            try {
                this.mServiceCallbacks.getStreamingToken(streamName, callAfter, timeout, authData, authType, customData);
                return 0;
            }
            catch (ProducerException e) {
                return e.getStatusCode();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getStreamingTokenResult(long customData, @Nullable byte[] token, long expiration, int httpStatusCode) throws ProducerException {
        Object object = this.mSyncObject;
        synchronized (object) {
            int tokenSize = token == null ? 0 : token.length;
            this.getStreamingTokenResultEvent(this.mClientHandle, customData, httpStatusCode, token, tokenSize, expiration);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int putStream(@NonNull String streamName, @NonNull String containerType, long streamStartTime, boolean absoluteFragmentTimes, boolean ackRequired, @NonNull String streamingEndpoint, long callAfter, long timeout, @Nullable byte[] authData, int authType, long customData) throws ProducerException {
        Object object = this.mCallbackSyncObject;
        synchronized (object) {
            try {
                this.mServiceCallbacks.putStream(streamName, containerType, streamStartTime, absoluteFragmentTimes, ackRequired, streamingEndpoint, callAfter, timeout, authData, authType, customData);
                return 0;
            }
            catch (ProducerException e) {
                return e.getStatusCode();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putStreamResult(long customData, long clientStreamHandle, int httpStatusCode) throws ProducerException {
        Object object = this.mSyncObject;
        synchronized (object) {
            this.putStreamResultEvent(this.mClientHandle, customData, httpStatusCode, clientStreamHandle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int tagResource(@NonNull String resourceArn, @NonNull Tag[] tags, long callAfter, long timeout, @Nullable byte[] authData, int authType, long customData) throws ProducerException {
        Object object = this.mCallbackSyncObject;
        synchronized (object) {
            try {
                this.mServiceCallbacks.tagResource(resourceArn, tags, callAfter, timeout, authData, authType, customData);
                return 0;
            }
            catch (ProducerException e) {
                return e.getStatusCode();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void tagResourceResult(long customData, int httpStatusCode) throws ProducerException {
        Object object = this.mSyncObject;
        synchronized (object) {
            this.tagResourceResultEvent(this.mClientHandle, customData, httpStatusCode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int createDevice(@NonNull String deviceName, long callAfter, long timeout, @Nullable byte[] authData, int authType, long customData) throws ProducerException {
        Object object = this.mCallbackSyncObject;
        synchronized (object) {
            try {
                this.mServiceCallbacks.createDevice(deviceName, callAfter, timeout, authData, authType, customData);
                return 0;
            }
            catch (ProducerException e) {
                return e.getStatusCode();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createDeviceResult(long customData, @Nullable String deviceArm, int httpStatusCode) throws ProducerException {
        Object object = this.mSyncObject;
        synchronized (object) {
            this.createDeviceResultEvent(this.mClientHandle, customData, httpStatusCode, deviceArm);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int deviceCertToToken(@NonNull String deviceName, long callAfter, long timeout, @Nullable byte[] authData, int authType, long customData) throws ProducerException {
        Object object = this.mCallbackSyncObject;
        synchronized (object) {
            try {
                this.mServiceCallbacks.deviceCertToToken(deviceName, callAfter, timeout, authData, authType, customData);
                return 0;
            }
            catch (ProducerException e) {
                return e.getStatusCode();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deviceCertToTokenResult(long customData, @Nullable byte[] token, long expiration, int httpStatusCode) throws ProducerException {
        Object object = this.mSyncObject;
        synchronized (object) {
            int tokenSize = token == null ? 0 : token.length;
            this.deviceCertToTokenResultEvent(this.mClientHandle, customData, httpStatusCode, token, tokenSize, expiration);
        }
    }

    private void initializeLibrary(@NonNull String nativeLibraryPath) throws ProducerException {
        if (!this.mLibraryLoader.loadNativeLibrary(nativeLibraryPath, PRODUCER_NATIVE_LIBRARY_NAME)) {
            throw new ProducerException("Failed loading native library", 13);
        }
        String libraryVersion = this.getNativeLibraryVersion();
        String compileTime = this.getNativeCodeCompileTime();
        this.mLog.verbose("%s library: version %s, compile time %s", PRODUCER_NATIVE_LIBRARY_NAME, libraryVersion, compileTime);
        Preconditions.checkState(libraryVersion.equals(EXPECTED_LIBRARY_VERSION), String.format("FATAL DEPLOYMENT ERROR: This app is built to run with version %s of the lib%s.so library, but version %s was found on this device", EXPECTED_LIBRARY_VERSION, PRODUCER_NATIVE_LIBRARY_NAME, libraryVersion));
    }

    private native String getNativeLibraryVersion();

    private native String getNativeCodeCompileTime();

    private native long createKinesisVideoClient(@NonNull DeviceInfo var1) throws ProducerException;

    private native void freeKinesisVideoClient(long var1) throws ProducerException;

    private native void stopKinesisVideoStreams(long var1) throws ProducerException;

    private native void stopKinesisVideoStream(long var1, long var3) throws ProducerException;

    private native void freeKinesisVideoStream(long var1, long var3) throws ProducerException;

    private native long createKinesisVideoStream(long var1, @NonNull StreamInfo var3) throws ProducerException;

    private native void putKinesisVideoFrame(long var1, long var3, @NonNull KinesisVideoFrame var5) throws ProducerException;

    private native void putKinesisVideoFragmentMetadata(long var1, long var3, @NonNull String var5, @NonNull String var6, boolean var7) throws ProducerException;

    private native void kinesisVideoStreamFragmentAck(long var1, long var3, long var5, @NonNull KinesisVideoFragmentAck var7) throws ProducerException;

    private native void kinesisVideoStreamParseFragmentAck(long var1, long var3, long var5, @NonNull String var7) throws ProducerException;

    private native void getKinesisVideoMetrics(long var1, @NonNull KinesisVideoMetrics var3) throws ProducerException;

    private native void getKinesisVideoStreamMetrics(long var1, long var3, @NonNull KinesisVideoStreamMetrics var5) throws ProducerException;

    private native void describeStreamResultEvent(long var1, long var3, int var5, @Nullable StreamDescription var6) throws ProducerException;

    private native void getStreamingEndpointResultEvent(long var1, long var3, int var5, @Nullable String var6) throws ProducerException;

    private native void getStreamingTokenResultEvent(long var1, long var3, int var5, @Nullable byte[] var6, int var7, long var8) throws ProducerException;

    private native void putStreamResultEvent(long var1, long var3, int var5, long var6) throws ProducerException;

    private native void tagResourceResultEvent(long var1, long var3, int var5) throws ProducerException;

    private native void createStreamResultEvent(long var1, long var3, int var5, @Nullable String var6) throws ProducerException;

    private native void getKinesisVideoStreamData(long var1, long var3, @NonNull byte[] var5, int var6, int var7, @NonNull ReadResult var8) throws ProducerException;

    private native void kinesisVideoStreamFormatChanged(long var1, long var3, @Nullable byte[] var5) throws ProducerException;

    private native void createDeviceResultEvent(long var1, long var3, int var5, @Nullable String var6) throws ProducerException;

    private native void deviceCertToTokenResultEvent(long var1, long var3, int var5, @Nullable byte[] var6, int var7, long var8) throws ProducerException;

    private native void kinesisVideoStreamTerminated(long var1, long var3, long var5, int var7) throws ProducerException;
}

