/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.kinesisvideo.internal.mediasource.bytes;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.amazonaws.kinesisvideo.client.mediasource.MediaSourceState;
import com.amazonaws.kinesisvideo.common.exception.KinesisVideoException;
import com.amazonaws.kinesisvideo.common.preconditions.Preconditions;
import com.amazonaws.kinesisvideo.internal.client.mediasource.MediaSource;
import com.amazonaws.kinesisvideo.internal.client.mediasource.MediaSourceConfiguration;
import com.amazonaws.kinesisvideo.internal.client.mediasource.MediaSourceSink;
import com.amazonaws.kinesisvideo.internal.mediasource.OnStreamDataAvailable;
import com.amazonaws.kinesisvideo.internal.mediasource.bytes.BytesGenerator;
import com.amazonaws.kinesisvideo.internal.mediasource.bytes.BytesMediaSourceConfiguration;
import com.amazonaws.kinesisvideo.producer.KinesisVideoFrame;
import com.amazonaws.kinesisvideo.producer.StreamCallbacks;
import com.amazonaws.kinesisvideo.producer.StreamInfo;
import com.amazonaws.kinesisvideo.producer.Tag;
import com.amazonaws.kinesisvideo.util.StreamInfoConstants;
import java.nio.ByteBuffer;

public class BytesMediaSource
implements MediaSource {
    private static final String TAG = "BytesMediaSource";
    private static final int KEY_FRAME_EVERY_60_FRAMES = 60;
    private static final long DEFAULT_FRAME_DURATION_33MS = 33L;
    private final String streamName;
    private BytesMediaSourceConfiguration configuration;
    private MediaSourceState mediaSourceState;
    private MediaSourceSink mediaSourceSink;
    private BytesGenerator bytesGenerator;
    private int frameIndex;
    private long lastTimestampMillis;

    public BytesMediaSource(@NonNull String streamName) {
        this.streamName = streamName;
    }

    @Override
    public MediaSourceState getMediaSourceState() {
        return this.mediaSourceState;
    }

    @Override
    public MediaSourceConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    public StreamInfo getStreamInfo() {
        return new StreamInfo(0, this.streamName, StreamInfo.StreamingType.STREAMING_TYPE_REALTIME, "application/octet-stream", StreamInfoConstants.NO_KMS_KEY_ID, this.configuration.getRetentionPeriodInHours() * 36000000000L, false, 0L, 200000000000L, true, true, true, true, true, null, null, 2000000, 30, 400000000L, 200000000L, 200000000L, 10000L, true, null, new Tag[]{new Tag("device", "Test Device"), new Tag("stream", "Test Stream")}, StreamInfo.NalAdaptationFlags.NAL_ADAPTATION_FLAG_NONE);
    }

    @Override
    public void initialize(@NonNull MediaSourceSink mediaSourceSink) throws KinesisVideoException {
        this.mediaSourceSink = mediaSourceSink;
    }

    @Override
    public void configure(MediaSourceConfiguration configuration) {
        Preconditions.checkState(this.configuration == null);
        if (!(configuration instanceof BytesMediaSourceConfiguration)) {
            throw new IllegalArgumentException("can only use BytesMediaSourceConfiguration");
        }
        this.configuration = (BytesMediaSourceConfiguration)configuration;
    }

    @Override
    public void start() throws KinesisVideoException {
        this.mediaSourceState = MediaSourceState.RUNNING;
        this.bytesGenerator = new BytesGenerator(this.configuration.getFps());
        this.bytesGenerator.onStreamDataAvailable(this.createDataAvailableCallback());
        this.bytesGenerator.start();
    }

    private OnStreamDataAvailable createDataAvailableCallback() {
        return new OnStreamDataAvailable(){

            @Override
            public void onFrameDataAvailable(ByteBuffer data) {
                long currentTimeMs = System.currentTimeMillis();
                long decodingTs = currentTimeMs * 10000L;
                long presentationTs = currentTimeMs * 10000L;
                long msSinceLastFrame = currentTimeMs - BytesMediaSource.this.lastTimestampMillis;
                long frameDuration = BytesMediaSource.this.lastTimestampMillis == 0L ? 330000L : msSinceLastFrame * 10000L / 2L;
                int flags = BytesMediaSource.this.isKeyFrame() ? 1 : 0;
                KinesisVideoFrame frame = new KinesisVideoFrame(BytesMediaSource.this.frameIndex++, flags, decodingTs, presentationTs, frameDuration, data);
                if (frame.getSize() == 0 || frameDuration == 0L) {
                    return;
                }
                BytesMediaSource.this.lastTimestampMillis = currentTimeMs;
                BytesMediaSource.this.submitFrameOnUIThread(frame);
            }

            @Override
            public void onFragmentMetadataAvailable(String metadataName, String metadataValue, boolean persistent) {
                try {
                    BytesMediaSource.this.mediaSourceSink.onFragmentMetadata(metadataName, metadataValue, persistent);
                }
                catch (KinesisVideoException kinesisVideoException) {
                    // empty catch block
                }
            }
        };
    }

    private boolean isKeyFrame() {
        return this.frameIndex % 60 == 0;
    }

    private void submitFrameOnUIThread(KinesisVideoFrame frame) {
        try {
            this.mediaSourceSink.onFrame(frame);
        }
        catch (KinesisVideoException kinesisVideoException) {
            // empty catch block
        }
    }

    @Override
    public void stop() throws KinesisVideoException {
        if (this.bytesGenerator != null) {
            this.bytesGenerator.stop();
        }
        this.mediaSourceState = MediaSourceState.STOPPED;
    }

    @Override
    public boolean isStopped() {
        return this.mediaSourceState == MediaSourceState.STOPPED;
    }

    @Override
    public void free() throws KinesisVideoException {
    }

    @Override
    public MediaSourceSink getMediaSourceSink() {
        return this.mediaSourceSink;
    }

    @Override
    @Nullable
    public StreamCallbacks getStreamCallbacks() {
        return null;
    }
}

