/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.kinesisvideo.internal.client;

import android.support.annotation.NonNull;
import com.amazonaws.kinesisvideo.client.KinesisVideoClient;
import com.amazonaws.kinesisvideo.common.exception.KinesisVideoException;
import com.amazonaws.kinesisvideo.common.logging.Log;
import com.amazonaws.kinesisvideo.common.preconditions.Preconditions;
import com.amazonaws.kinesisvideo.internal.client.mediasource.MediaSource;
import com.amazonaws.kinesisvideo.producer.DeviceInfo;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractKinesisVideoClient
implements KinesisVideoClient {
    protected final List<MediaSource> mMediaSources = new ArrayList<MediaSource>();
    protected boolean mIsInitialized = false;
    protected final Log mLog;

    public AbstractKinesisVideoClient(@NonNull Log log) {
        this.mLog = Preconditions.checkNotNull(log);
    }

    @Override
    public boolean isInitialized() {
        return this.mIsInitialized;
    }

    @Override
    public void initialize(@NonNull DeviceInfo deviceInfo) throws KinesisVideoException {
        this.mLog.info("Initializing Kinesis Video client");
        Preconditions.checkState(!this.mIsInitialized, "Already initialized");
        this.mIsInitialized = true;
    }

    @Override
    public void startAllMediaSources() throws KinesisVideoException {
        this.mLog.verbose("Resuming Kinesis Video client");
        Preconditions.checkState(this.isInitialized(), "Must initialize first.");
        for (MediaSource mediaSource : this.mMediaSources) {
            mediaSource.start();
        }
    }

    @Override
    public void stopAllMediaSources() throws KinesisVideoException {
        this.mLog.verbose("Pausing Kinesis Video client");
        if (!this.isInitialized()) {
            return;
        }
        for (MediaSource mediaSource : this.mMediaSources) {
            mediaSource.stop();
        }
    }

    @Override
    public void free() throws KinesisVideoException {
        this.mLog.verbose("Releasing Kinesis Video client");
        if (!this.isInitialized()) {
            return;
        }
        for (MediaSource mediaSource : this.mMediaSources) {
            if (!mediaSource.isStopped()) {
                mediaSource.stop();
            }
            mediaSource.free();
        }
        this.mMediaSources.clear();
    }

    @Override
    public void registerMediaSource(@NonNull MediaSource mediaSource) throws KinesisVideoException {
        this.mMediaSources.add(mediaSource);
    }

    @Override
    public void unregisterMediaSource(@NonNull MediaSource mediaSource) throws KinesisVideoException {
        this.mMediaSources.remove(mediaSource);
    }
}

