/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.kinesisvideo.common.logging;

public enum LogLevel {
    VERBOSE(2),
    DEBUG(3),
    INFO(4),
    WARN(5),
    ERROR(6),
    ASSERT(7);

    private static final LogLevel[] LOG_LEVELS;
    private final int mLogLevel;

    public static LogLevel fromInt(int logLevel) {
        if (logLevel < 0 || logLevel >= LOG_LEVELS.length) {
            return VERBOSE;
        }
        return LOG_LEVELS[logLevel];
    }

    private LogLevel(int logLevel) {
        this.mLogLevel = logLevel;
    }

    public int getLogLevel() {
        return this.mLogLevel;
    }

    static {
        LOG_LEVELS = new LogLevel[]{VERBOSE, VERBOSE, VERBOSE, DEBUG, INFO, WARN, ERROR, ASSERT};
    }
}

