/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.kinesisvideo.client;

import com.amazonaws.kinesisvideo.http.HttpMethodName;
import com.amazonaws.kinesisvideo.http.KinesisVideoApacheHttpClient;
import com.amazonaws.kinesisvideo.signing.KinesisVideoSigner;
import java.net.URI;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.entity.ContentType;

public class StreamingReadClient {
    private static final String CONTENT_TYPE_HEADER_KEY = "Content-Type";
    private URI mUri;
    private KinesisVideoSigner mSigner;
    private String mInputInJson;
    private Integer mConnectionTimeoutInMillis;
    private Integer mReadTimeoutInMillis;

    StreamingReadClient(StreamingReadClientBuilder builder) {
        this.mUri = builder.mUri;
        this.mSigner = builder.mSigner;
        this.mInputInJson = builder.mInputInJson;
        this.mConnectionTimeoutInMillis = builder.mConnectionTimeoutInMillis;
        this.mReadTimeoutInMillis = builder.mReadTimeoutInMillis;
    }

    public static StreamingReadClientBuilder builder() {
        return new StreamingReadClientBuilder();
    }

    public CloseableHttpResponse execute() {
        KinesisVideoApacheHttpClient client = this.getHttpClient();
        return client.executeRequest();
    }

    private KinesisVideoApacheHttpClient getHttpClient() {
        KinesisVideoApacheHttpClient.Builder clientBuilder = KinesisVideoApacheHttpClient.builder().withUri(this.mUri).withContentType(ContentType.APPLICATION_JSON).withMethod(HttpMethodName.POST).withContentInJson(this.mInputInJson).withHeader(CONTENT_TYPE_HEADER_KEY, ContentType.APPLICATION_JSON.getMimeType());
        if (this.mConnectionTimeoutInMillis != null) {
            clientBuilder = clientBuilder.withConnectionTimeoutInMillis(this.mConnectionTimeoutInMillis);
        }
        if (this.mReadTimeoutInMillis != null) {
            clientBuilder = clientBuilder.withSocketTimeoutInMillis(this.mReadTimeoutInMillis);
        }
        KinesisVideoApacheHttpClient client = clientBuilder.build();
        this.mSigner.sign(client);
        return client;
    }

    public URI getUri() {
        return this.mUri;
    }

    public void setUri(URI uri) {
        this.mUri = uri;
    }

    public KinesisVideoSigner getSigner() {
        return this.mSigner;
    }

    public void setSigner(KinesisVideoSigner signer) {
        this.mSigner = signer;
    }

    public String getInputInJson() {
        return this.mInputInJson;
    }

    public void setInputInJson(String inputInJson) {
        this.mInputInJson = inputInJson;
    }

    public Integer getConnectionTimeoutInMillis() {
        return this.mConnectionTimeoutInMillis;
    }

    public void setConnectionTimeoutInMillis(Integer connectionTimeoutInMillis) {
        this.mConnectionTimeoutInMillis = connectionTimeoutInMillis;
    }

    public Integer getReadTimeoutInMillis() {
        return this.mReadTimeoutInMillis;
    }

    public void setReadTimeoutInMillis(Integer readTimeoutInMillis) {
        this.mReadTimeoutInMillis = readTimeoutInMillis;
    }

    public static class StreamingReadClientBuilder {
        private URI mUri;
        private KinesisVideoSigner mSigner;
        private String mInputInJson;
        private Integer mConnectionTimeoutInMillis;
        private Integer mReadTimeoutInMillis;

        StreamingReadClientBuilder() {
        }

        public StreamingReadClientBuilder uri(URI uri) {
            this.mUri = uri;
            return this;
        }

        public StreamingReadClientBuilder signer(KinesisVideoSigner signer) {
            this.mSigner = signer;
            return this;
        }

        public StreamingReadClientBuilder inputInJson(String inputInJson) {
            this.mInputInJson = inputInJson;
            return this;
        }

        public StreamingReadClientBuilder connectionTimeoutInMillis(Integer connectionTimeoutInMillis) {
            this.mConnectionTimeoutInMillis = connectionTimeoutInMillis;
            return this;
        }

        public StreamingReadClientBuilder readTimeoutInMillis(Integer readTimeoutInMillis) {
            this.mReadTimeoutInMillis = readTimeoutInMillis;
            return this;
        }

        public StreamingReadClient build() {
            return new StreamingReadClient(this);
        }
    }
}

