/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.kinesisvideo.client;

import com.amazonaws.kinesisvideo.common.function.Consumer;
import com.amazonaws.kinesisvideo.common.logging.Log;
import com.amazonaws.kinesisvideo.common.preconditions.Preconditions;
import com.amazonaws.kinesisvideo.encoding.ChunkEncoder;
import com.amazonaws.kinesisvideo.http.HttpMethodName;
import com.amazonaws.kinesisvideo.http.ParallelSimpleHttpClient;
import com.amazonaws.kinesisvideo.signing.KinesisVideoSigner;
import com.amazonaws.kinesisvideo.stream.throttling.BandwidthMeasuringOutputStream;
import com.amazonaws.kinesisvideo.stream.throttling.BandwidthThrottledOutputStream;
import com.amazonaws.kinesisvideo.stream.throttling.BandwidthThrottlerImpl;
import com.amazonaws.kinesisvideo.stream.throttling.OpsPerSecondMeasurer;
import com.amazonaws.kinesisvideo.util.VersionUtil;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public final class PutMediaClient {
    private static final double BYTES_IN_MB = 1048576.0;
    private static final long BITS_IN_A_KILOBIT = 1024L;
    private static final String STREAM_NAME_HEADER = "x-amzn-stream-name";
    private static final String FRAGMENT_TIME_CODE_TYPE_HEADER = "x-amzn-fragment-timecode-type";
    private static final String PRODUCER_START_TIMESTAMP_HEADER = "x-amzn-producer-start-timestamp";
    private static final String TRANSFER_ENCODING = "Transfer-Encoding";
    private static final String CHUNKED = "chunked";
    private static final String CONNECTION = "connection";
    private static final String KEEP_ALIVE = "keep-alive";
    private static final String USER_AGENT = "user-agent";
    private static final int BUFFER_SIZE = 0x100000;
    private static final double MILLI_TO_SEC = 1000.0;
    private static final int LOGGING_INTERVAL = 250;
    private final Builder mBuilder;
    private final Log log;
    private ParallelSimpleHttpClient httpClient;

    private PutMediaClient(Builder builder) {
        this.mBuilder = builder;
        this.log = this.mBuilder.mLog;
    }

    public static Builder builder() {
        return new Builder();
    }

    public void putMediaInBackground() {
        this.putMediaWithSender(this.sendChunkEncodedMvkStream(0));
    }

    public void putMediaInBackgroundWithSleep(int sleepTime) {
        this.putMediaWithSender(this.sendChunkEncodedMvkStream(sleepTime));
    }

    private void putMediaWithSender(Consumer<OutputStream> sender) {
        ParallelSimpleHttpClient.Builder clientBuilder = ParallelSimpleHttpClient.builder().uri(this.mBuilder.mUri).method(HttpMethodName.POST).log(this.log).header(STREAM_NAME_HEADER, this.mBuilder.mStreamName).header(TRANSFER_ENCODING, CHUNKED).header(CONNECTION, KEEP_ALIVE).header(USER_AGENT, VersionUtil.getUserAgent());
        clientBuilder.setReceiverCallback(this.mBuilder.mAcksReceiver);
        clientBuilder.header(PRODUCER_START_TIMESTAMP_HEADER, String.format(Locale.US, "%.3f", (double)this.mBuilder.mTimestamp / 1000.0));
        clientBuilder.header(FRAGMENT_TIME_CODE_TYPE_HEADER, this.mBuilder.mFragmentTimecodeType);
        clientBuilder.completionCallback(this.mBuilder.mCompletion);
        clientBuilder.setSenderCallback(sender);
        clientBuilder.setTimeout(this.mBuilder.mReceiveTimeout);
        this.httpClient = clientBuilder.build();
        this.sign(this.httpClient);
        if (this.mBuilder.unsignedHeaders != null) {
            for (String headerName : this.mBuilder.unsignedHeaders.keySet()) {
                clientBuilder.header(headerName, (String)this.mBuilder.unsignedHeaders.get(headerName));
            }
        }
        this.httpClient.connectAndProcessInBackground();
    }

    public void close() throws IOException {
        this.httpClient.close();
    }

    private void sign(ParallelSimpleHttpClient client) {
        if (this.mBuilder.mSigner != null) {
            this.mBuilder.mSigner.sign(client);
        }
    }

    private Consumer<OutputStream> sendChunkEncodedMvkStream(final int fragmentThrottle) {
        return new Consumer<OutputStream>(){

            @Override
            public void accept(OutputStream rawOutputStream) {
                FileOutputStream outputFileStream = null;
                try {
                    OutputStream throttledOutputStream = PutMediaClient.this.throttleAndMeasureOutput(rawOutputStream);
                    outputFileStream = PutMediaClient.this.createOutputFileStream();
                    byte[] buffer = new byte[0x100000];
                    long counter = 0L;
                    boolean continueLoop = true;
                    while (continueLoop) {
                        int mkvBytesRead = PutMediaClient.this.mBuilder.mMkvStream.read(buffer);
                        if (++counter % 250L == 0L) {
                            PutMediaClient.this.log.debug("Sending data, counter : " + counter);
                        }
                        if (mkvBytesRead == -1) {
                            PutMediaClient.this.log.info("End-of-stream is reported. Terminating...");
                            continueLoop = false;
                            continue;
                        }
                        throttledOutputStream.write(ChunkEncoder.encode(buffer, mkvBytesRead));
                        PutMediaClient.this.tryWriteToFile(outputFileStream, buffer, mkvBytesRead);
                        if (fragmentThrottle <= 0) continue;
                        Thread.sleep(fragmentThrottle);
                    }
                    throttledOutputStream.write(ChunkEncoder.encode(buffer, 0));
                    rawOutputStream.flush();
                    PutMediaClient.this.log.debug("Data sent. counter : " + counter);
                }
                catch (Exception e) {
                    try {
                        PutMediaClient.this.log.debug("Exception while sending data.", e);
                        throw new RuntimeException("Exception while sending encoded chunk in MKV stream ! ", e);
                    }
                    catch (Throwable throwable) {
                        PutMediaClient.this.tryCloseOutputFileStream(outputFileStream);
                        throw throwable;
                    }
                }
                PutMediaClient.this.tryCloseOutputFileStream(outputFileStream);
            }
        };
    }

    private OutputStream throttleAndMeasureOutput(OutputStream rawOutputStream) {
        OutputStream throttledOutputStream = this.throttleStream(rawOutputStream);
        return this.mBuilder.mLogUsedBandwidth ? this.logBytesPerSecond(throttledOutputStream) : throttledOutputStream;
    }

    private OutputStream throttleStream(OutputStream rawOutputStream) {
        if (this.mBuilder.upstreamKbps != null) {
            BandwidthThrottlerImpl throttler = new BandwidthThrottlerImpl(this.mBuilder.upstreamKbps * 1024L);
            return new BandwidthThrottledOutputStream(rawOutputStream, throttler);
        }
        return rawOutputStream;
    }

    private OutputStream logBytesPerSecond(OutputStream outputStream) {
        OpsPerSecondMeasurer bandwidthMeasurer = new OpsPerSecondMeasurer(this.logBytesPerSecond());
        return new BandwidthMeasuringOutputStream(outputStream, bandwidthMeasurer);
    }

    private Consumer<Long> logBytesPerSecond() {
        return new Consumer<Long>(){

            @Override
            public void accept(Long bytesWrittenPerSecond) {
                double megabitPerSecond = PutMediaClient.this.mbitPerSecond(bytesWrittenPerSecond);
                System.out.println(String.format("%n   ===> actual megabit/sec: %.2f mbps", megabitPerSecond));
            }
        };
    }

    private FileOutputStream createOutputFileStream() {
        try {
            return this.mBuilder.mFileOutputPath == null ? null : new FileOutputStream(this.mBuilder.mFileOutputPath);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("Unable to open the file " + this.mBuilder.mFileOutputPath, e);
        }
    }

    private void tryWriteToFile(FileOutputStream fileOutputStream, byte[] buffer, int bytesToWrite) {
        if (fileOutputStream == null) {
            return;
        }
        try {
            fileOutputStream.write(buffer, 0, bytesToWrite);
            fileOutputStream.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void tryCloseOutputFileStream(FileOutputStream outputFileStream) {
        if (outputFileStream == null) {
            return;
        }
        try {
            outputFileStream.close();
        }
        catch (IOException e) {
            this.log.error(e.getMessage());
        }
    }

    private double mbitPerSecond(long bps) {
        return (double)(bps * 8L) / 1048576.0;
    }

    public static class Builder {
        private URI mUri;
        private String mStreamName;
        private InputStream mMkvStream;
        private long mTimestamp;
        private Consumer<InputStream> mAcksReceiver;
        private KinesisVideoSigner mSigner;
        private String mFragmentTimecodeType;
        private Integer mReceiveTimeout;
        private boolean mLogUsedBandwidth;
        private String mFileOutputPath;
        private Long upstreamKbps;
        private Consumer<Exception> mCompletion;
        private Log mLog = new Log(Log.SYSTEM_OUT);
        private Map<String, String> unsignedHeaders;

        public Builder putMediaDestinationUri(URI uri) {
            this.mUri = uri;
            return this;
        }

        public Builder streamName(String streamName) {
            this.mStreamName = streamName;
            return this;
        }

        public Builder mkvStream(InputStream mkvStream) {
            this.mMkvStream = mkvStream;
            return this;
        }

        public Builder receiveAcks(Consumer<InputStream> acksReceiver) {
            this.mAcksReceiver = acksReceiver;
            return this;
        }

        public Builder receiveCompletion(Consumer<Exception> completion) {
            this.mCompletion = completion;
            return this;
        }

        public Builder timestamp(long timestamp) {
            this.mTimestamp = timestamp;
            return this;
        }

        public Builder signWith(KinesisVideoSigner signer) {
            this.mSigner = signer;
            return this;
        }

        public Builder fragmentTimecodeType(String fragmentTimecodeType) {
            this.mFragmentTimecodeType = fragmentTimecodeType;
            return this;
        }

        public Builder receiveTimeout(Integer timeout) {
            this.mReceiveTimeout = timeout;
            return this;
        }

        public Builder logUsedBandwidth(boolean logBandwidth) {
            this.mLogUsedBandwidth = logBandwidth;
            return this;
        }

        public Builder fileOutputPath(String fileOutputPath) {
            this.mFileOutputPath = fileOutputPath;
            return this;
        }

        public Builder upstreamKbps(long kbps) {
            this.upstreamKbps = kbps;
            return this;
        }

        public Builder log(Log log) {
            this.mLog = Preconditions.checkNotNull(log);
            return this;
        }

        public Builder unsignedHeader(String name, String value) {
            if (this.unsignedHeaders == null) {
                this.unsignedHeaders = new HashMap<String, String>();
            }
            this.unsignedHeaders.put(name, value);
            return this;
        }

        public PutMediaClient build() {
            Preconditions.checkNotNull(this.mUri);
            Preconditions.checkNotNull(this.mStreamName);
            Preconditions.checkNotNull(this.mMkvStream);
            Preconditions.checkNotNull(this.mAcksReceiver);
            return new PutMediaClient(this);
        }
    }
}

