/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.kinesisvideo.client;

import android.support.annotation.NonNull;
import com.amazonaws.kinesisvideo.http.HttpMethodName;
import com.amazonaws.kinesisvideo.http.KinesisVideoApacheHttpClient;
import com.amazonaws.kinesisvideo.signing.KinesisVideoSigner;
import java.net.URI;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.entity.ContentType;

public final class GetInletMediaClient {
    private static final String CONTENT_TYPE_HEADER_KEY = "Content-Type";
    private static final String X_AMZN_REQUEST_ID = "x-amzn-RequestId";
    private URI mUri;
    private KinesisVideoSigner mSigner;
    private String mGetInletMediaInputInJson;
    private Integer mConnectionTimeoutInMillis;
    private Integer mReadTimeoutInMillis;

    GetInletMediaClient(GetInletMediaClientBuilder builder) {
        this.mUri = builder.mUri;
        this.mSigner = builder.mSigner;
        this.mGetInletMediaInputInJson = builder.mGetInletMediaInputInJson;
        this.mConnectionTimeoutInMillis = builder.mConnectionTimeoutInMillis;
        this.mReadTimeoutInMillis = builder.mReadTimeoutInMillis;
    }

    public GetInletMediaClientBuilder builder() {
        return new GetInletMediaClientBuilder();
    }

    public CloseableHttpResponse execute(@NonNull String requestId) {
        KinesisVideoApacheHttpClient client = this.getHttpClient(requestId);
        return client.executeRequest();
    }

    private KinesisVideoApacheHttpClient getHttpClient(@NonNull String requestId) {
        KinesisVideoApacheHttpClient.Builder clientBuilder = KinesisVideoApacheHttpClient.builder().withUri(this.mUri).withContentType(ContentType.APPLICATION_JSON).withMethod(HttpMethodName.POST).withContentInJson(this.mGetInletMediaInputInJson).withHeader(CONTENT_TYPE_HEADER_KEY, ContentType.APPLICATION_JSON.getMimeType()).withHeader(X_AMZN_REQUEST_ID, requestId);
        if (this.mConnectionTimeoutInMillis != null) {
            clientBuilder = clientBuilder.withConnectionTimeoutInMillis(this.mConnectionTimeoutInMillis);
        }
        if (this.mReadTimeoutInMillis != null) {
            clientBuilder = clientBuilder.withSocketTimeoutInMillis(this.mReadTimeoutInMillis);
        }
        KinesisVideoApacheHttpClient client = clientBuilder.build();
        this.mSigner.sign(client);
        return client;
    }

    public URI getUri() {
        return this.mUri;
    }

    public void setUri(URI uri) {
        this.mUri = uri;
    }

    public KinesisVideoSigner getSigner() {
        return this.mSigner;
    }

    public void setSigner(KinesisVideoSigner signer) {
        this.mSigner = signer;
    }

    public String getGetInletMediaInputInJson() {
        return this.mGetInletMediaInputInJson;
    }

    public void setmGetInletMediaInputInJson(String getInletMediaInputInJson) {
        this.mGetInletMediaInputInJson = getInletMediaInputInJson;
    }

    public Integer getConnectionTimeoutInMillis() {
        return this.mConnectionTimeoutInMillis;
    }

    public void setConnectionTimeoutInMillis(Integer connectionTimeoutInMillis) {
        this.mConnectionTimeoutInMillis = connectionTimeoutInMillis;
    }

    public Integer getReadTimeoutInMillis() {
        return this.mReadTimeoutInMillis;
    }

    public void setReadTimeoutInMillis(Integer readTimeoutInMillis) {
        this.mReadTimeoutInMillis = readTimeoutInMillis;
    }

    public static class GetInletMediaClientBuilder {
        private URI mUri;
        private KinesisVideoSigner mSigner;
        private String mGetInletMediaInputInJson;
        private Integer mConnectionTimeoutInMillis;
        private Integer mReadTimeoutInMillis;

        GetInletMediaClientBuilder() {
        }

        public GetInletMediaClientBuilder uri(URI uri) {
            this.mUri = uri;
            return this;
        }

        public GetInletMediaClientBuilder signer(KinesisVideoSigner signer) {
            this.mSigner = signer;
            return this;
        }

        public GetInletMediaClientBuilder getInletMediaInputInJson(String getInletMediaInputInJson) {
            this.mGetInletMediaInputInJson = getInletMediaInputInJson;
            return this;
        }

        public GetInletMediaClientBuilder connectionTimeoutInMillis(Integer connectionTimeoutInMillis) {
            this.mConnectionTimeoutInMillis = connectionTimeoutInMillis;
            return this;
        }

        public GetInletMediaClientBuilder readTimeoutInMillis(Integer readTimeoutInMillis) {
            this.mReadTimeoutInMillis = readTimeoutInMillis;
            return this;
        }

        public GetInletMediaClient build() {
            return new GetInletMediaClient(this);
        }
    }
}

