/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.kinesisvideo.auth;

import com.amazonaws.kinesisvideo.auth.KinesisVideoCredentials;
import com.amazonaws.kinesisvideo.auth.KinesisVideoCredentialsProvider;
import com.amazonaws.kinesisvideo.common.exception.KinesisVideoException;

public abstract class AbstractKinesisVideoCredentialsProvider
implements KinesisVideoCredentialsProvider {
    private KinesisVideoCredentials credentials = null;
    private Object syncObj = new Object();

    protected AbstractKinesisVideoCredentialsProvider() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public KinesisVideoCredentials getCredentials() throws KinesisVideoException {
        Object object = this.syncObj;
        synchronized (object) {
            this.refreshCredentials(false);
            return this.credentials;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public KinesisVideoCredentials getUpdatedCredentials() throws KinesisVideoException {
        Object object = this.syncObj;
        synchronized (object) {
            this.refreshCredentials(true);
            return this.credentials;
        }
    }

    private void refreshCredentials(boolean forceUpdate) throws KinesisVideoException {
        long currentMillis = System.currentTimeMillis();
        if (null == this.credentials || forceUpdate || currentMillis <= this.credentials.getExpiration().getTime()) {
            this.credentials = this.updateCredentials();
        }
    }

    protected abstract KinesisVideoCredentials updateCredentials() throws KinesisVideoException;
}

