/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesis.model.transform;

import com.amazonaws.services.kinesis.model.EnhancedMetrics;
import com.amazonaws.services.kinesis.model.StreamDescriptionSummary;
import com.amazonaws.services.kinesis.model.transform.EnhancedMetricsJsonMarshaller;
import com.amazonaws.util.json.AwsJsonWriter;
import java.util.Date;
import java.util.List;

class StreamDescriptionSummaryJsonMarshaller {
    private static StreamDescriptionSummaryJsonMarshaller instance;

    StreamDescriptionSummaryJsonMarshaller() {
    }

    public void marshall(StreamDescriptionSummary streamDescriptionSummary, AwsJsonWriter jsonWriter) throws Exception {
        jsonWriter.beginObject();
        if (streamDescriptionSummary.getStreamName() != null) {
            String streamName = streamDescriptionSummary.getStreamName();
            jsonWriter.name("StreamName");
            jsonWriter.value(streamName);
        }
        if (streamDescriptionSummary.getStreamARN() != null) {
            String streamARN = streamDescriptionSummary.getStreamARN();
            jsonWriter.name("StreamARN");
            jsonWriter.value(streamARN);
        }
        if (streamDescriptionSummary.getStreamStatus() != null) {
            String streamStatus = streamDescriptionSummary.getStreamStatus();
            jsonWriter.name("StreamStatus");
            jsonWriter.value(streamStatus);
        }
        if (streamDescriptionSummary.getRetentionPeriodHours() != null) {
            Integer retentionPeriodHours = streamDescriptionSummary.getRetentionPeriodHours();
            jsonWriter.name("RetentionPeriodHours");
            jsonWriter.value((Number)retentionPeriodHours);
        }
        if (streamDescriptionSummary.getStreamCreationTimestamp() != null) {
            Date streamCreationTimestamp = streamDescriptionSummary.getStreamCreationTimestamp();
            jsonWriter.name("StreamCreationTimestamp");
            jsonWriter.value(streamCreationTimestamp);
        }
        if (streamDescriptionSummary.getEnhancedMonitoring() != null) {
            List<EnhancedMetrics> enhancedMonitoring = streamDescriptionSummary.getEnhancedMonitoring();
            jsonWriter.name("EnhancedMonitoring");
            jsonWriter.beginArray();
            for (EnhancedMetrics enhancedMonitoringItem : enhancedMonitoring) {
                if (enhancedMonitoringItem == null) continue;
                EnhancedMetricsJsonMarshaller.getInstance().marshall(enhancedMonitoringItem, jsonWriter);
            }
            jsonWriter.endArray();
        }
        if (streamDescriptionSummary.getEncryptionType() != null) {
            String encryptionType = streamDescriptionSummary.getEncryptionType();
            jsonWriter.name("EncryptionType");
            jsonWriter.value(encryptionType);
        }
        if (streamDescriptionSummary.getKeyId() != null) {
            String keyId = streamDescriptionSummary.getKeyId();
            jsonWriter.name("KeyId");
            jsonWriter.value(keyId);
        }
        if (streamDescriptionSummary.getOpenShardCount() != null) {
            Integer openShardCount = streamDescriptionSummary.getOpenShardCount();
            jsonWriter.name("OpenShardCount");
            jsonWriter.value((Number)openShardCount);
        }
        jsonWriter.endObject();
    }

    public static StreamDescriptionSummaryJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new StreamDescriptionSummaryJsonMarshaller();
        }
        return instance;
    }
}

