/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesis.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.kinesis.model.PutRecordsRequest;
import com.amazonaws.services.kinesis.model.PutRecordsRequestEntry;
import com.amazonaws.services.kinesis.model.transform.PutRecordsRequestEntryJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.AwsJsonWriter;
import com.amazonaws.util.json.JsonUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.List;
import java.util.zip.GZIPOutputStream;

public class PutRecordsRequestMarshaller
implements Marshaller<Request<PutRecordsRequest>, PutRecordsRequest> {
    public Request<PutRecordsRequest> marshall(PutRecordsRequest putRecordsRequest) {
        if (putRecordsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(PutRecordsRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)putRecordsRequest, "AmazonKinesis");
        String target = "Kinesis_20131202.PutRecords";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/";
        request.setResourcePath(uriResourcePath);
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            GZIPOutputStream gos = new GZIPOutputStream((OutputStream)baos, 8192);
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)gos, StringUtils.UTF8);
            AwsJsonWriter jsonWriter = JsonUtils.getJsonWriter((Writer)writer);
            jsonWriter.beginObject();
            if (putRecordsRequest.getRecords() != null) {
                List<PutRecordsRequestEntry> records = putRecordsRequest.getRecords();
                jsonWriter.name("Records");
                jsonWriter.beginArray();
                for (PutRecordsRequestEntry recordsItem : records) {
                    if (recordsItem == null) continue;
                    PutRecordsRequestEntryJsonMarshaller.getInstance().marshall(recordsItem, jsonWriter);
                }
                jsonWriter.endArray();
            }
            if (putRecordsRequest.getStreamName() != null) {
                String streamName = putRecordsRequest.getStreamName();
                jsonWriter.name("StreamName");
                jsonWriter.value(streamName);
            }
            jsonWriter.endObject();
            jsonWriter.flush();
            gos.finish();
            ((Writer)writer).close();
            byte[] content = baos.toByteArray();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Encoding", "gzip");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        return request;
    }
}

