/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesis.model;

import com.amazonaws.services.kinesis.model.EncryptionType;
import com.amazonaws.services.kinesis.model.EnhancedMetrics;
import com.amazonaws.services.kinesis.model.Shard;
import com.amazonaws.services.kinesis.model.StreamStatus;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class StreamDescription
implements Serializable {
    private String streamName;
    private String streamARN;
    private String streamStatus;
    private List<Shard> shards = new ArrayList<Shard>();
    private Boolean hasMoreShards;
    private Integer retentionPeriodHours;
    private Date streamCreationTimestamp;
    private List<EnhancedMetrics> enhancedMonitoring = new ArrayList<EnhancedMetrics>();
    private String encryptionType;
    private String keyId;

    public String getStreamName() {
        return this.streamName;
    }

    public void setStreamName(String streamName) {
        this.streamName = streamName;
    }

    public StreamDescription withStreamName(String streamName) {
        this.streamName = streamName;
        return this;
    }

    public String getStreamARN() {
        return this.streamARN;
    }

    public void setStreamARN(String streamARN) {
        this.streamARN = streamARN;
    }

    public StreamDescription withStreamARN(String streamARN) {
        this.streamARN = streamARN;
        return this;
    }

    public String getStreamStatus() {
        return this.streamStatus;
    }

    public void setStreamStatus(String streamStatus) {
        this.streamStatus = streamStatus;
    }

    public StreamDescription withStreamStatus(String streamStatus) {
        this.streamStatus = streamStatus;
        return this;
    }

    public void setStreamStatus(StreamStatus streamStatus) {
        this.streamStatus = streamStatus.toString();
    }

    public StreamDescription withStreamStatus(StreamStatus streamStatus) {
        this.streamStatus = streamStatus.toString();
        return this;
    }

    public List<Shard> getShards() {
        return this.shards;
    }

    public void setShards(Collection<Shard> shards) {
        if (shards == null) {
            this.shards = null;
            return;
        }
        this.shards = new ArrayList<Shard>(shards);
    }

    public StreamDescription withShards(Shard ... shards) {
        if (this.getShards() == null) {
            this.shards = new ArrayList<Shard>(shards.length);
        }
        for (Shard value : shards) {
            this.shards.add(value);
        }
        return this;
    }

    public StreamDescription withShards(Collection<Shard> shards) {
        this.setShards(shards);
        return this;
    }

    public Boolean isHasMoreShards() {
        return this.hasMoreShards;
    }

    public Boolean getHasMoreShards() {
        return this.hasMoreShards;
    }

    public void setHasMoreShards(Boolean hasMoreShards) {
        this.hasMoreShards = hasMoreShards;
    }

    public StreamDescription withHasMoreShards(Boolean hasMoreShards) {
        this.hasMoreShards = hasMoreShards;
        return this;
    }

    public Integer getRetentionPeriodHours() {
        return this.retentionPeriodHours;
    }

    public void setRetentionPeriodHours(Integer retentionPeriodHours) {
        this.retentionPeriodHours = retentionPeriodHours;
    }

    public StreamDescription withRetentionPeriodHours(Integer retentionPeriodHours) {
        this.retentionPeriodHours = retentionPeriodHours;
        return this;
    }

    public Date getStreamCreationTimestamp() {
        return this.streamCreationTimestamp;
    }

    public void setStreamCreationTimestamp(Date streamCreationTimestamp) {
        this.streamCreationTimestamp = streamCreationTimestamp;
    }

    public StreamDescription withStreamCreationTimestamp(Date streamCreationTimestamp) {
        this.streamCreationTimestamp = streamCreationTimestamp;
        return this;
    }

    public List<EnhancedMetrics> getEnhancedMonitoring() {
        return this.enhancedMonitoring;
    }

    public void setEnhancedMonitoring(Collection<EnhancedMetrics> enhancedMonitoring) {
        if (enhancedMonitoring == null) {
            this.enhancedMonitoring = null;
            return;
        }
        this.enhancedMonitoring = new ArrayList<EnhancedMetrics>(enhancedMonitoring);
    }

    public StreamDescription withEnhancedMonitoring(EnhancedMetrics ... enhancedMonitoring) {
        if (this.getEnhancedMonitoring() == null) {
            this.enhancedMonitoring = new ArrayList<EnhancedMetrics>(enhancedMonitoring.length);
        }
        for (EnhancedMetrics value : enhancedMonitoring) {
            this.enhancedMonitoring.add(value);
        }
        return this;
    }

    public StreamDescription withEnhancedMonitoring(Collection<EnhancedMetrics> enhancedMonitoring) {
        this.setEnhancedMonitoring(enhancedMonitoring);
        return this;
    }

    public String getEncryptionType() {
        return this.encryptionType;
    }

    public void setEncryptionType(String encryptionType) {
        this.encryptionType = encryptionType;
    }

    public StreamDescription withEncryptionType(String encryptionType) {
        this.encryptionType = encryptionType;
        return this;
    }

    public void setEncryptionType(EncryptionType encryptionType) {
        this.encryptionType = encryptionType.toString();
    }

    public StreamDescription withEncryptionType(EncryptionType encryptionType) {
        this.encryptionType = encryptionType.toString();
        return this;
    }

    public String getKeyId() {
        return this.keyId;
    }

    public void setKeyId(String keyId) {
        this.keyId = keyId;
    }

    public StreamDescription withKeyId(String keyId) {
        this.keyId = keyId;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getStreamName() != null) {
            sb.append("StreamName: " + this.getStreamName() + ",");
        }
        if (this.getStreamARN() != null) {
            sb.append("StreamARN: " + this.getStreamARN() + ",");
        }
        if (this.getStreamStatus() != null) {
            sb.append("StreamStatus: " + this.getStreamStatus() + ",");
        }
        if (this.getShards() != null) {
            sb.append("Shards: " + this.getShards() + ",");
        }
        if (this.getHasMoreShards() != null) {
            sb.append("HasMoreShards: " + this.getHasMoreShards() + ",");
        }
        if (this.getRetentionPeriodHours() != null) {
            sb.append("RetentionPeriodHours: " + this.getRetentionPeriodHours() + ",");
        }
        if (this.getStreamCreationTimestamp() != null) {
            sb.append("StreamCreationTimestamp: " + this.getStreamCreationTimestamp() + ",");
        }
        if (this.getEnhancedMonitoring() != null) {
            sb.append("EnhancedMonitoring: " + this.getEnhancedMonitoring() + ",");
        }
        if (this.getEncryptionType() != null) {
            sb.append("EncryptionType: " + this.getEncryptionType() + ",");
        }
        if (this.getKeyId() != null) {
            sb.append("KeyId: " + this.getKeyId());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getStreamName() == null ? 0 : this.getStreamName().hashCode());
        hashCode = 31 * hashCode + (this.getStreamARN() == null ? 0 : this.getStreamARN().hashCode());
        hashCode = 31 * hashCode + (this.getStreamStatus() == null ? 0 : this.getStreamStatus().hashCode());
        hashCode = 31 * hashCode + (this.getShards() == null ? 0 : this.getShards().hashCode());
        hashCode = 31 * hashCode + (this.getHasMoreShards() == null ? 0 : this.getHasMoreShards().hashCode());
        hashCode = 31 * hashCode + (this.getRetentionPeriodHours() == null ? 0 : this.getRetentionPeriodHours().hashCode());
        hashCode = 31 * hashCode + (this.getStreamCreationTimestamp() == null ? 0 : this.getStreamCreationTimestamp().hashCode());
        hashCode = 31 * hashCode + (this.getEnhancedMonitoring() == null ? 0 : this.getEnhancedMonitoring().hashCode());
        hashCode = 31 * hashCode + (this.getEncryptionType() == null ? 0 : this.getEncryptionType().hashCode());
        hashCode = 31 * hashCode + (this.getKeyId() == null ? 0 : this.getKeyId().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StreamDescription)) {
            return false;
        }
        StreamDescription other = (StreamDescription)obj;
        if (other.getStreamName() == null ^ this.getStreamName() == null) {
            return false;
        }
        if (other.getStreamName() != null && !other.getStreamName().equals(this.getStreamName())) {
            return false;
        }
        if (other.getStreamARN() == null ^ this.getStreamARN() == null) {
            return false;
        }
        if (other.getStreamARN() != null && !other.getStreamARN().equals(this.getStreamARN())) {
            return false;
        }
        if (other.getStreamStatus() == null ^ this.getStreamStatus() == null) {
            return false;
        }
        if (other.getStreamStatus() != null && !other.getStreamStatus().equals(this.getStreamStatus())) {
            return false;
        }
        if (other.getShards() == null ^ this.getShards() == null) {
            return false;
        }
        if (other.getShards() != null && !other.getShards().equals(this.getShards())) {
            return false;
        }
        if (other.getHasMoreShards() == null ^ this.getHasMoreShards() == null) {
            return false;
        }
        if (other.getHasMoreShards() != null && !other.getHasMoreShards().equals(this.getHasMoreShards())) {
            return false;
        }
        if (other.getRetentionPeriodHours() == null ^ this.getRetentionPeriodHours() == null) {
            return false;
        }
        if (other.getRetentionPeriodHours() != null && !other.getRetentionPeriodHours().equals(this.getRetentionPeriodHours())) {
            return false;
        }
        if (other.getStreamCreationTimestamp() == null ^ this.getStreamCreationTimestamp() == null) {
            return false;
        }
        if (other.getStreamCreationTimestamp() != null && !other.getStreamCreationTimestamp().equals(this.getStreamCreationTimestamp())) {
            return false;
        }
        if (other.getEnhancedMonitoring() == null ^ this.getEnhancedMonitoring() == null) {
            return false;
        }
        if (other.getEnhancedMonitoring() != null && !other.getEnhancedMonitoring().equals(this.getEnhancedMonitoring())) {
            return false;
        }
        if (other.getEncryptionType() == null ^ this.getEncryptionType() == null) {
            return false;
        }
        if (other.getEncryptionType() != null && !other.getEncryptionType().equals(this.getEncryptionType())) {
            return false;
        }
        if (other.getKeyId() == null ^ this.getKeyId() == null) {
            return false;
        }
        return other.getKeyId() == null || other.getKeyId().equals(this.getKeyId());
    }
}

