/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.dynamodbv2.model.GlobalTableGlobalSecondaryIndexSettingsUpdate;
import com.amazonaws.services.dynamodbv2.model.ReplicaSettingsUpdate;
import com.amazonaws.services.dynamodbv2.model.UpdateGlobalTableSettingsRequest;
import com.amazonaws.services.dynamodbv2.model.transform.GlobalTableGlobalSecondaryIndexSettingsUpdateJsonMarshaller;
import com.amazonaws.services.dynamodbv2.model.transform.ReplicaSettingsUpdateJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.AwsJsonWriter;
import com.amazonaws.util.json.JsonUtils;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;

public class UpdateGlobalTableSettingsRequestMarshaller
implements Marshaller<Request<UpdateGlobalTableSettingsRequest>, UpdateGlobalTableSettingsRequest> {
    public Request<UpdateGlobalTableSettingsRequest> marshall(UpdateGlobalTableSettingsRequest updateGlobalTableSettingsRequest) {
        if (updateGlobalTableSettingsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(UpdateGlobalTableSettingsRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)updateGlobalTableSettingsRequest, "AmazonDynamoDB");
        String target = "DynamoDB_20120810.UpdateGlobalTableSettings";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/";
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = new StringWriter();
            AwsJsonWriter jsonWriter = JsonUtils.getJsonWriter((Writer)stringWriter);
            jsonWriter.beginObject();
            if (updateGlobalTableSettingsRequest.getGlobalTableName() != null) {
                String globalTableName = updateGlobalTableSettingsRequest.getGlobalTableName();
                jsonWriter.name("GlobalTableName");
                jsonWriter.value(globalTableName);
            }
            if (updateGlobalTableSettingsRequest.getGlobalTableProvisionedWriteCapacityUnits() != null) {
                Long globalTableProvisionedWriteCapacityUnits = updateGlobalTableSettingsRequest.getGlobalTableProvisionedWriteCapacityUnits();
                jsonWriter.name("GlobalTableProvisionedWriteCapacityUnits");
                jsonWriter.value((Number)globalTableProvisionedWriteCapacityUnits);
            }
            if (updateGlobalTableSettingsRequest.getGlobalTableGlobalSecondaryIndexSettingsUpdate() != null) {
                List<GlobalTableGlobalSecondaryIndexSettingsUpdate> globalTableGlobalSecondaryIndexSettingsUpdate = updateGlobalTableSettingsRequest.getGlobalTableGlobalSecondaryIndexSettingsUpdate();
                jsonWriter.name("GlobalTableGlobalSecondaryIndexSettingsUpdate");
                jsonWriter.beginArray();
                for (GlobalTableGlobalSecondaryIndexSettingsUpdate globalTableGlobalSecondaryIndexSettingsUpdateItem : globalTableGlobalSecondaryIndexSettingsUpdate) {
                    if (globalTableGlobalSecondaryIndexSettingsUpdateItem == null) continue;
                    GlobalTableGlobalSecondaryIndexSettingsUpdateJsonMarshaller.getInstance().marshall(globalTableGlobalSecondaryIndexSettingsUpdateItem, jsonWriter);
                }
                jsonWriter.endArray();
            }
            if (updateGlobalTableSettingsRequest.getReplicaSettingsUpdate() != null) {
                List<ReplicaSettingsUpdate> replicaSettingsUpdate = updateGlobalTableSettingsRequest.getReplicaSettingsUpdate();
                jsonWriter.name("ReplicaSettingsUpdate");
                jsonWriter.beginArray();
                for (ReplicaSettingsUpdate replicaSettingsUpdateItem : replicaSettingsUpdate) {
                    if (replicaSettingsUpdateItem == null) continue;
                    ReplicaSettingsUpdateJsonMarshaller.getInstance().marshall(replicaSettingsUpdateItem, jsonWriter);
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
            jsonWriter.close();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "application/x-amz-json-1.0");
        }
        return request;
    }
}

