/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.Condition;
import com.amazonaws.services.dynamodbv2.model.QueryRequest;
import com.amazonaws.services.dynamodbv2.model.transform.AttributeValueJsonMarshaller;
import com.amazonaws.services.dynamodbv2.model.transform.ConditionJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.AwsJsonWriter;
import com.amazonaws.util.json.JsonUtils;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.Map;

public class QueryRequestMarshaller
implements Marshaller<Request<QueryRequest>, QueryRequest> {
    public Request<QueryRequest> marshall(QueryRequest queryRequest) {
        if (queryRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(QueryRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)queryRequest, "AmazonDynamoDB");
        String target = "DynamoDB_20120810.Query";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/";
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = new StringWriter();
            AwsJsonWriter jsonWriter = JsonUtils.getJsonWriter((Writer)stringWriter);
            jsonWriter.beginObject();
            if (queryRequest.getTableName() != null) {
                String tableName = queryRequest.getTableName();
                jsonWriter.name("TableName");
                jsonWriter.value(tableName);
            }
            if (queryRequest.getIndexName() != null) {
                String indexName = queryRequest.getIndexName();
                jsonWriter.name("IndexName");
                jsonWriter.value(indexName);
            }
            if (queryRequest.getSelect() != null) {
                String select = queryRequest.getSelect();
                jsonWriter.name("Select");
                jsonWriter.value(select);
            }
            if (queryRequest.getAttributesToGet() != null) {
                List<String> attributesToGet = queryRequest.getAttributesToGet();
                jsonWriter.name("AttributesToGet");
                jsonWriter.beginArray();
                for (String string : attributesToGet) {
                    if (string == null) continue;
                    jsonWriter.value(string);
                }
                jsonWriter.endArray();
            }
            if (queryRequest.getLimit() != null) {
                Integer limit = queryRequest.getLimit();
                jsonWriter.name("Limit");
                jsonWriter.value((Number)limit);
            }
            if (queryRequest.getConsistentRead() != null) {
                Boolean consistentRead = queryRequest.getConsistentRead();
                jsonWriter.name("ConsistentRead");
                jsonWriter.value(consistentRead.booleanValue());
            }
            if (queryRequest.getKeyConditions() != null) {
                Map<String, Condition> keyConditions = queryRequest.getKeyConditions();
                jsonWriter.name("KeyConditions");
                jsonWriter.beginObject();
                for (Map.Entry entry : keyConditions.entrySet()) {
                    Condition keyConditionsValue = (Condition)entry.getValue();
                    if (keyConditionsValue == null) continue;
                    jsonWriter.name((String)entry.getKey());
                    ConditionJsonMarshaller.getInstance().marshall(keyConditionsValue, jsonWriter);
                }
                jsonWriter.endObject();
            }
            if (queryRequest.getQueryFilter() != null) {
                Map<String, Condition> queryFilter = queryRequest.getQueryFilter();
                jsonWriter.name("QueryFilter");
                jsonWriter.beginObject();
                for (Map.Entry entry : queryFilter.entrySet()) {
                    Condition queryFilterValue = (Condition)entry.getValue();
                    if (queryFilterValue == null) continue;
                    jsonWriter.name((String)entry.getKey());
                    ConditionJsonMarshaller.getInstance().marshall(queryFilterValue, jsonWriter);
                }
                jsonWriter.endObject();
            }
            if (queryRequest.getConditionalOperator() != null) {
                String conditionalOperator = queryRequest.getConditionalOperator();
                jsonWriter.name("ConditionalOperator");
                jsonWriter.value(conditionalOperator);
            }
            if (queryRequest.getScanIndexForward() != null) {
                Boolean scanIndexForward = queryRequest.getScanIndexForward();
                jsonWriter.name("ScanIndexForward");
                jsonWriter.value(scanIndexForward.booleanValue());
            }
            if (queryRequest.getExclusiveStartKey() != null) {
                Map<String, AttributeValue> exclusiveStartKey = queryRequest.getExclusiveStartKey();
                jsonWriter.name("ExclusiveStartKey");
                jsonWriter.beginObject();
                for (Map.Entry entry : exclusiveStartKey.entrySet()) {
                    AttributeValue exclusiveStartKeyValue = (AttributeValue)entry.getValue();
                    if (exclusiveStartKeyValue == null) continue;
                    jsonWriter.name((String)entry.getKey());
                    AttributeValueJsonMarshaller.getInstance().marshall(exclusiveStartKeyValue, jsonWriter);
                }
                jsonWriter.endObject();
            }
            if (queryRequest.getReturnConsumedCapacity() != null) {
                String returnConsumedCapacity = queryRequest.getReturnConsumedCapacity();
                jsonWriter.name("ReturnConsumedCapacity");
                jsonWriter.value(returnConsumedCapacity);
            }
            if (queryRequest.getProjectionExpression() != null) {
                String projectionExpression = queryRequest.getProjectionExpression();
                jsonWriter.name("ProjectionExpression");
                jsonWriter.value(projectionExpression);
            }
            if (queryRequest.getFilterExpression() != null) {
                String filterExpression = queryRequest.getFilterExpression();
                jsonWriter.name("FilterExpression");
                jsonWriter.value(filterExpression);
            }
            if (queryRequest.getKeyConditionExpression() != null) {
                String keyConditionExpression = queryRequest.getKeyConditionExpression();
                jsonWriter.name("KeyConditionExpression");
                jsonWriter.value(keyConditionExpression);
            }
            if (queryRequest.getExpressionAttributeNames() != null) {
                Map<String, String> expressionAttributeNames = queryRequest.getExpressionAttributeNames();
                jsonWriter.name("ExpressionAttributeNames");
                jsonWriter.beginObject();
                for (Map.Entry entry : expressionAttributeNames.entrySet()) {
                    String expressionAttributeNamesValue = (String)entry.getValue();
                    if (expressionAttributeNamesValue == null) continue;
                    jsonWriter.name((String)entry.getKey());
                    jsonWriter.value(expressionAttributeNamesValue);
                }
                jsonWriter.endObject();
            }
            if (queryRequest.getExpressionAttributeValues() != null) {
                Map<String, AttributeValue> expressionAttributeValues = queryRequest.getExpressionAttributeValues();
                jsonWriter.name("ExpressionAttributeValues");
                jsonWriter.beginObject();
                for (Map.Entry entry : expressionAttributeValues.entrySet()) {
                    AttributeValue expressionAttributeValuesValue = (AttributeValue)entry.getValue();
                    if (expressionAttributeValuesValue == null) continue;
                    jsonWriter.name((String)entry.getKey());
                    AttributeValueJsonMarshaller.getInstance().marshall(expressionAttributeValuesValue, jsonWriter);
                }
                jsonWriter.endObject();
            }
            jsonWriter.endObject();
            jsonWriter.close();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "application/x-amz-json-1.0");
        }
        return request;
    }
}

