/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.dynamodbv2.model.AttributeDefinition;
import com.amazonaws.services.dynamodbv2.model.CreateGlobalSecondaryIndexAction;
import com.amazonaws.services.dynamodbv2.model.DeleteGlobalSecondaryIndexAction;
import com.amazonaws.services.dynamodbv2.model.GlobalSecondaryIndexUpdate;
import com.amazonaws.services.dynamodbv2.model.KeySchemaElement;
import com.amazonaws.services.dynamodbv2.model.Projection;
import com.amazonaws.services.dynamodbv2.model.ProvisionedThroughput;
import com.amazonaws.services.dynamodbv2.model.StreamSpecification;
import com.amazonaws.services.dynamodbv2.model.UpdateGlobalSecondaryIndexAction;
import com.amazonaws.services.dynamodbv2.model.UpdateTableRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.AwsJsonWriter;
import com.amazonaws.util.json.JsonUtils;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;

public class UpdateTableRequestMarshaller
implements Marshaller<Request<UpdateTableRequest>, UpdateTableRequest> {
    public Request<UpdateTableRequest> marshall(UpdateTableRequest updateTableRequest) {
        if (updateTableRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)updateTableRequest, "AmazonDynamoDBv2");
        String target = "DynamoDB_20120810.UpdateTable";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StreamSpecification streamSpecification;
            ListWithAutoConstructFlag globalSecondaryIndexUpdatesList;
            ProvisionedThroughput provisionedThroughput;
            StringWriter stringWriter = new StringWriter();
            AwsJsonWriter jsonWriter = JsonUtils.getJsonWriter((Writer)stringWriter);
            jsonWriter.beginObject();
            ListWithAutoConstructFlag attributeDefinitionsList = (ListWithAutoConstructFlag)updateTableRequest.getAttributeDefinitions();
            if (!(attributeDefinitionsList == null || attributeDefinitionsList.isAutoConstruct() && attributeDefinitionsList.isEmpty())) {
                jsonWriter.name("AttributeDefinitions");
                jsonWriter.beginArray();
                for (AttributeDefinition attributeDefinitionsListValue : attributeDefinitionsList) {
                    if (attributeDefinitionsListValue == null) continue;
                    jsonWriter.beginObject();
                    if (attributeDefinitionsListValue.getAttributeName() != null) {
                        jsonWriter.name("AttributeName").value(attributeDefinitionsListValue.getAttributeName());
                    }
                    if (attributeDefinitionsListValue.getAttributeType() != null) {
                        jsonWriter.name("AttributeType").value(attributeDefinitionsListValue.getAttributeType());
                    }
                    jsonWriter.endObject();
                }
                jsonWriter.endArray();
            }
            if (updateTableRequest.getTableName() != null) {
                jsonWriter.name("TableName").value(updateTableRequest.getTableName());
            }
            if ((provisionedThroughput = updateTableRequest.getProvisionedThroughput()) != null) {
                jsonWriter.name("ProvisionedThroughput");
                jsonWriter.beginObject();
                if (provisionedThroughput.getReadCapacityUnits() != null) {
                    jsonWriter.name("ReadCapacityUnits").value((Number)provisionedThroughput.getReadCapacityUnits());
                }
                if (provisionedThroughput.getWriteCapacityUnits() != null) {
                    jsonWriter.name("WriteCapacityUnits").value((Number)provisionedThroughput.getWriteCapacityUnits());
                }
                jsonWriter.endObject();
            }
            if (!((globalSecondaryIndexUpdatesList = (ListWithAutoConstructFlag)updateTableRequest.getGlobalSecondaryIndexUpdates()) == null || globalSecondaryIndexUpdatesList.isAutoConstruct() && globalSecondaryIndexUpdatesList.isEmpty())) {
                jsonWriter.name("GlobalSecondaryIndexUpdates");
                jsonWriter.beginArray();
                for (GlobalSecondaryIndexUpdate globalSecondaryIndexUpdatesListValue : globalSecondaryIndexUpdatesList) {
                    DeleteGlobalSecondaryIndexAction delete;
                    CreateGlobalSecondaryIndexAction create;
                    if (globalSecondaryIndexUpdatesListValue == null) continue;
                    jsonWriter.beginObject();
                    UpdateGlobalSecondaryIndexAction update = globalSecondaryIndexUpdatesListValue.getUpdate();
                    if (update != null) {
                        ProvisionedThroughput provisionedThroughput2;
                        jsonWriter.name("Update");
                        jsonWriter.beginObject();
                        if (update.getIndexName() != null) {
                            jsonWriter.name("IndexName").value(update.getIndexName());
                        }
                        if ((provisionedThroughput2 = update.getProvisionedThroughput()) != null) {
                            jsonWriter.name("ProvisionedThroughput");
                            jsonWriter.beginObject();
                            if (provisionedThroughput2.getReadCapacityUnits() != null) {
                                jsonWriter.name("ReadCapacityUnits").value((Number)provisionedThroughput2.getReadCapacityUnits());
                            }
                            if (provisionedThroughput2.getWriteCapacityUnits() != null) {
                                jsonWriter.name("WriteCapacityUnits").value((Number)provisionedThroughput2.getWriteCapacityUnits());
                            }
                            jsonWriter.endObject();
                        }
                        jsonWriter.endObject();
                    }
                    if ((create = globalSecondaryIndexUpdatesListValue.getCreate()) != null) {
                        ProvisionedThroughput provisionedThroughput3;
                        Projection projection;
                        ListWithAutoConstructFlag keySchemaList;
                        jsonWriter.name("Create");
                        jsonWriter.beginObject();
                        if (create.getIndexName() != null) {
                            jsonWriter.name("IndexName").value(create.getIndexName());
                        }
                        if (!((keySchemaList = (ListWithAutoConstructFlag)create.getKeySchema()) == null || keySchemaList.isAutoConstruct() && keySchemaList.isEmpty())) {
                            jsonWriter.name("KeySchema");
                            jsonWriter.beginArray();
                            for (KeySchemaElement keySchemaListValue : keySchemaList) {
                                if (keySchemaListValue == null) continue;
                                jsonWriter.beginObject();
                                if (keySchemaListValue.getAttributeName() != null) {
                                    jsonWriter.name("AttributeName").value(keySchemaListValue.getAttributeName());
                                }
                                if (keySchemaListValue.getKeyType() != null) {
                                    jsonWriter.name("KeyType").value(keySchemaListValue.getKeyType());
                                }
                                jsonWriter.endObject();
                            }
                            jsonWriter.endArray();
                        }
                        if ((projection = create.getProjection()) != null) {
                            ListWithAutoConstructFlag nonKeyAttributesList;
                            jsonWriter.name("Projection");
                            jsonWriter.beginObject();
                            if (projection.getProjectionType() != null) {
                                jsonWriter.name("ProjectionType").value(projection.getProjectionType());
                            }
                            if (!((nonKeyAttributesList = (ListWithAutoConstructFlag)projection.getNonKeyAttributes()) == null || nonKeyAttributesList.isAutoConstruct() && nonKeyAttributesList.isEmpty())) {
                                jsonWriter.name("NonKeyAttributes");
                                jsonWriter.beginArray();
                                for (String nonKeyAttributesListValue : nonKeyAttributesList) {
                                    if (nonKeyAttributesListValue == null) continue;
                                    jsonWriter.value(nonKeyAttributesListValue);
                                }
                                jsonWriter.endArray();
                            }
                            jsonWriter.endObject();
                        }
                        if ((provisionedThroughput3 = create.getProvisionedThroughput()) != null) {
                            jsonWriter.name("ProvisionedThroughput");
                            jsonWriter.beginObject();
                            if (provisionedThroughput3.getReadCapacityUnits() != null) {
                                jsonWriter.name("ReadCapacityUnits").value((Number)provisionedThroughput3.getReadCapacityUnits());
                            }
                            if (provisionedThroughput3.getWriteCapacityUnits() != null) {
                                jsonWriter.name("WriteCapacityUnits").value((Number)provisionedThroughput3.getWriteCapacityUnits());
                            }
                            jsonWriter.endObject();
                        }
                        jsonWriter.endObject();
                    }
                    if ((delete = globalSecondaryIndexUpdatesListValue.getDelete()) != null) {
                        jsonWriter.name("Delete");
                        jsonWriter.beginObject();
                        if (delete.getIndexName() != null) {
                            jsonWriter.name("IndexName").value(delete.getIndexName());
                        }
                        jsonWriter.endObject();
                    }
                    jsonWriter.endObject();
                }
                jsonWriter.endArray();
            }
            if ((streamSpecification = updateTableRequest.getStreamSpecification()) != null) {
                jsonWriter.name("StreamSpecification");
                jsonWriter.beginObject();
                if (streamSpecification.isStreamEnabled() != null) {
                    jsonWriter.name("StreamEnabled").value(streamSpecification.isStreamEnabled().booleanValue());
                }
                if (streamSpecification.getStreamViewType() != null) {
                    jsonWriter.name("StreamViewType").value(streamSpecification.getStreamViewType());
                }
                jsonWriter.endObject();
            }
            jsonWriter.endObject();
            jsonWriter.close();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.0");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

