/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.BatchWriteItemRequest;
import com.amazonaws.services.dynamodbv2.model.DeleteRequest;
import com.amazonaws.services.dynamodbv2.model.PutRequest;
import com.amazonaws.services.dynamodbv2.model.WriteRequest;
import com.amazonaws.services.dynamodbv2.model.transform.AttributeValueJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.AwsJsonWriter;
import com.amazonaws.util.json.JsonUtils;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.Map;

public class BatchWriteItemRequestMarshaller
implements Marshaller<Request<BatchWriteItemRequest>, BatchWriteItemRequest> {
    public Request<BatchWriteItemRequest> marshall(BatchWriteItemRequest batchWriteItemRequest) {
        if (batchWriteItemRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)batchWriteItemRequest, "AmazonDynamoDBv2");
        String target = "DynamoDB_20120810.BatchWriteItem";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StringWriter stringWriter = new StringWriter();
            AwsJsonWriter jsonWriter = JsonUtils.getJsonWriter((Writer)stringWriter);
            jsonWriter.beginObject();
            if (batchWriteItemRequest.getRequestItems() != null) {
                jsonWriter.name("RequestItems");
                jsonWriter.beginObject();
                for (Map.Entry<String, List<WriteRequest>> requestItemsListValue : batchWriteItemRequest.getRequestItems().entrySet()) {
                    if (requestItemsListValue.getValue() == null) continue;
                    jsonWriter.name(requestItemsListValue.getKey());
                    jsonWriter.beginArray();
                    for (WriteRequest valueListValue : requestItemsListValue.getValue()) {
                        DeleteRequest deleteRequest;
                        if (valueListValue == null) continue;
                        jsonWriter.beginObject();
                        PutRequest putRequest = valueListValue.getPutRequest();
                        if (putRequest != null) {
                            jsonWriter.name("PutRequest");
                            jsonWriter.beginObject();
                            if (putRequest.getItem() != null) {
                                jsonWriter.name("Item");
                                jsonWriter.beginObject();
                                for (Map.Entry<String, AttributeValue> itemListValue : putRequest.getItem().entrySet()) {
                                    if (itemListValue.getValue() == null) continue;
                                    jsonWriter.name(itemListValue.getKey());
                                    AttributeValueJsonMarshaller.getInstance().marshall(itemListValue.getValue(), jsonWriter);
                                }
                                jsonWriter.endObject();
                            }
                            jsonWriter.endObject();
                        }
                        if ((deleteRequest = valueListValue.getDeleteRequest()) != null) {
                            jsonWriter.name("DeleteRequest");
                            jsonWriter.beginObject();
                            if (deleteRequest.getKey() != null) {
                                jsonWriter.name("Key");
                                jsonWriter.beginObject();
                                for (Map.Entry<String, AttributeValue> keyListValue : deleteRequest.getKey().entrySet()) {
                                    if (keyListValue.getValue() == null) continue;
                                    jsonWriter.name(keyListValue.getKey());
                                    AttributeValueJsonMarshaller.getInstance().marshall(keyListValue.getValue(), jsonWriter);
                                }
                                jsonWriter.endObject();
                            }
                            jsonWriter.endObject();
                        }
                        jsonWriter.endObject();
                    }
                    jsonWriter.endArray();
                }
                jsonWriter.endObject();
            }
            if (batchWriteItemRequest.getReturnConsumedCapacity() != null) {
                jsonWriter.name("ReturnConsumedCapacity").value(batchWriteItemRequest.getReturnConsumedCapacity());
            }
            if (batchWriteItemRequest.getReturnItemCollectionMetrics() != null) {
                jsonWriter.name("ReturnItemCollectionMetrics").value(batchWriteItemRequest.getReturnItemCollectionMetrics());
            }
            jsonWriter.endObject();
            jsonWriter.close();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.0");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

