/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.model.transform;

import com.amazonaws.services.dynamodbv2.model.GlobalTableDescription;
import com.amazonaws.services.dynamodbv2.model.ReplicaDescription;
import com.amazonaws.services.dynamodbv2.model.transform.ReplicaDescriptionJsonMarshaller;
import com.amazonaws.util.json.AwsJsonWriter;
import java.util.Date;
import java.util.List;

class GlobalTableDescriptionJsonMarshaller {
    private static GlobalTableDescriptionJsonMarshaller instance;

    GlobalTableDescriptionJsonMarshaller() {
    }

    public void marshall(GlobalTableDescription globalTableDescription, AwsJsonWriter jsonWriter) throws Exception {
        jsonWriter.beginObject();
        if (globalTableDescription.getReplicationGroup() != null) {
            List<ReplicaDescription> replicationGroup = globalTableDescription.getReplicationGroup();
            jsonWriter.name("ReplicationGroup");
            jsonWriter.beginArray();
            for (ReplicaDescription replicationGroupItem : replicationGroup) {
                if (replicationGroupItem == null) continue;
                ReplicaDescriptionJsonMarshaller.getInstance().marshall(replicationGroupItem, jsonWriter);
            }
            jsonWriter.endArray();
        }
        if (globalTableDescription.getGlobalTableArn() != null) {
            String globalTableArn = globalTableDescription.getGlobalTableArn();
            jsonWriter.name("GlobalTableArn");
            jsonWriter.value(globalTableArn);
        }
        if (globalTableDescription.getCreationDateTime() != null) {
            Date creationDateTime = globalTableDescription.getCreationDateTime();
            jsonWriter.name("CreationDateTime");
            jsonWriter.value(creationDateTime);
        }
        if (globalTableDescription.getGlobalTableStatus() != null) {
            String globalTableStatus = globalTableDescription.getGlobalTableStatus();
            jsonWriter.name("GlobalTableStatus");
            jsonWriter.value(globalTableStatus);
        }
        if (globalTableDescription.getGlobalTableName() != null) {
            String globalTableName = globalTableDescription.getGlobalTableName();
            jsonWriter.name("GlobalTableName");
            jsonWriter.value(globalTableName);
        }
        jsonWriter.endObject();
    }

    public static GlobalTableDescriptionJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new GlobalTableDescriptionJsonMarshaller();
        }
        return instance;
    }
}

