/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.model.transform;

import com.amazonaws.services.dynamodbv2.model.GlobalSecondaryIndexInfo;
import com.amazonaws.services.dynamodbv2.model.KeySchemaElement;
import com.amazonaws.services.dynamodbv2.model.Projection;
import com.amazonaws.services.dynamodbv2.model.ProvisionedThroughput;
import com.amazonaws.services.dynamodbv2.model.transform.KeySchemaElementJsonMarshaller;
import com.amazonaws.services.dynamodbv2.model.transform.ProjectionJsonMarshaller;
import com.amazonaws.services.dynamodbv2.model.transform.ProvisionedThroughputJsonMarshaller;
import com.amazonaws.util.json.AwsJsonWriter;
import java.util.List;

class GlobalSecondaryIndexInfoJsonMarshaller {
    private static GlobalSecondaryIndexInfoJsonMarshaller instance;

    GlobalSecondaryIndexInfoJsonMarshaller() {
    }

    public void marshall(GlobalSecondaryIndexInfo globalSecondaryIndexInfo, AwsJsonWriter jsonWriter) throws Exception {
        jsonWriter.beginObject();
        if (globalSecondaryIndexInfo.getIndexName() != null) {
            String indexName = globalSecondaryIndexInfo.getIndexName();
            jsonWriter.name("IndexName");
            jsonWriter.value(indexName);
        }
        if (globalSecondaryIndexInfo.getKeySchema() != null) {
            List<KeySchemaElement> keySchema = globalSecondaryIndexInfo.getKeySchema();
            jsonWriter.name("KeySchema");
            jsonWriter.beginArray();
            for (KeySchemaElement keySchemaItem : keySchema) {
                if (keySchemaItem == null) continue;
                KeySchemaElementJsonMarshaller.getInstance().marshall(keySchemaItem, jsonWriter);
            }
            jsonWriter.endArray();
        }
        if (globalSecondaryIndexInfo.getProjection() != null) {
            Projection projection = globalSecondaryIndexInfo.getProjection();
            jsonWriter.name("Projection");
            ProjectionJsonMarshaller.getInstance().marshall(projection, jsonWriter);
        }
        if (globalSecondaryIndexInfo.getProvisionedThroughput() != null) {
            ProvisionedThroughput provisionedThroughput = globalSecondaryIndexInfo.getProvisionedThroughput();
            jsonWriter.name("ProvisionedThroughput");
            ProvisionedThroughputJsonMarshaller.getInstance().marshall(provisionedThroughput, jsonWriter);
        }
        jsonWriter.endObject();
    }

    public static GlobalSecondaryIndexInfoJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new GlobalSecondaryIndexInfoJsonMarshaller();
        }
        return instance;
    }
}

