/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.model;

import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.ConsumedCapacity;
import com.amazonaws.services.dynamodbv2.model.ItemCollectionMetrics;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class PutItemResult
implements Serializable {
    private Map<String, AttributeValue> attributes;
    private ConsumedCapacity consumedCapacity;
    private ItemCollectionMetrics itemCollectionMetrics;

    public Map<String, AttributeValue> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, AttributeValue> attributes) {
        this.attributes = attributes;
    }

    public PutItemResult withAttributes(Map<String, AttributeValue> attributes) {
        this.attributes = attributes;
        return this;
    }

    public PutItemResult addAttributesEntry(String key, AttributeValue value) {
        if (null == this.attributes) {
            this.attributes = new HashMap<String, AttributeValue>();
        }
        if (this.attributes.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.attributes.put(key, value);
        return this;
    }

    public PutItemResult clearAttributesEntries() {
        this.attributes = null;
        return this;
    }

    public ConsumedCapacity getConsumedCapacity() {
        return this.consumedCapacity;
    }

    public void setConsumedCapacity(ConsumedCapacity consumedCapacity) {
        this.consumedCapacity = consumedCapacity;
    }

    public PutItemResult withConsumedCapacity(ConsumedCapacity consumedCapacity) {
        this.consumedCapacity = consumedCapacity;
        return this;
    }

    public ItemCollectionMetrics getItemCollectionMetrics() {
        return this.itemCollectionMetrics;
    }

    public void setItemCollectionMetrics(ItemCollectionMetrics itemCollectionMetrics) {
        this.itemCollectionMetrics = itemCollectionMetrics;
    }

    public PutItemResult withItemCollectionMetrics(ItemCollectionMetrics itemCollectionMetrics) {
        this.itemCollectionMetrics = itemCollectionMetrics;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAttributes() != null) {
            sb.append("Attributes: " + this.getAttributes() + ",");
        }
        if (this.getConsumedCapacity() != null) {
            sb.append("ConsumedCapacity: " + this.getConsumedCapacity() + ",");
        }
        if (this.getItemCollectionMetrics() != null) {
            sb.append("ItemCollectionMetrics: " + this.getItemCollectionMetrics());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAttributes() == null ? 0 : this.getAttributes().hashCode());
        hashCode = 31 * hashCode + (this.getConsumedCapacity() == null ? 0 : this.getConsumedCapacity().hashCode());
        hashCode = 31 * hashCode + (this.getItemCollectionMetrics() == null ? 0 : this.getItemCollectionMetrics().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutItemResult)) {
            return false;
        }
        PutItemResult other = (PutItemResult)obj;
        if (other.getAttributes() == null ^ this.getAttributes() == null) {
            return false;
        }
        if (other.getAttributes() != null && !other.getAttributes().equals(this.getAttributes())) {
            return false;
        }
        if (other.getConsumedCapacity() == null ^ this.getConsumedCapacity() == null) {
            return false;
        }
        if (other.getConsumedCapacity() != null && !other.getConsumedCapacity().equals(this.getConsumedCapacity())) {
            return false;
        }
        if (other.getItemCollectionMetrics() == null ^ this.getItemCollectionMetrics() == null) {
            return false;
        }
        return other.getItemCollectionMetrics() == null || other.getItemCollectionMetrics().equals(this.getItemCollectionMetrics());
    }
}

