/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.dynamodbv2.model.RestoreTableFromBackupRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.AwsJsonWriter;
import com.amazonaws.util.json.JsonUtils;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;

public class RestoreTableFromBackupRequestMarshaller
implements Marshaller<Request<RestoreTableFromBackupRequest>, RestoreTableFromBackupRequest> {
    public Request<RestoreTableFromBackupRequest> marshall(RestoreTableFromBackupRequest restoreTableFromBackupRequest) {
        if (restoreTableFromBackupRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(RestoreTableFromBackupRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)restoreTableFromBackupRequest, "AmazonDynamoDB");
        String target = "DynamoDB_20120810.RestoreTableFromBackup";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/";
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = new StringWriter();
            AwsJsonWriter jsonWriter = JsonUtils.getJsonWriter((Writer)stringWriter);
            jsonWriter.beginObject();
            if (restoreTableFromBackupRequest.getTargetTableName() != null) {
                String targetTableName = restoreTableFromBackupRequest.getTargetTableName();
                jsonWriter.name("TargetTableName");
                jsonWriter.value(targetTableName);
            }
            if (restoreTableFromBackupRequest.getBackupArn() != null) {
                String backupArn = restoreTableFromBackupRequest.getBackupArn();
                jsonWriter.name("BackupArn");
                jsonWriter.value(backupArn);
            }
            jsonWriter.endObject();
            jsonWriter.close();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "application/x-amz-json-1.0");
        }
        return request;
    }
}

