/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.model.transform;

import com.amazonaws.services.dynamodbv2.model.GlobalTable;
import com.amazonaws.services.dynamodbv2.model.Replica;
import com.amazonaws.services.dynamodbv2.model.transform.ReplicaJsonMarshaller;
import com.amazonaws.util.json.AwsJsonWriter;
import java.util.List;

class GlobalTableJsonMarshaller {
    private static GlobalTableJsonMarshaller instance;

    GlobalTableJsonMarshaller() {
    }

    public void marshall(GlobalTable globalTable, AwsJsonWriter jsonWriter) throws Exception {
        jsonWriter.beginObject();
        if (globalTable.getGlobalTableName() != null) {
            String globalTableName = globalTable.getGlobalTableName();
            jsonWriter.name("GlobalTableName");
            jsonWriter.value(globalTableName);
        }
        if (globalTable.getReplicationGroup() != null) {
            List<Replica> replicationGroup = globalTable.getReplicationGroup();
            jsonWriter.name("ReplicationGroup");
            jsonWriter.beginArray();
            for (Replica replicationGroupItem : replicationGroup) {
                if (replicationGroupItem == null) continue;
                ReplicaJsonMarshaller.getInstance().marshall(replicationGroupItem, jsonWriter);
            }
            jsonWriter.endArray();
        }
        jsonWriter.endObject();
    }

    public static GlobalTableJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new GlobalTableJsonMarshaller();
        }
        return instance;
    }
}

